/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: sca_code.c,v 1.8 2005/01/03 21:10:41 ezk Exp $
 */

#include "sca_code.h"
#include "sca_aux.h"


int
sca_encode_page(unsigned char *in, int inlen, unsigned char **out, int *outlen)
{
  if ((*out = (unsigned char *) malloc(inlen)) == NULL) {
    perror("malloc");
    return(-1);
  }

  memcpy(*out, in, inlen);
  *outlen = inlen;
  return(inlen);
}


int
sca_decode_page(unsigned char *in, int inlen, unsigned char **out, int *outlen)
{
  if ((*out = (unsigned char *) malloc(inlen)) == NULL) {
    perror("malloc");
    return(-1);
  }

  memcpy(*out, in, inlen);
  *outlen = inlen;
  return(inlen);
}


int
sca_fix_idx(char *name)
{
  int srcfd;
  unsigned char *ptr, *data;
  char filename[PATH_MAX];
  int cnt, rc, offset = 0, remainder;
  struct fistfs_header hdr;
  struct stat sb;

  hdr.num_pages = 0;
  hdr.real_size = 0;
  hdr.offsets = NULL;

  if (name == NULL)
    return(-1);
  if ((srcfd = open(name,O_RDONLY)) < 0)
    return(-1);

  if (do_fast_tails)
    hdr.flags |= 0x80000000;

  if ((ptr = strrchr(name,'.')) == NULL) {
    fprintf(stderr, "No .gzf suffix, creating %s.idx\n", name);
    sprintf(filename, "%s.idx", name);
  } else {
    ptr[0] = '\0';
    strncpy(filename, name, PATH_MAX-5);
    cnt = strlen(filename);
    filename[cnt] = '.';
    filename[cnt+1] = 'i';
    filename[cnt+2] = 'd';
    filename[cnt+3] = 'x';
    fprintf(stderr, "Creating %s\n", filename);
  }

  if ((fstat(srcfd,&sb)) < 0)
    return(-1);

  cnt = (sb.st_size/chunksize);
  if ((do_fast_tails == 0) && (sb.st_size % chunksize))
    cnt++;

  if ((hdr.offsets = (off_t *) malloc (sizeof(off_t) * cnt)) == NULL) {
    return(-1);
  }
  hdr.num_pages = cnt;
  for (rc=0; rc<cnt; rc++) {
    hdr.offsets[rc] = (rc+1) * chunksize;
  }
  if (do_fast_tails == 0)
    hdr.offsets[rc-1] = sb.st_size;

  hdr.real_size = sb.st_size;

  if (write_idx(filename, &hdr) < 0) {
    fprintf(stderr, "Error writing %s (%d)\n", filename, errno);
    return(-1);
  }
  return(0);
}
