/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * fist_getkey: get the Initialization Vector (IV) from wrapfs.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#include <fist.h>
#include <wrapfs.h>

int
main(int argc, char *argv[])
{
  int fd, ret, i;
  struct _fist_ioctl_GETIV val;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s file\n", argv[0]);
    exit(1);
  }
  fd = open(argv[1], O_RDONLY);
  if (fd < 0) {
    perror(argv[1]);
    exit(1);
  }
  ret = ioctl(fd, FIST_IOCTL_GETIV, &(val.outiv));
  if (ret < 0) {
    perror("ioctl");
  }
  close(fd);
  for (i=0; i<sizeof(val.outiv); i++)
    printf("IV[%d] = 0x%x\n", i, (int) val.outiv[i]);
  exit(ret);
}
