/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * fist_setkey: set an cipher key for wrapfs.
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <fist.h>
#include <wrapfs.h>

int
main(int argc, char *argv[])
{
  int fd, ret;
  struct _fist_ioctl_SETKEY val;

  if (argc != 2) {
    fprintf(stderr, "Usage: %s file\n", argv[0]);
    exit(1);
  }
  fd = open(argv[1], O_RDONLY);
  if (fd < 0) {
    perror(argv[1]);
    exit(1);
  }
  printf("Enter key: ");
  memset(val.ukey, 0, 16);
  fgets(val.ukey, 16, stdin);

  ret = ioctl(fd, FIST_IOCTL_SETKEY, &val);
  if (ret < 0) {
    perror("ioctl");
  }
  close(fd);
  exit(ret);
}
