/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * ecl.c: expanded code lines
 * Fistgen sources.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


/*
 * check if we can add string to an ECL string
 * Return TRUE/FALSE if succeeded.
 */
int
ecl_strcat(ecl_t *eclp, const char *str)
{
  u_int len;
  char *s2 = (char *) str;	/* s2 may strip leading WS from str */

  if (!eclp->max)		/* skip leading whitespace */
    while (s2 && isspace((int) *s2))
      s2++;

  if (!s2 || !s2[0])
    return TRUE;		/* nothing to do */
  if (!eclp)
    return FALSE;		/* cannot append to a null ECL */

  /* check if need to allocate for the first time */
  if (!eclp->max) {
    eclp->max = MAX_BUF_LEN;
    eclp->buf = (char *) malloc(eclp->max);
    eclp->buf[0] = '\0';
  }

  /* check if need to realloc (double buffer size) */
  len = strlen(s2);
  while (eclp->len + len + 1 > eclp->max) {
    eclp->max *= 2;
    eclp->buf = realloc(eclp->buf, eclp->max);
  }

  /* copy string */
  strcat(eclp->buf, s2);
  eclp->len += len;

  return TRUE;
}


/*
 * check if we can add a single char to an ECL string
 * Return TRUE/FALSE if succeeded.
 */
int
ecl_putc(ecl_t *eclp, char c)
{

  if (!eclp)
    return FALSE;		/* cannot append to a null ECL */

  /* check if need to allocate for the first time */
  if (!eclp->max) {
    /* skip leading whitespace */
    if (isspace((int) c))
      return TRUE;
    eclp->max = MAX_BUF_LEN;
    eclp->buf = (char *) malloc(eclp->max);
    eclp->buf[0] = '\0';
  }

  /* check if need to realloc (double buffer size) */
  while (eclp->len + 21 > eclp->max) {
    eclp->max *= 2;
    eclp->buf = realloc(eclp->buf, eclp->max);
  }

  /* copy string */
  eclp->buf[eclp->len] = c;
  eclp->len++;
  eclp->buf[eclp->len] = '\0';

  return TRUE;
}


/*
 * Print fist rule
 */
void
print_fist_rules(void)
{
  int i;

  for (i=0; i<fist_rules.fr_num_rules; i++) {
    fprintf(stderr, "==============================================================================\n");
    fprintf(stderr, "RULE: %d\n", i+1);
    fprintf(stderr, "CallSet: %s\n", fist_rules.fr_callset[i]);
    fprintf(stderr, "OpType: %s\n", fist_rules.fr_optype[i]);
    fprintf(stderr, "Part: %s\n", fist_rules.fr_part[i]);
    fprintf(stderr, "Tag: %s\n", fist_rules.fr_tag[i]);
    fprintf(stderr, "ECL: max=%d, len=%d, buf=0x%x\n",
	    fist_rules.fr_code[i]->max, fist_rules.fr_code[i]->len,
	    (int) fist_rules.fr_code[i]->buf);
    fprintf(stderr, "------------------------------------------------------------------------------\n");
    fprintf(stderr, "%s\n",
	    fist_rules.fr_code[i]->buf ? fist_rules.fr_code[i]->buf : "NULL");
    fprintf(stderr, "------------------------------------------------------------------------------\n");

  }
}
