/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * fist.h: main header file for fistgen
 * Fistgen sources.
 */

#define MAX_ERRORCODES		10
#define MAX_SOURCES		30
#define MAX_MNTFLAGS		10
#define MAX_FAN_OUT		10	/* just in case */
#define MAX_ENCODING_BLOCKSIZE	4096	/* in bytes */
#define MAX_FILE_FORMATS	10
#define MAX_IOCTLS		10
#define MAX_RULES		20
#define	MAX_FSNAME_LEN		80
#define	MAX_BUF_LEN		512
#define MAX_FUNCARGS		10


#define STREQ(x,y)	(!strcmp((x),(y)))

/*
 * TRUE and FALSE get defined so many times,
 * let's not get in the way of other definitions.
 */
#if !defined(TRUE) || ((TRUE) != 1)
# define TRUE	 (1)
#endif
#if !defined(FALSE) || ((FALSE) != 0)
# define FALSE	 (0)
#endif
#if !defined(ERR) || ((ERR) != -1)
# define ERR	 (-1)
#endif
#if !defined(OK) || ((OK) != 0)
# define OK	 (0)
#endif

#define NEGATE(x) ((x) ? (0) : (1))

#ifndef MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#endif /* MIN */
#ifndef MAX
# define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#endif /* MAX */

/* fist flags */
#define FF_ACCESSMODE_READONLY		0x1
#define FF_ACCESSMODE_WRITEONLY		0x2
#define FF_ACCESSMODE_READWRITE		0x4
#define FF_FILTER_DATA			0x1
#define FF_FILTER_NAME			0x2
#define FF_FILTER_SCA			0x4 /* size-changing algorithm */
#define FF_MNTSTYLE_REGULAR		0x1
#define FF_MNTSTYLE_OVERLAY		0x2
#define FF_MNTSTYLE_ATTACH		0x4
#define FF_IOCTL_BOTH			0x1
#define FF_IOCTL_FROMUSER		0x2
#define FF_IOCTL_TOUSER			0x4
#define FF_IOCTL_NONE			0x8
#define FF_ENCODING_TYPE_NONE		0x1
#define FF_ENCODING_TYPE_STREAM		0x2
#define FF_ENCODING_TYPE_BLOCK		0x4


/* basic data types */
typedef struct bdt {
  char *full_line;
  char *symbol_name;
#if 0
  char *symbol_type;		/* not used yet */
#endif
  struct bdt *next;
} bdt_t;

/* expanded code lines */
typedef struct ecl {
  char *buf;
  u_int len;			/* current strlen in buf (w/o null) */
  u_int max;			/* maximum allocated data in buf */
} ecl_t;

typedef struct fist_globals {
  char fg_fsname[MAX_FSNAME_LEN]; /* name of file system */
  char fg_upper_fsname[MAX_FSNAME_LEN]; /* uppercase name of file system */

  u_int fg_accessmode;		/* readonly, writeonly, _readwrite_ */
  u_int fg_debug;		/* on (1), _off_ (0) */
  u_int fg_dynamic_inode_numbers; /* on (1), _off_ (0) */
  u_int fg_filter;		/* data, name. sca */
  u_int fg_mntstyle;		/* _regular_ (0), overlay (1), attach (2) */

  u_int fg_fanout;		/* _1_, 2, 3 */

  u_int fg_encoding_type;	/* none, stream, _block_ */
  u_int fg_encoding_blocksize;	/* _1_, 2, 3, ..., 8, ..., 4096 */

  char *fg_errorcodes[MAX_ERRORCODES];
  u_int fg_num_errorcodes;

  char *fg_msources[MAX_SOURCES]; /* msources: module sources */
  u_int fg_num_msources;
  char *fg_mheaders[MAX_SOURCES]; /* mheaders: module headers */
  u_int fg_num_mheaders;
  char *fg_usources[MAX_SOURCES]; /* usources: user-level sources */
  u_int fg_num_usources;

  char *fg_mntflags[MAX_MNTFLAGS];
  u_int fg_num_mntflags;

  bdt_t *fg_mntdata;		/* mount data BDTs */
  bdt_t *fg_pervfs;		/* per-VFS BDTs */
  bdt_t *fg_pervnode;		/* per-Vnode BDTs */

  char *fg_fileformat_name[MAX_FILE_FORMATS]; /* name of file format */
  bdt_t *fg_fileformat[MAX_FILE_FORMATS]; /* file format BDTs */
  u_int fg_num_fileformats;

  char *fg_ioctl_name[MAX_IOCTLS]; /* name of ioctl */
  bdt_t *fg_ioctl[MAX_IOCTLS];	/* ioctl BDTs */
  u_int fg_ioctl_type[MAX_IOCTLS]; /* ioctl types */
  u_int fg_num_ioctls;

  const char *fg_addmk;		/* additional makefile rules */
  const char *fg_license;	/* license string */

} fist_globals_t;

typedef struct fist_rules {
  u_int fr_num_rules;
  char *fr_callset[MAX_RULES];	/* "op" */
  char *fr_optype[MAX_RULES];	/* "lookup" */
  char *fr_part[MAX_RULES];	/* "postcall" */
  char *fr_tag[MAX_RULES];	/* "OP_LOOKUP_POSTCALL" */
  ecl_t *fr_code[MAX_RULES];	/* code to replace tag with */
} fist_rules_t;

/* structure containing expansion functions for each fword matched */
typedef struct _fword_exp_fxn {
  char *name;
  void (*func)(char *buf, void *data);
} fword_exp_fxn_t;

/* structure containing expansion functions for each auxiliary function */
typedef struct _aux_exp_fxn {
  char *auxname;
  int min_args, max_args;
  int (*func)(char *buf, int argc, char *argv[]);
} aux_exp_fxn_t;


extern fist_globals_t fist_globals;
extern fist_rules_t fist_rules;
extern FILE *out_fp_h, *out_fp_c;
extern char fs_name[MAX_FSNAME_LEN], in_file[], in_dir[];
extern const char *current_file;
extern int parsing_fist_rules;
extern FILE *fyyin, *fyyout, *wyyin, *wyyout;
extern int fyyparse(void), wyyparse(void);
extern time_t start_time;
extern bdt_t *auto_generated_functions;
extern ecl_t auto_generated_externs;
extern int need_aux_sources;

extern int fist_validate_global_variable(const char *str);
extern int fist_validate_dollar_variable(const char *str, const char *dv, const char *dn, const char *da, char *errmsg);
extern int fist_validate_decl_accessmode(const char *str);
extern int fist_validate_decl_debug(const char *str);
extern int fist_validate_decl_dynamic_inode_numbers(const char *str);
extern int fist_validate_decl_filter(const char *str);
extern int fist_validate_decl_mntstyle(const char *str);
extern int fist_validate_decl_fanout(int fo);
extern int fist_validate_decl_encoding_type(const char *str);
extern int fist_validate_decl_encoding_blocksize(int ebs);
extern int fist_validate_decl_errorcode(const char *str, char *errmsg);
extern int fist_validate_decl_msources(const char *str, char *errmsg);
extern int fist_validate_decl_mheaders(const char *str, char *errmsg);
extern int fist_validate_decl_usources(const char *str, char *errmsg);
extern int fist_validate_decl_addmk(const char *str, char *errmsg);
extern int fist_validate_decl_mntflag(const char *str, char *errmsg);
extern int append_to_bdt(bdt_t **bhead, const char *full_line, const char *symbol_name);
extern void print_bdt(bdt_t *bhead);
extern void free_bdt_list(bdt_t **bhead);
extern int fist_search_bdt(const char *str, bdt_t *bdt);
extern int fist_validate_decl_fileformat(const char *str, bdt_t *bdt, char *errmsg);
extern int fist_validate_decl_ioctl(const char *str, const char *type, bdt_t *bdt, char *errmsg);
extern int fist_validate_rule_part(const char *str);
extern int fist_validate_rule_def(const char *str, char *errmsg, ecl_t **eclpp);
extern int fist_validate_rule_tag(const char *str);
extern int ecl_strcat(ecl_t *eclp, const char *str);
extern int ecl_putc(ecl_t *eclp, char c);
extern void print_fist_rules(void);
extern const char *expand_pct_var(const char *var);
extern const char *expand_dollar_var(const char *var, const char *dv, const char *dn, const char *da);
extern int expand_fist_fxn(char *buf, const char *fxn, int argc, char *argv[]);
extern void generate_header(void);
extern char *replace_fsname(const char *in_str);
extern int equal_files(const char *f1, const char *f2);
extern void stk_init(void);
extern void stk_push(int val);
extern int stk_pop(void);
extern int stk_top(void);
extern void symtab_add(const char *name, int val);
extern int symtab_val(const char *name);
extern void gen_code(const char *in_name, const char *out_name);
extern void expand_fword(const char *fword);
extern void wyy_echo(const char *s);
extern void copy_if_newer(const char *f1, const char *f2);
extern void print_auto_generated_functions(FILE *fp);
extern void lowercase_string(char *str);
extern void uppercase_string(char *str);

/* OS specific stuff */
/*--------------------------------------------------------------------------*/
#if defined(__linux__)
/* definitions for Linux */
# define FIST_PAGE_SIZE "PAGE_SIZE"
# define FIST_COPY_FROM_USER_4_IOCTL \
"copy_from_user((char *)&this_ioctl, arg, sizeof(this_ioctl));\n" \
" if (ret != 0)\n" \
"   ret = -EFAULT;"
# define FIST_COPY_TO_USER_4_IOCTL \
"copy_to_user(arg,(char *)&this_ioctl, sizeof(this_ioctl));\n" \
" if (ret != 0)\n" \
"   ret = -EFAULT;"
# define FIST_MEMCPY_4_FROM_IOCTL "memcpy(out, &this_ioctl.%s, len)"
# define FIST_MEMCPY_4_TO_IOCTL "memcpy(&this_ioctl.%s, in, len)"
# define FIST_MEMCPY_4_FF_READ "memcpy(out, &this_ff.%s, len)"
# define FIST_MEMCPY_4_FF_WRITE "memcpy(&this_ff.%s, in, len)"
# define FIST_KMEM_ALLOC "kmalloc(%s, GFP_KERNEL)"
/* XXX: fix this so fistgen generates kfree() code directly */
# define FIST_KMEM_FREE "kfree_s(%s, %s)"
# define FIST_PCT_UID "current->fsuid"
# define FIST_PCT_GID "current->fsgid"
# define FIST_PCT_PID "current->pid"
# define FIST_DA_USER "i_uid"
# define FIST_DA_GROUP "i_gid"
# define FIST_DA_INUM "i_ino"
# define FIST_DIR_TO_VNODE "->d_inode"

/*--------------------------------------------------------------------------*/
#elif defined(__solaris__)
/* definitions for Solaris */
# define FIST_PAGE_SIZE "PAGESIZE"
# define FIST_COPY_FROM_USER_4_IOCTL "copyin(arg, (char *)&this_ioctl, sizeof(this_ioctl))"
# define FIST_COPY_TO_USER_4_IOCTL "copyout((char *)&this_ioctl, arg, sizeof(this_ioctl))"
# define FIST_MEMCPY_4_FROM_IOCTL "bcopy(&this_ioctl.%s, out, len)"
# define FIST_MEMCPY_4_TO_IOCTL "bcopy(in, &this_ioctl.%s, len)"
# define FIST_MEMCPY_4_FF_READ "bcopy(&this_ff.%s, out, len)"
# define FIST_MEMCPY_4_FF_WRITE "bcopy(in, &this_ff.%s, len)"
# define FIST_KMEM_ALLOC "kmem_zalloc(%s, KM_SLEEP)"
# define FIST_KMEM_FREE "kmem_free(%s, %s)"
# define FIST_PCT_UID "cr->cr_uid"
# define FIST_PCT_GID "cr->cr_gid"
# define FIST_PCT_PID "curproc->p_pidp->pid_id"
# define FIST_DA_USER "do not use this: auto-generated getattr function"
# define FIST_DA_GROUP "do not use this: auto-generated getattr function"
# define FIST_DA_INUM "do not use this: auto-generated getattr function"
# define FIST_DIR_TO_VNODE ""

/*--------------------------------------------------------------------------*/
#elif defined(__freebsd__)
/* definitions for FreeBSD */
# define FIST_PAGE_SIZE "PAGE_SIZE"
# define FIST_COPY_FROM_USER_4_IOCTL "bcopy(arg, (char *)&this_ioctl, sizeof(this_ioctl))"
# define FIST_COPY_TO_USER_4_IOCTL "bcopy((char *)&this_ioctl, arg, sizeof(this_ioctl))"
# define FIST_MEMCPY_4_FROM_IOCTL "bcopy(&this_ioctl.%s, out, len)"
# define FIST_MEMCPY_4_TO_IOCTL "bcopy(in, &this_ioctl.%s, len)"
# define FIST_MEMCPY_4_FF_READ "bcopy(&this_ff.%s, out, len)"
# define FIST_MEMCPY_4_FF_WRITE "bcopy(in, &this_ff.%s, len)"
# define FIST_KMEM_ALLOC "malloc(%s, M_TEMP, M_WAITOK)"
# define FIST_KMEM_FREE "free(%s, M_TEMP)"
# define FIST_PCT_UID "cr->cr_uid"
# define FIST_PCT_GID "cr->cr_groups[0]"
# define FIST_PCT_PID "curproc->p_pid"
# define FIST_DA_USER "do not use this: auto-generated getattr function"
# define FIST_DA_GROUP "do not use this: auto-generated getattr function"
# define FIST_DA_INUM "do not use this: auto-generated getattr function"
# define FIST_DIR_TO_VNODE ""

/*--------------------------------------------------------------------------*/
#else /* neither __linux__ nor __solaris__ */
# error unknown operating system
#endif /* neither __linux__ nor __solaris__ */
