/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
%{
/*
 * fparse.y: parser for FiST language
 * Fistgen sources.
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

extern char *yytext;
extern int fyylex(void);
extern int fyylineno;
extern void free(void *);

static int yyerror(const char *s);
static void fyy_echo(const char *s);
static void add_func_arg(const char *s);

static char *dv, *dn, *da;
static char buf[MAX_BUF_LEN], errmsg[MAX_BUF_LEN], fxnbuf[MAX_BUF_LEN];
static bdt_t *tmp_bdt = NULL;
ecl_t *tmp_ecl = NULL;
int num_func_args, parsing_fist_fxn;
static char *func_args[MAX_FUNCARGS];

#define YYDEBUG 0
#define PARSE_DEBUG 0

#if PARSE_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), fyylineno, (s))
# define fist_return(v)
#else /* not PARSE_DEBUG */
# define dprintf(f,s)
# define fist_return(v) return((v))
#endif /* not PARSE_DEBUG */

static int parsedebug;

%}

%union {
char *strtype;
int inttype;
}

%token NEWLINE SEMICOLON COLON
%token LEFT_BRACE RIGHT_BRACE
%token LEFT_BRACKET RIGHT_BRACKET
%token LEFT_PAREN RIGHT_PAREN
%token DOUBLE_PCT PCT_LEFT PCT_RIGHT
%token <strtype> PCT_KEY DOLLAR_KEY
%token <strtype> WORD PCT_ALPHA
%token <inttype> NUMBER
%token <strtype> CODELINE
%token <strtype> MISC
%token <strtype> DOLLAR_VNA
%token <strtype> DOLLAR_VN DOLLAR_NA DOLLAR_VA
%token <strtype> DOLLAR_V DOLLAR_N
%token <strtype> FIST_FXN FIST_RULE_DEF FUNCARG
%token <strtype> MSOURCE_LIST USOURCE_LIST MHEADER_LIST ADDMK_LIST
%token <strtype> LICENSE

%start file
%%

/****************************************************************************/
file		: {
		   fyylineno = 1;
#if YYDEBUG != 0
		   yydebug = YYDEBUG;
#endif /* YYDEBUG != 0 */
		   parsedebug = PARSE_DEBUG;
		  } sections
		;

sections	: opt_decls_sect fist_decls_sect fist_rules_sect opt_code_sect
		;

/****************************************************************************/
opt_decls_sect	: PCT_LEFT opt_decls_lines PCT_RIGHT
		| PCT_LEFT PCT_RIGHT
		| /* can be empty */
		;

opt_decls_lines	: opt_decls_line
		| opt_decls_line opt_decls_lines
		;

opt_decls_line	: CODELINE
		{
		  if (parsedebug)
		    fprintf(stderr, "opt_decl1 = \"%s\"\n", $1 ? $1 : "null");
		  fprintf(out_fp_h, "%s", $1);
		}
		;

/****************************************************************************/

fist_decls_sect	: fist_decls
		| /* can be empty */
		;

fist_decls	: fist_decl
		| fist_decl fist_decls
		;

fist_decl	: WORD WORD SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "WORD+WORD LINE! %s %s\n", $1, $2);
		  if (STREQ($1, "accessmode")) {
		    if (parsedebug)
		      fprintf(stderr, "accessmode +%s\n", $2);
		    if (!fist_validate_decl_accessmode($2)) {
		      yyerror("unknown FiST accessmode");
		      YYABORT;
		    }

		  } else if (STREQ($1, "debug")) {
		    if (parsedebug)
		      fprintf(stderr, "debug +%s\n", $2);
		    if (!fist_validate_decl_debug($2)) {
		      yyerror("unknown FiST debug flag");
		      YYABORT;
		    }

		  } else if (STREQ($1, "dynamic_inode_numbers")) {
		    if (parsedebug)
		      fprintf(stderr, "dynamic_inode_numbers +%s\n", $2);
		    if (!fist_validate_decl_dynamic_inode_numbers($2)) {
		      yyerror("unknown FiST dynamic_inode_numbers flag");
		      YYABORT;
		    }

		  } else if (STREQ($1, "encoding_type")) {
		    if (parsedebug)
		      fprintf(stderr, "encoding_type +%s\n", $2);
		    if (!fist_validate_decl_encoding_type($2)) {
		      yyerror("unknown FiST encoding_type flag");
		      YYABORT;
		    }

		  } else if (STREQ($1, "errorcode")) {
		    if (parsedebug)
		      fprintf(stderr, "errorcode +%s\n", $2);
		    if (!fist_validate_decl_errorcode($2, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }

		  } else if (STREQ($1, "filter")) {
		    if (parsedebug)
		      fprintf(stderr, "filter +%s\n", $2);
		    if (!fist_validate_decl_filter($2)) {
		      yyerror("unknown FiST filter type");
		      YYABORT;
		    }

		  } else if (STREQ($1, "fsname")) {
		    if (parsedebug)
		      fprintf(stderr, "fsname +%s\n", $2);
		    if (STREQ(fist_globals.fg_fsname, $2))
		      strcpy(fist_globals.fg_fsname, $2);
		    else {
		      yyerror("not allowed to override fsname (taken from the fist file)");
		      YYABORT;
		    }

		  } else if (STREQ($1, "mntflag")) {
		    if (parsedebug)
		      fprintf(stderr, "mntflag +%s\n", $2);
		    if (!fist_validate_decl_mntflag($2, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }

		  } else if (STREQ($1, "mntstyle")) {
		    if (parsedebug)
		      fprintf(stderr, "mntstyle +%s\n", $2);
		    if (!fist_validate_decl_mntstyle($2)) {
		      yyerror("unknown FiST mntstyle flag");
		      YYABORT;
		    }

		  } else {
		    yyerror("unknown FiST declaration (word argument)");
		    YYABORT;
		  }
		}
		| WORD NUMBER SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "WORD+NUMBER LINE! %s %d\n", $1, $2);
		  if (STREQ($1, "fanout")) {
		    if (parsedebug)
		      fprintf(stderr, "fanout +%d\n", $2);
		    if (!fist_validate_decl_fanout($2)) {
		      yyerror("bad FiST fanout value");
		      YYABORT;
		    }
		  } else if (STREQ($1, "encoding_blocksize")) {
		    if (parsedebug)
		      fprintf(stderr, "encoding_blocksize +%d\n", $2);
		    if (!fist_validate_decl_encoding_blocksize($2)) {
		      yyerror("bad FiST encoding_blocksize value");
		      YYABORT;
		    }
		  } else {
		    yyerror("unknown FiST declaration (numeric argument)");
		    YYABORT;
		  }
		}
		| WORD LEFT_BRACE basic_data_types RIGHT_BRACE SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "WORD BDT line: %s\n", $1);
		  if (STREQ($1, "mntdata")) {
		    if (parsedebug)
		      fprintf(stderr, "mntdata\n");
		    if (fist_globals.fg_mntdata) {
		      yyerror("already defined mntdata");
		      YYABORT;
		    }
		    fist_globals.fg_mntdata = tmp_bdt;
		    tmp_bdt = NULL; /* do not free it */

		  } else if (STREQ($1, "pervfs")) {
		    if (parsedebug)
		      fprintf(stderr, "pervfs\n");
		    if (fist_globals.fg_pervfs) {
		      yyerror("already defined pervfs");
		      YYABORT;
		    }
		    fist_globals.fg_pervfs = tmp_bdt;
		    tmp_bdt = NULL; /* do not free it */

		  } else if (STREQ($1, "pervnode")) {
		    if (parsedebug)
		      fprintf(stderr, "pervnode\n");
		    if (fist_globals.fg_pervnode) {
		      yyerror("already defined pervnode");
		      YYABORT;
		    }
		    fist_globals.fg_pervnode = tmp_bdt;
		    tmp_bdt = NULL; /* do not free it */

		  } else {
		    yyerror("unknown FiST declaration (word+bdt argument)");
		    YYABORT;
		  }
		}
		| WORD WORD LEFT_BRACE basic_data_types RIGHT_BRACE SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "WORD WORD BDT line: %s\n", $1);
		  if (STREQ($1, "fileformat")) {
		    if (parsedebug)
		      fprintf(stderr, "fileformat +%s\n", $2);
		    if (!fist_validate_decl_fileformat($2, tmp_bdt, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    tmp_bdt = NULL; /* do not free it */

		  } else if (STREQ($1, "ioctl")) {
		    if (parsedebug)
		      fprintf(stderr, "ioctl +%s\n", $2);
		    if (!fist_validate_decl_ioctl($2, "both", tmp_bdt, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    tmp_bdt = NULL; /* do not free it */

		  } else {
		    yyerror("unknown FiST declaration (word+word+bdt argument)");
		    YYABORT;
		  }
		}
		| WORD COLON WORD WORD LEFT_BRACE basic_data_types RIGHT_BRACE SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "WORD:WORD WORD BDT line: %s\n", $1);
		  if (STREQ($1, "ioctl")) {
		    if (parsedebug)
		      fprintf(stderr, "ioctl:%s +%s\n", $3, $4);
		    if (!fist_validate_decl_ioctl($4, $3, tmp_bdt, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    tmp_bdt = NULL; /* do not free it */

		  } else {
		    yyerror("unknown FiST declaration (word:word+word+bdt argument)");
		    YYABORT;
		  }
		}
		| MSOURCE_LIST SEMICOLON
		{
		  char *cp;
		  if (parsedebug)
		    fprintf(stderr, "mod_src: %s\n", $1);

		  cp = strtok($1, " \t");
		  while (cp) {
		    if (!fist_validate_decl_msources(cp, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    cp = strtok(NULL, " \t");
		  }
		}
		| MHEADER_LIST SEMICOLON
		{
		  char *cp;
		  if (parsedebug)
		    fprintf(stderr, "mod_hdr: %s\n", $1);

		  cp = strtok($1, " \t");
		  while (cp) {
		    if (!fist_validate_decl_mheaders(cp, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    cp = strtok(NULL, " \t");
		  }
		}
		| USOURCE_LIST SEMICOLON
		{
		  char *cp;
		  if (parsedebug)
		    fprintf(stderr, "user_src: %s\n", $1);

		  cp = strtok($1, " \t");
		  while (cp) {
		    if (!fist_validate_decl_usources(cp, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    cp = strtok(NULL, " \t");
		  }
		}
		| ADDMK_LIST SEMICOLON
		{
		  char *cp;
		  if (parsedebug)
		    fprintf(stderr, "add_mk: %s\n", $1);

		  cp = strtok($1, " \t");
		  while (cp) {
		    if (!fist_validate_decl_addmk(cp, errmsg)) {
		      yyerror(errmsg);
		      YYABORT;
		    }
		    cp = strtok(NULL, " \t");
		  }
		}
		| LICENSE SEMICOLON
		{
		  char *cp;
		  if (parsedebug)
		    fprintf(stderr, "license: %s\n", $1);

		  if (!fist_validate_decl_license($1, errmsg)) {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		;

basic_data_types: basic_data_type
		| basic_data_type basic_data_types
		;

basic_data_type	: WORD WORD SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s\n", $1, $2);
		  sprintf(buf, "\t%s %s;\n", $1, $2);
		  if (!append_to_bdt(&tmp_bdt, buf, $2)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		| WORD WORD WORD SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s %s\n", $1, $2, $3);
		  sprintf(buf, "\t%s %s %s;\n", $1, $2, $3);
		  if (!append_to_bdt(&tmp_bdt, buf, $3)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		| WORD WORD LEFT_BRACKET NUMBER RIGHT_BRACKET SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s [%d]\n", $1, $2, $4);
		  sprintf(buf, "\t%s %s [%d];\n", $1, $2, $4);
		  if (!append_to_bdt(&tmp_bdt, buf, $2)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		| WORD WORD LEFT_BRACKET WORD RIGHT_BRACKET SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s [%s]\n", $1, $2, $4);
		  sprintf(buf, "\t%s %s [%s];\n", $1, $2, $4);
		  if (!append_to_bdt(&tmp_bdt, buf, $2)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		| WORD WORD WORD LEFT_BRACKET NUMBER RIGHT_BRACKET SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s %s [%d]\n", $1, $2, $3, $5);
		  sprintf(buf, "\t%s %s %s [%d];\n", $1, $2, $3, $5);
		  if (!append_to_bdt(&tmp_bdt, buf, $3)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		| WORD WORD WORD LEFT_BRACKET WORD RIGHT_BRACKET SEMICOLON
		{
		  if (parsedebug)
		    fprintf(stderr, "BDT: %s %s %s [%s]\n", $1, $2, $3, $5);
		  sprintf(buf, "\t%s %s %s [%s];\n", $1, $2, $3, $5);
		  if (!append_to_bdt(&tmp_bdt, buf, $3)) {
		    yyerror("duplicate basic-data-type symbol");
		    YYABORT;
		  }
		}
		;

/****************************************************************************/

fist_rules_sect	: DOUBLE_PCT fist_rules
		| DOUBLE_PCT /* can be without any rules */
		;

fist_rules	: fist_rule
		| fist_rule fist_rules
		;

fist_rule	: FIST_RULE_DEF LEFT_BRACE statement_list RIGHT_BRACE
		{
		  if (parsedebug)
		    fprintf(stderr, "FIST_RULE_DEF: %s\n", $1);
		  if (!fist_validate_rule_def($1, errmsg, &tmp_ecl)) {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		;

statement_list	: statement
		| statement statement_list
		;

statement	: compound_statement
		| single_item
		;

compound_statement : LEFT_BRACE statement_list RIGHT_BRACE
		| LEFT_BRACE RIGHT_BRACE
		;

single_item	: fist_var
		| fist_fxn
		| SEMICOLON
		;

/*
fist_vars_or_fxns : fist_var_or_fxn
		| fist_var_or_fxn fist_vars_or_fxns
		;

fist_var_or_fxn : fist_var
		| fist_fxn
		;
*/

/****************************************************************************/
opt_code_sect	: DOUBLE_PCT opt_code_lines
		| DOUBLE_PCT /* no actual lines */
		| /* can be empty: no %% or code lines */
		;

opt_code_lines	: opt_code_line
		| opt_code_line opt_code_lines
		;

opt_code_line	: fist_var
		| fist_fxn
		;

/****************************************************************************/
/*** GENERIC RULES FOR A FiST VARIABLE */
fist_var	: PCT_ALPHA
		{
		  if (parsedebug)
		    fprintf(stderr, "pct_alpha = \"%s\"\n", $1);
		  if (fist_validate_global_variable($1)) {
		    fyy_echo(expand_pct_var($1));
		  } else {
		    yyerror("unknown FiST global variable");
		    YYABORT;
		  }
		}
		| DOLLAR_VNA
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_vna = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  da = strchr(buf, '.');
		  if (da)
		    *da++ = '\0';
		  dn = strchr(buf, ':');
		  if (dn)
		    *dn++ = '\0';
		  dv = strchr(buf, '$');
		  if (dv)
		    *dv++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		| DOLLAR_VN
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_vn = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  dn = strchr(buf, ':');
		  if (dn)
		    *dn++ = '\0';
		  dv = strchr(buf, '$');
		  if (dv)
		    *dv++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		| DOLLAR_NA
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_na = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  da = strchr(buf, '.');
		  if (da)
		    *da++ = '\0';
		  dn = strchr(buf, '$');
		  if (dn)
		    *dn++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		| DOLLAR_VA
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_va = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  da = strchr(buf, '.');
		  if (da)
		    *da++ = '\0';
		  dv = strchr(buf, '$');
		  if (dv)
		    *dv++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		| DOLLAR_V
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_v = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  dv = strchr(buf, '$');
		  if (dv)
		    *dv++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		| DOLLAR_N
		{
		  if (parsedebug)
		    fprintf(stderr, "dollar_n = \"%s\"\n", $1);
		  strcpy(buf, $1);
		  dv = dn = da = NULL;
		  dn = strchr(buf, '$');
		  if (dn)
		    *dn++ = '\0';
		  if (fist_validate_dollar_variable($1, dv, dn, da, errmsg)) {
		    fyy_echo(expand_dollar_var($1, dv, dn, da));
		  } else {
		    yyerror(errmsg);
		    YYABORT;
		  }
		}
		;

/****************************************************************************/
/*** GENERIC RULES FOR A FiST FUNCTION */

fist_fxn	: FIST_FXN LEFT_PAREN RIGHT_PAREN
		{
		  if (parsedebug)
		    fprintf(stderr, "fist_fxn (no args): %s\n", $1);
		  parsing_fist_fxn = FALSE; /* so fyy_echo will ecl_strcat */
		  if (expand_fist_fxn(fxnbuf, $1, 0, NULL)) {
		    fyy_echo(fxnbuf);
		  } else {
		    yyerror(fxnbuf);
		    YYABORT;
		  }
		}
		| FIST_FXN LEFT_PAREN func_args RIGHT_PAREN
		{
		  if (parsedebug) {
		    int i;
		    fprintf(stderr, "fist_fxn (with %d args): %s\n",
			    num_func_args, $1);
		    for (i=0; i<num_func_args; i++) {
		      fprintf(stderr, "\tfunc_arg %d = \"%s\"\n",
			      i+1, func_args[i]);
		    }
		  }
		  parsing_fist_fxn = FALSE; /* so fyy_echo will ecl_strcat */
		  if (expand_fist_fxn(fxnbuf, $1, num_func_args, func_args)) {
		    fyy_echo(fxnbuf);
		  } else {
		    yyerror(fxnbuf);
		    YYABORT;
		  }
		}
		;

func_args	: func_arg
		| func_arg func_args
		;

func_arg	: FUNCARG
		{
		  if (parsedebug)
		    fprintf(stderr, "func_arg0: %s\n", $1);
		  add_func_arg($1);
		}
		| fist_var
		;

/****************************************************************************/

%%

static int
yyerror(const char *s)
{
  fprintf(stderr, "%s:%d: %s\n", in_file, fyylineno, s);
  exit(1);
  return 1;	/* to fool compilers that insist on a return statement */
}

static void
fyy_echo(const char *s)
{
  if (parsing_fist_rules) {
    if (parsing_fist_fxn)
      add_func_arg(s);
    else
      ecl_strcat(tmp_ecl, s);
  } else {
    fprintf(out_fp_c, "%s", s);
  }
}

static void
add_func_arg(const char *s)
{
  if (!parsing_fist_fxn)
    yyerror("not parsing a fist function!");
  if (num_func_args >= MAX_FUNCARGS)
    yyerror("exceeded maximum number of fist function arguments");
  func_args[num_func_args++] = strdup(s);
}
