# start of gzipfs.mk
SCA_UBINS = sca_list_idx sca_mk_idx sca_read sca_write
EXTRA_OBJS = sca_aux.o sca_code.o
# all ZLIB_OBJS must be re-compiled for user-land, so we use libz instead
ZLIB_OBJS = inflate.o infblock.o deflate.o trees.o infutil.o inftrees.o infcodes.o adler32.o inffast.o \
	zutil.c

sca_list_idx: sca_list_idx.c ${EXTRA_OBJS}
	${CC} -o $@ $^ ${UCFLAGS} -lz

sca_mk_idx: sca_mk_idx.c ${EXTRA_OBJS}
	${CC} -o $@ $^ ${UCFLAGS} -lz

sca_read: sca_read.c ${EXTRA_OBJS}
	${CC} -o $@ $^ ${UCFLAGS} -lz

sca_write: sca_write.c ${EXTRA_OBJS} -lz
	${CC} -o $@ $^ ${UCFLAGS}

sca_aux.o: sca_aux.c sca_aux.h
	${CC} -c $< ${UCFLAGS}

sca_code.o: sca_code.c sca_code.h
	${CC} -c $< ${UCFLAGS}
# end of gzipfs.mk
