/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * pct_vars.c: expand/validate percent variable names to their values
 * Fistgen sources.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


/* forward definitions */
static void expand_pct_pagesize(char *buf, void *data);
static void expand_pct_gid(char *buf, void *data);
static void expand_pct_uid(char *buf, void *data);
static void expand_pct_pid(char *buf, void *data);

static fword_exp_fxn_t valid_global_variables[] = {
  {"pagesize",		expand_pct_pagesize},
  {"gid",		expand_pct_gid},
  {"uid",		expand_pct_uid},
  {"pid",		expand_pct_pid},
  {"time",		NULL},
  {NULL,		NULL}	/* must be last entry */
};


/*
 * Validate that a %alpha is a valid keyword.
 * Return TRUE/FALSE.
 */
int
fist_validate_global_variable(const char *str)
{
  fword_exp_fxn_t *efp;

  if (!str || !str[0] || !str[1])
    return FALSE;

  for (efp = valid_global_variables; efp->name; efp++) {
    if (STREQ(efp->name, &str[1]))
      return TRUE;
  }
  return FALSE;
}


/*
 * Expand a percent variable into its value.
 * Note: value returned is a static variable.
 # If cannot expand value, leaves it the same.
 */
const char *
expand_pct_var(const char *var)
{
  static char buf[MAX_BUF_LEN];
  fword_exp_fxn_t *efp;

  for (efp = valid_global_variables; efp->name; efp++) {
    if (STREQ(&var[1], efp->name)) {
      if (efp->func)
	(efp->func)(buf, NULL);
      else
	sprintf(buf, "unimplemented_pct_var(%s)", var);
      return buf;
    }
  }

  /* if nothing matched, enclose string in "unknown" params */
  sprintf(buf, "unknown_pct_var(%s)", var);
  return buf;
}


/* expand %pagesize */
static void
expand_pct_pagesize(char *buf, void *data)
{
  strcpy(buf, FIST_PAGE_SIZE);
}


/* expand %uid */
static void
expand_pct_uid(char *buf, void *data)
{
  strcpy(buf, FIST_PCT_UID);
}


/* expand %gid */
static void
expand_pct_gid(char *buf, void *data)
{
  strcpy(buf, FIST_PCT_GID);
}


/* expand %pid */
static void
expand_pct_pid(char *buf, void *data)
{
  strcpy(buf, FIST_PCT_PID);
}
