/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * stk.c: stack manipulation routines
 * Fistgen sources.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


typedef struct stk_cell {
  int val;
  struct stk_cell *next;
} stk_cell_t;

static stk_cell_t *cpp_stack = NULL;


void
stk_init(void)
{
  if (cpp_stack)
    fprintf(stderr, "internal error: stack is not empty!\n");
  cpp_stack = NULL;		/* XXX: free it if not NULL */
}


/* pust a new element onto the stack */
void
stk_push(int val)
{
  stk_cell_t *tmp = malloc(sizeof(stk_cell_t));
  if (!tmp) {
    fprintf(stderr, "no more memory for stack cells\n");
    exit(1);
  }
  tmp->val = val;
  tmp->next = cpp_stack;
  cpp_stack = tmp;
}


/* return top element in the stack, or -1 of empty */
int
stk_pop(void)
{
  stk_cell_t *tmp;
  int val;

  if (!cpp_stack) {
    fprintf(stderr, "cannot pop an empty stack. cpp error.\n");
    return -1;
  }
  tmp = cpp_stack;
  cpp_stack = cpp_stack->next;
  val = tmp->val;
  free(tmp);
  tmp = NULL;
  return val;
}


/*
 * Return value at top of stack.
 * TRUE/FALSE or -1 if stack is empty.
 */
int
stk_top(void)
{
  if (!cpp_stack) {
    fprintf(stderr, "stk_top: state stack is empty!\n");
    return -1;
  }
  return cpp_stack->val;
}
