/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * sym.c: fist symbol table manipulation routines
 * Fistgen sources.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


typedef struct fist_symbol {
  char *name;			/* name of symbol */
  int val;			/* 1=defined, 0=undefined */
  struct fist_symbol *next;
} fist_symbol_t;

static fist_symbol_t *symbol_table = NULL;


/*
 * Add symbol to symbol table.
 * val is TRUE/FALSE.
 * Assume symbols are not added more than once.
 */
void
symtab_add(const char *name, int val)
{
  fist_symbol_t *tmp = malloc(sizeof(fist_symbol_t));
  if (!tmp) {
    fprintf(stderr, "no more memory for fist symbol table\n");
    exit(1);
  }
  tmp->name = strdup(name);
  tmp->val = val;
  tmp->next = symbol_table;
  symbol_table = tmp;
}


/*
 * Return value of symbol.
 * TRUE/FALSE or -1 if symbol doesn't exist.
 */
int
symtab_val(const char *name)
{
  fist_symbol_t *tmp = symbol_table;
  int val = -1;			/* symbol does not exist */

  while (tmp) {
    if (STREQ(tmp->name, name))
      return tmp->val;
    tmp = tmp->next;
  }
#if 0
  fprintf(stderr, "Symbol \"%s\" does not exist!\n", name);
#endif
  return val;
}
