/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * FreeBSD version of print.c
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include <fist.h>
#include <wrapfs.h>

#if 0
#include "opt_debug.h"

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/sysctl.h>
#include <sys/vnode.h>
#include <sys/mount.h>
#include <sys/namei.h>
#include <sys/malloc.h>
#include <sys/buf.h>

#include <vm/vm.h>
#include <vm/vm_extern.h>
#include <vm/vm_zone.h>
#include <vm/vnode_pager.h>
#include <vm/vm_prot.h>
#include <vm/vm_page.h>
#include <vm/vm_pageout.h>
#include <vm/vm_object.h>
#include <vm/vm_pager.h>

#include <stdarg.h>
#include FIST_HEADER
#endif

/* Print debugging functions */

#ifdef FIST_DEBUG

static u_long fist_debug_var = 0;

/* get value of debugging variable */
int
fist_get_debug_value(void)
{
  return fist_debug_var;
}

/* set debug level variable and return the previous value */
int
fist_set_debug_value(int val)
{
  int prev = fist_debug_var;

  fist_debug_var = val;
  return prev;
}

/*
 * Utilities used by both client and server
 * Standard levels:
 * 0) no debugging
 * 1) hard failures
 * 2) soft failures
 * 3) current test software
 * 4) main procedure entry points
 * 5) main procedure exit points
 * 6) utility procedure entry points
 * 7) utility procedure exit points
 * 8) obscure procedure entry points
 * 9) obscure procedure exit points
 * 10) random stuff
 * 11) all <= 1
 * 12) all <= 2
 * 13) all <= 3
 * ...
 */
void
fist_dprint_internal(int level, char *str,...)
{
  va_list ap;
  int var = fist_get_debug_value();

  if (var == level || (var > 10 && (var - 10) >= level)) {
    va_start(ap, str);
    vprintf(str, ap);
    va_end(ap);
  }
  return;
}

#if 0
void
fist_print_uap(char *fxn_name, struct mounta *uap)
{
  char namebuf[TYPICALMAXPATHLEN + 4];	/* +4 because of bug 1170077 */
  int len = 0;
  int error = 0;

  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNWON(print_uap)";

  if (uap) {
    fist_dprint(5, "%s: uap 0x%x\n", fxn_name, uap);

    /* what to mount */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->spec, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->spec %s\n", fxn_name, namebuf);

    /* on which mount point to mount */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->dir, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->dir %s\n", fxn_name, namebuf);

    /* primary mount flags */
    fist_dprint(5, "%s: uap->flags 0x%x\n", fxn_name, uap->flags);

    /* filesystem type ("fist_wrapfs") */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->fstype, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->fstype %s\n", fxn_name, namebuf);

    /* data pointer is null so far */
    fist_dprint(5, "%s: uap->dataptr 0x%x\n", fxn_name, uap->dataptr);

    /* data length is 0 (because data pointer is null */
    fist_dprint(5, "%s: uap->datalen %d\n", fxn_name, uap->datalen);
  }
}
#endif

void
fist_print_vfs(char *fxn_name, vfs_t *vfsp)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNWON(print_vfs)";

  if (vfsp) {
    fist_dprint(5,
		"%s: vfsp 0x%x\n", fxn_name,
		vfsp);
    fist_dprint(5,
		"%s: vfsp->mnt_list 0x%x\n", fxn_name,
		vfsp->mnt_list);
    fist_dprint(5,
		"%s: vfsp->mnt_op 0x%x\n", fxn_name,
		vfsp->mnt_op);
    fist_dprint(5,
		"%s: vfsp->mnt_vfc 0x%x\n", fxn_name,
		vfsp->mnt_vfc);
    fist_dprint(5,
		"%s: vfsp->mnt_vnodecovered 0x%x\n", fxn_name,
		vfsp->mnt_vnodecovered);
    fist_dprint(5,
		"%s: vfsp->mnt_syncer 0x%x\n", fxn_name,
		vfsp->mnt_syncer);
    fist_dprint(5,
		"%s: &vfsp->mnt_vnodelist 0x%x\n", fxn_name,
		&vfsp->mnt_vnodelist);
    fist_dprint(5,
		"%s: &vfsp->mnt_lock 0x%x\n", fxn_name,
		&vfsp->mnt_lock);
    fist_dprint(5,
		"%s: vfsp->mnt_flag 0x%x\n", fxn_name,
		vfsp->mnt_flag);
    fist_dprint(5,
		"%s: vfsp->mnt_kern_flag 0x%x\n", fxn_name,
		vfsp->mnt_kern_flag);
    fist_dprint(5,
		"%s: vfsp->mnt_maxsymlinklen 0x%x\n", fxn_name,
		vfsp->mnt_maxsymlinklen);
    fist_dprint(5,
		"%s: &vfsp->mnt_stat 0x%x\n", fxn_name,
		&vfsp->mnt_stat);

    fist_dprint(5,
		"%s: vfsp->mnt_data 0x%x\n", fxn_name,
		vfsp->mnt_data);
    fist_dprint(5,
		"%s: vfsp->mnt_time 0x%x\n", fxn_name,
		vfsp->mnt_time);
  }
}


void
fist_print_uio(const char *fxn_name, uio_t * uiop)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_uio)";

  fist_dprint(7, "BEGINNING UIO: %s\n", fxn_name);
  fist_dprint(7,
	      "uio 0x%x\n", uiop);
  if (uiop) {
    fist_dprint(7,
		"uio_iov 0x%x\n", uiop->uio_iov);
    fist_dprint(7,
		"uio_iovcnt %d\n", uiop->uio_iovcnt);
    fist_dprint(7,
		"uio_offset %d\n", uiop->uio_offset);
    fist_dprint(7,
		"uio_resid %d\n", uiop->uio_resid);
    fist_dprint(7,
		"uio_segflg 0x%x\n", uiop->uio_segflg);
    fist_dprint(7,
		"uio_rw %d\n", (u_int) uiop->uio_rw);
    fist_dprint(7,
		"uio_procp 0x%x\n", uiop->uio_procp);
  }
  fist_dprint(7, "ENDING UIO: %s\n", fxn_name);
}


void
fist_print_uios(const char *fxn_name, uio_t * uiop)
{
  int i;

  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_uios)";

  fist_dprint(7, "BEGINNING UIOs: %s\n", fxn_name);
  fist_dprint(7,
	      "uio 0x%x\n", uiop);
  if (uiop && uiop->uio_iovcnt) {
    fist_dprint(7,
		"uio_iovcnt %d\n", uiop->uio_iovcnt);
    fist_dprint(7,
		"uio_offset %d\n", uiop->uio_offset);
    fist_dprint(7,
		"uio_resid %d\n", uiop->uio_resid);
    fist_dprint(7,
		"uio_segflg 0x%x\n", uiop->uio_segflg);
    fist_dprint(7,
		"uio_rw %d\n", (u_int) uiop->uio_rw);
    fist_dprint(7,
		"uio_procp 0x%x\n", uiop->uio_procp);

    for (i = 0; i < uiop->uio_iovcnt; i++) {
      fist_dprint(7,
		  "uio_iov[%d].iov_len %d\n",
		  i, uiop->uio_iov[i].iov_len);
      fist_dprint(7,
		  "uio_iov[%d].iov_base is 0x%x\n",
		  i, uiop->uio_iov[i].iov_base);
    }
  }
  fist_dprint(7, "ENDING UIO: %s\n", fxn_name);
}

void
fist_print_page(const char *fxn_name, vm_page_t pp)
{
  fist_dprint(2, "PAGE %s: pp=%x idx=%d fl=%x vld=%d drt=%d bsy=%d wct=%d hct=%d mod=%d\n",
	      fxn_name,
	      (int) pp,
	      pp->pindex,
	      pp->flags,
	      pp->valid,
	      pp->dirty,
	      pp->busy,
	      pp->wire_count,
	      pp->hold_count,
	      pmap_is_modified(VM_PAGE_TO_PHYS(pp)) );
}

/* return string of cn flags (static buffer!) */
char *
fist_cn_flags(u_long flags)
{
  static char buf[256];

  buf[0] = '\0';
  if (flags & NOCROSSMOUNT) strcat(buf, "NOCROSSMOUNT|");
  if (flags & RDONLY) strcat(buf, "RDONLY|");
  if (flags & HASBUF) strcat(buf, "HASBUF|");
  if (flags & SAVENAME) strcat(buf, "SAVENAME|");
  if (flags & SAVESTART) strcat(buf, "SAVESTART|");
  if (flags & ISDOTDOT) strcat(buf, "ISDOTDOT|");
  if (flags & MAKEENTRY) strcat(buf, "MAKEENTRY|");
  if (flags & ISLASTCN) strcat(buf, "ISLASTCN|");
  if (flags & ISSYMLINK) strcat(buf, "ISSYMLINK|");
  if (flags & ISWHITEOUT) strcat(buf, "ISWHITEOUT|");
  if (flags & DOWHITEOUT) strcat(buf, "DOWHITEOUT|");
  if (flags & WILLBEDIR) strcat(buf, "WILLBEDIR|");
  if (flags & ISUNICODE) strcat(buf, "ISUNICODE|");
  buf[strlen(buf)-1] = '\0';
  return buf;
}


void
fist_print_cn(const char *fxn_name, cn_t *cnp)
{
  int i;

  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_cn)";

  fist_dprint(2,"\n");
  if (!cnp) {
    fist_dprint(2,"%s: NULL cnp 0x%x\n", fxn_name, cnp);
    return;
  }
  if (fist_isdeadcode(cnp)) {
    fist_dprint(2,"%s: DEADCODE cnp 0x%x\n", fxn_name, cnp);
    return;
  }

  fist_dprint(2,"%s: cnp->cn_nameiop %lu\n", fxn_name, cnp->cn_nameiop);
  fist_dprint(2,"%s: cnp->cn_flags 0x%x (%s)\n",
	      fxn_name, cnp->cn_flags, fist_cn_flags(cnp->cn_flags));
  fist_dprint(2,"%s: cnp->cn_proc 0x%x\n", fxn_name, cnp->cn_proc);
  fist_dprint(2,"%s: cnp->cn_cred 0x%x\n", fxn_name, cnp->cn_cred);


  if (fist_isdeadcode(cnp->cn_pnbuf)) {
    fist_dprint(2,"%s: cnp->cn_pnbuf 0x%x\n",
		fxn_name, (int) cnp->cn_pnbuf);
  } else {
    fist_dprint(2,"%s: cnp->cn_pnbuf 0x%x \"%s\"\n",
		fxn_name, (int) cnp->cn_pnbuf, cnp->cn_pnbuf);

    fist_dprint(2, "%s: PNBUF 0x%x <", fxn_name,
		((struct freelist *)cnp->cn_pnbuf)->spare0);
    for (i=0; i<20; i++) fist_dprint(2, "%d,", (int) cnp->cn_pnbuf[i]);
    fist_dprint(2, ">\n");
  }

  if (fist_isdeadcode(cnp->cn_nameptr)) {
    fist_dprint(2,"%s: cnp->cn_nameptr 0x%x\n",
		fxn_name, (int) cnp->cn_nameptr);
  } else {
    fist_dprint(2,"%s: cnp->cn_nameptr 0x%x \"%s\"\n",
		fxn_name, (int) cnp->cn_nameptr, cnp->cn_nameptr);
    fist_dprint(2, "%s: NAMEPTR 0x%x <", fxn_name,
		((struct freelist *)cnp->cn_nameptr)->spare0);
    for (i=0; i<20; i++) fist_dprint(2, "%d,", (int) cnp->cn_nameptr[i]);
    fist_dprint(2, ">\n");
  }

  fist_dprint(2,"%s: cnp->cn_namelen %lu\n", fxn_name, cnp->cn_namelen);
  fist_dprint(2,"%s: cnp->cn_consume %ld\n", fxn_name, cnp->cn_consume);
}

void
fist_print_vnode(char *fxn_name, vnode_t *vp)
{
  vprint(fxn_name, vp);
}

#endif /* FIST_DEBUG */

int
fist_isdeadcode(void *addr)
{
  struct freelist *flp;

  flp = (struct freelist *) addr;
  return (flp->spare0 == WEIRD_ADDR);
}
