/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
#ifdef FIST_USE_AUX_SRC
/*
 *  $$
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include <fist.h>
#include <wrapfs.h>


/*
 * Read "len" bytes from "filename" into "buf".
 * "buf" is in kernel space.
 */
int
wrapfs_read_file(const char *filename, void *buf, int len)
{
  int err, closerr;
  cred_t *cr = CRED();
  struct nameidata nd;

  NDINIT(&nd, LOOKUP, FOLLOW, UIO_SYSSPACE, filename, curproc);
  err = vn_open(&nd, FREAD, 0);
  if (err)
    return err;

  err = vn_rdwr(UIO_READ, nd.ni_vp, buf, len, 0, UIO_SYSSPACE,
		IO_NODELOCKED|IO_UNIT, cr, (int *)NULL, curproc);

  closerr = vn_close(nd.ni_vp, FREAD, cr, curproc);
  return (err ? err : closerr);
}


/*
 * Write "len" bytes from "buf" to "filename"
 * "buf" is in kernel space.
 */
int
wrapfs_write_file(const char *filename, void *buf, int len)
{
  int err, closerr;
  cred_t *cr = CRED();

  struct nameidata nd;

  NDINIT(&nd, CREATE, FOLLOW, UIO_SYSSPACE, filename, curproc);
  err = vn_open(&nd, FWRITE, 0640);
  if (err)
    return err;

  err = vn_rdwr(UIO_WRITE, nd.ni_vp, buf, len, 0, UIO_SYSSPACE,
		IO_NODELOCKED|IO_UNIT, cr, (int *)NULL, curproc);

  closerr = vn_close(nd.ni_vp, FWRITE, cr, curproc);
  return (err ? err : closerr);
}


/*
 * perform a special lookup with special permissions
 */
int
fist_lookup(vnode_t *dvp, char *name, vnode_t **vpp, pathname_t *pnp, int flags, vnode_t *rdir, cred_t *cr, uid_t uid, gid_t gid)
{
  int err;
  uid_t orig_uid = cr->cr_uid;
  gid_t orig_gid = cr->cr_gid;
  struct nameidata nd;

  NDINIT(&nd, LOOKUP, FOLLOW, UIO_SYSSPACE, name, curproc);
  cr->cr_uid = uid;
  cr->cr_gid = gid;
  err = VOP_LOOKUP(dvp, vpp, &nd.ni_cnd);
  cr->cr_uid = orig_uid;
  cr->cr_gid = orig_gid;
  return err;
}
#endif /* FIST_USE_AUX_SRC */
