/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
#ifndef	__WRAPFS_H_
#define	__WRAPFS_H_

/*
 * Copyright (c) 1992, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software donated to Berkeley by
 * Jan-Simon Pendry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)wrapfs.h    8.3 (Berkeley) 8/20/94
 *
 * $Id: wrapfs.h,v 1.11 2005/01/03 21:10:41 ezk Exp $
 */

struct wrapfs_args {
  char *target;			/* Target of loopback  */
};

#ifdef FIST_DEBUG /* debugging ioctls */
#define FIST_IOCTL_GET_DEBUG_VALUE	_IOR('F', 1,  int)
#define FIST_IOCTL_SET_DEBUG_VALUE	_IOW('F', 2,  int)
#endif /* FIST_DEBUG */

#ifdef _KERNEL

/* per-vfs private date */
struct wrapfs_mount {
  struct mount *wrapfsm_vfs;
  struct vnode *wrapfsm_rootvp;	/* Reference to root wrapfs_node */
  /* additional per-vfs BDTs */
  FIST_VFS_FIELDS;
};

/*
 * A cache of vnode references
 * (This is a private structure per vnode->v_data)
 */
struct wrapfs_node {

  LIST_ENTRY(wrapfs_node) wrapfs_hash; /* Hash list */
  struct vnode *wrapfs_lowervp; /* VREFed once */
  struct vnode *wrapfs_vnode;	/* Back pointer */
};

extern int wrapfs_init (struct vfsconf *vfsp);
extern int wrapfs_uninit(struct vfsconf *vfsp);
extern int wrapfs_nodeget(struct mount *mp, struct vnode *target, struct vnode **vpp);
void wrapfs_hashrem(struct wrapfs_node *xp);
int wrapfs_bypass(struct vop_generic_args *ap);


/*
 * Flags for wrapfs_{en,de}code_filename
 * DO_DOTS means the special entries . and .. should be encoded (for symlink)
 * SKIP_DOTS means they should be preserved intact
 */
#define DO_DOTS   0
#define SKIP_DOTS 1

#define MAXNAMLEN	255	/* as per POSIX */

#define	MOUNT_TO_WRAPFS_MOUNT(mp) ((struct wrapfs_mount *)((mp)->mnt_data))
#define	VP_TO_WRAPFS(vp) ((struct wrapfs_node *)(vp)->v_data)
#define	WRAPFS_TO_VP(xp) ((xp)->wrapfs_vnode)
#ifdef DIAGNOSTIC
extern struct vnode *wrapfs_checkvp (struct vnode * vp, char *fil, int lno);
# define WRAPFS_VP_TO_LOWERVP(vp) wrapfs_checkvp((vp), __FILE__, __LINE__)
#else
# define WRAPFS_VP_TO_LOWERVP(vp) (VP_TO_WRAPFS(vp)->wrapfs_lowervp)
#endif /* DIAGNOSTIC */


#ifdef MALLOC_DECLARE
MALLOC_DECLARE(M_WRAPFSNODE);
#endif

#define vfs2priv(x)	MOUNT_TO_WRAPFS_MOUNT(x)
#define vnode2lower(x)	WRAPFS_VP_TO_LOWERVP(x)
#define dir2lower(x)	WRAPFS_VP_TO_LOWERVP(x)

#define CRED()	curproc->p_cred->pc_ucred
#define printk	printf

/* simpler macros for using with file name encoding */
#ifdef FIST_FILTER_NAME
#define CNP_VARS	cn_t *thiscnp=NULL, *lowercnp=NULL
#define CNP_BEFORE(V) \
	do { \
	  thiscnp = ap->a_cnp; /* save original */ \
	  lowercnp = wrapfs_new_cnp((V), thiscnp); \
	  ap->a_cnp = lowercnp;		/* prepare for bypass */ \
	} while (0)
#define CNP_AFTER(V) \
	do { \
	  if ((thiscnp->cn_flags & PARAMASK) != (lowercnp->cn_flags & PARAMASK)) \
	    panic("%s: FLAGS CHANGED this:0x%x lower:0x%x", \
		  __FUNCTION__, (int)thiscnp->cn_flags, (int)lowercnp->cn_flags); \
	  wrapfs_update_cnp((V), &lowercnp, thiscnp, error); \
	  ap->a_cnp = thiscnp;	/* update for caller */ \
	} while (0)
# define err error
#else /* not FIST_FILTER_NAME */
#define CNP_VARS
#define CNP_BEFORE(x)
#define CNP_AFTER(x)
#endif /* not FIST_FILTER_NAME */

extern int wrapfs_bypass (struct vop_generic_args * ap);
extern vop_t **wrapfs_vnodeop_p;
extern struct lock wrapfs_hashlock;

/* XXX: EZK hacky stuff I have to do rather than change system headers */
typedef struct vnode vnode_t;
typedef struct vattr vattr_t;
typedef struct uio uio_t;
typedef struct iovec iovec_t;
typedef struct ucred cred_t;
typedef struct thread thread_t;
typedef struct mount vfs_t;
typedef struct componentname cn_t;
typedef struct componentname pathname_t;

#define	MIN(a,b)		(((a)<(b))?(a):(b))
#define	MAX(a,b)		(((a)>(b))?(a):(b))
#define VT_WRAPFS		VT_NULL
#define MOUNT_WRAPFS		MOUNT_NULL

#define kmem_alloc(size)	malloc((size), M_WRAPFSNODE, M_WAITOK)
#define kmem_free(addr)		free((addr), M_TEMP)

#ifdef FIST_FILTER_NAME
extern int wrapfs_encode_filename(const char *name, int length, char **encoded_name, int skip_dots, const vnode_t *vp, const vfs_t *vfsp);
extern int wrapfs_decode_filename(const char *name, int length, char **decoded_name, int skip_dots, const vnode_t *vp, const vfs_t *vfsp);
#endif /* FIST_FILTER_NAME */

extern int wrapfs_decode_block(const char *from, char *to, int len, const vnode_t *vp, const vfs_t *vfsp, u_long pagenum);
extern int wrapfs_encode_block(const char *from, char *to, int len, const vnode_t *vp, const vfs_t *vfsp, u_long pagenum);
extern void *kmem_zalloc(unsigned long size);
extern int fist_uiomove(caddr_t cp, int n, enum uio_rw rwflag, struct uio *uio);
extern int wrapfs_verify_lower_object(vnode_t *vp, cred_t *cred, thread_t *p, char *fxn);

extern cn_t *wrapfs_new_cnp(const vnode_t *thisvp, const cn_t *cnp);
extern void wrapfs_update_cnp(const vnode_t *thisvp, cn_t **lowercnpp, cn_t *thiscnp, int error);
extern int wrapfs_fill_zeros(vnode_t *vp, vattr_t *vap, cred_t * cred, thread_t * p);
extern void wrapfs_fill_page(vnode_t *vp, char *buf, long long offset);
extern char *fist_cn_flags(u_long flags);

#ifdef FIST_FILTER_DATA
extern void fist_print_object(const char *fxn_name, vm_object_t object);
extern void fist_copy_object_attr(vm_object_t dest, const vm_object_t src);
extern void fist_copy_page_attr(vm_page_t dest, const vm_page_t src);
#endif /* FIST_FILTER_DATA */

struct freelist {
  long	spare0;
  struct malloc_type *type;
  long	spare1;
  caddr_t	next;
};
#define WEIRD_ADDR 0xdeadc0de
extern int fist_isdeadcode(void *addr);

#ifdef FIST_DEBUG
extern void fist_dprint_internal(int level, char *str, ...);
extern void fist_print_vnode(char *, vnode_t *);
extern void fist_print_vfs(char *, vfs_t *);
/* extern void fist_print_uap(char *, struct mounta *); */
extern void fist_print_uio(const char *, uio_t *);
extern void fist_print_uios(const char *, uio_t *);
extern void fist_print_page(const char *fxn_name, vm_page_t pp);
extern void fist_print_cn(const char *fxn_name, cn_t *);
/* extern void fist_print_pathname(char *fxn_name, struct pathname *pnp); */
extern int fist_get_debug_value(void);
extern int fist_set_debug_value(int val);

# define print_location() \
	fist_dprint(2, "%s %s:%d\n", __FUNCTION__, __FILE__, __LINE__)

# define fist_dprint(level, str, args...) \
	fist_dprint_internal(level, str, ## args)
# define ASSERT(e)	((e) ? (void)0 : panic("ASSERTION \"%s\" FAILED at %s:%d", #e, __FILE__, __LINE__))

#else /* not FIST_DEBUG */

# define fist_dprint(level, format, args...)
# define print_location()
# define fist_print_vnode(a, b)
# define fist_print_vfs(a, b)
# define fist_print_uio(a, b)
# define fist_print_uios(a, b)
# define fist_print_uap(a, b)
# define fist_print_page(a, b)
# define fist_print_cn(a, b)
# define ASSERT(e)

#endif /* not FIST_DEBUG */

#ifdef FIST_USE_AUX_SRC
extern int wrapfs_read_file(const char *filename, void *buf, int len);
extern int wrapfs_write_file(const char *filename, void *buf, int len);
extern int fist_lookup(vnode_t *dvp, char *name, vnode_t **vpp, pathname_t *pnp, int flags, vnode_t *rdir, cred_t *cr, uid_t uid, gid_t gid);
#endif /* FIST_USE_AUX_SRC */

/* auto-generated extern definitions */
FIST_AUTO_GENERATED_EXTERNS

#endif /* _KERNEL */

/*
 * Definitions for user and kernel code
 */
#define memset(arg, val, len) bzero(arg, len)

/* ioctls */
FIST_IOCTL_DEFS

#endif /* not __WRAPFS_H_ */
