/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: fist_aux.c,v 1.8 2005/01/03 21:10:41 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include "fist.h"
#include "wrapfs.h"


#ifdef FIST_USE_AUX_SRC
/*
 * Read "len" bytes from "filename" into "buf".
 * "buf" is in kernel space.
 */
int
wrapfs_read_file(const char *filename, void *buf, int len)
{
    file_t *filp;
    mm_segment_t oldfs;
    int bytes;
    				/* Chroot? Maybe NULL isn't right here */
    filp = filp_open(filename, O_RDONLY, 0);
    if (!filp || IS_ERR(filp)) {
	printk("wrapfs_read_file err %d\n", (int) PTR_ERR(filp));
	return -1;  /* or do something else */
    }

    if (!filp->f_op->read)
	return -2;  /* file(system) doesn't allow reads */

    /* now read len bytes from offset 0 */
    filp->f_pos = 0;		/* start offset */
    oldfs = get_fs();
    set_fs(KERNEL_DS);
    bytes = filp->f_op->read(filp, buf, len, &filp->f_pos);
    set_fs(oldfs);

    /* close the file */
    fput(filp);

    return bytes;
}


/*
 * Write "len" bytes from "buf" to "filename"
 * "buf" is in kernel space.
 */
int
wrapfs_write_file(const char *filename, void *buf, int len)
{
    file_t *filp;
    mm_segment_t oldfs;
    int bytes;
				/* Chroot? Maybe NULL isn't right here */
    filp = filp_open(filename, O_RDWR|O_CREAT, 0640);
    if (!filp || IS_ERR(filp)) {
	printk("wrapfs_write_file err %d\n", (int) PTR_ERR(filp));
	return -1;  /* or do something else */
    }

    if (!filp->f_op->write)
	return -2;  /* file(system) doesn't allow writes */

    /* now write len bytes from offset 0 */
    filp->f_pos = 0;		/* start offset */
    oldfs = get_fs();
    set_fs(KERNEL_DS);
    bytes = filp->f_op->write(filp, buf, len, &filp->f_pos);
    set_fs(oldfs);

    /* close the file */
    fput(filp);

    return bytes;
}


/*
 * perform a special lookup with special permissions
 */
dentry_t *
fist_lookup(dentry_t *dir, const char *name, vnode_t **out, uid_t uid, gid_t gid)
{
    uid_t saved_uid;
    gid_t saved_gid;
    dentry_t *new_dentry;

    saved_uid = dir->d_inode->i_uid;
    saved_gid = dir->d_inode->i_gid;
    dir->d_inode->i_uid = uid;
    dir->d_inode->i_gid = gid;
    new_dentry = lookup_dentry(name, dir, 0);
    dir->d_inode->i_uid = saved_uid;
    dir->d_inode->i_gid = saved_gid;
    return new_dentry;
}
#endif /* FIST_USE_AUX_SRC */

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
