/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: wrapfs.h,v 1.11 2005/01/03 21:10:41 ezk Exp $
 */

#ifndef __FIST_WRAPFS_H_
#define __FIST_WRAPFS_H_

#ifdef __KERNEL__

/*
 * STRUCTURES:
 */

/* wrapfs inode data in memory */
struct wrapfs_inode_info {
    inode_t *inode;
};

/* wrapfs super-block data in memory */
struct wrapfs_sb_info {
    super_block_t *s_sb;
#if 0
    /* not needed b/c linux has an s_root field in struct super_block */
    dentry_t *s_root;
#endif
    FIST_VFS_FIELDS;
};

/*
 * MACROS:
 */
// File TO Hidden File
#define ftohf(file) ((file_t *)((file)->private_data))
// Inode TO Private Data
#define itopd(ino) ((struct wrapfs_inode_info *)(ino)->u.generic_ip)
// Inode TO Hidden Inode
#define itohi(ino) (itopd(ino)->inode)
#define vnode2lower itohi
// Superblock TO Private Data
#define stopd(super) ((struct wrapfs_sb_info *)(super)->u.generic_sbp)
#define vfs2priv stopd
// Superblock TO Hidden Superblock
#define stohs(super) (stopd(super)->s_sb)
// Dentry TO Hidden Dentry (and private data --- for the future)
#define dtopd(dentry) ((dentry)->d_fsdata)
#define dtohd(dentry) ((dentry_t *)dtopd(dentry))
#define dir2lower dtohd
/* VMArea TO Hidden VMArea */
#define vmatohvma(vma) ((vm_area_t *)((vma)->vm_private_data))

#define sbt(sb) ((sb)->s_type->name)

#ifdef FIST_FILTER_NAME
/*
 * Flags for wrapfs_{en,de}code_filename
 * DO_DOTS means the special entries . and .. should be encoded (for symlink)
 * SKIP_DOTS means they should be preserved intact
 */
#define DO_DOTS   0
#define SKIP_DOTS 1
#endif /* FIST_FILTER_NAME */

/* kernel 2.2.14 and later renamed "event" */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,14)
# define global_event event
#endif /* kernels before 2.2.14 */

/*
 * EXTERNALS:
 */
extern struct file_operations wrapfs_main_fops;
extern struct file_operations wrapfs_dir_fops;
extern struct inode_operations wrapfs_main_iops;
extern struct inode_operations wrapfs_dir_iops;
extern struct super_operations wrapfs_sops;
extern struct dentry_operations wrapfs_dops;
extern struct vm_operations_struct wrapfs_shared_vmops;
extern struct vm_operations_struct wrapfs_private_vmops;

extern int wrapfs_interpose(dentry_t *hidden_dentry, dentry_t *this_dentry, super_block_t *sb, int flag);
#ifdef FIST_FILTER_DATA
extern int wrapfs_decode_block(const char *from, char *to, int len, const vnode_t *vp, const vfs_t *vfsp);
extern int wrapfs_encode_block(const char *from, char *to, int len, const vnode_t *vp, const vfs_t *vfsp);
#endif /* FIST_FILTER_DATA */
#ifdef FIST_FILTER_NAME
extern int wrapfs_decode_filename(const char *name, int length, char **decoded_name, int skip_dots, const vnode_t *vp, const vfs_t *vfsp);
extern int wrapfs_encode_filename(const char *name, int length, char **encoded_name, int skip_dots, const vnode_t *vp, const vfs_t *vfsp);
#endif /* FIST_FILTER_NAME */

#ifdef FIST_DEBUG
# define wrapfs_hidden_dentry(d) __wrapfs_hidden_dentry(__FILE__,__FUNCTION__,__LINE__,(d))
extern dentry_t *__wrapfs_hidden_dentry(char *file, char *func, int line, dentry_t *this_dentry);
#else /* not FIST_DEBUG */
# define wrapfs_hidden_dentry(dentry) dtohd(dentry)
#endif /* not FIST_DEBUG */

#ifdef FIST_USE_AUX_SRC
extern int wrapfs_read_file(const char *filename, void *buf, int len);
extern int wrapfs_write_file(const char *filename, void *buf, int len);
extern dentry_t *fist_lookup(dentry_t *dir, const char *name, vnode_t **out, uid_t uid, gid_t gid);
#endif /* FIST_USE_AUX_SRC */

/* auto-generated extern definitions */
FIST_AUTO_GENERATED_EXTERNS

#endif /* __KERNEL__ */

/*
 * Definitions for user and kernel code
 */

/* ioctls */
FIST_IOCTL_DEFS

#endif	/* __FIST_WRAPFS_H_ */

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
