/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: fist.h,v 1.24 2005/01/03 21:10:42 ezk Exp $
 */

#ifndef __FIST_H_
#define __FIST_H_

/*
 * KERNEL ONLY CODE:
 */
#ifdef __KERNEL__
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/errno.h>
#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/file.h>
#include <linux/malloc.h>
#include <linux/vmalloc.h>
#include <linux/poll.h>
#include <linux/version.h>

#include <linux/swap.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/mman.h>

/*
 * MACROS:
 */

/* those mapped to ATTR_* were copied from linux/fs.h */
#define FA_MODE		ATTR_MODE
#define FA_UID		ATTR_UID
#define FA_GID		ATTR_GID
#define FA_SIZE		ATTR_SIZE
#define FA_ATIME	ATTR_ATIME
#define FA_MTIME	ATTR_MTIME
#define FA_CTIME	ATTR_CTIME
#define FA_ATIME_SET	ATTR_ATIME_SET
#define FA_MTIME_SET	ATTR_MTIME_SET
#define FA_FORCE	ATTR_FORCE
#define FA_ATTR_FLAGS	ATTR_ATTR_FLAG

/* must be greater than all other ATTR_* flags! */
#define FA_NLINK	2048
#define FA_BLKSIZE	4096
#define FA_BLOCKS	8192
#define FA_TIMES	(FA_ATIME|FA_MTIME|FA_CTIME)
#define FA_ALL		0

/* macros to manage changes between kernels */
# define INODE_DATA(i)	(&(i)->i_data)

#define MIN(x,y) ((x < y) ? (x) : (y))
#define MAX(x,y) ((x > y) ? (x) : (y))

/*
 * TYPEDEFS:
 */
typedef struct dentry dentry_t;
typedef struct file file_t;
typedef struct inode inode_t;
typedef inode_t vnode_t;
typedef struct page page_t;
typedef struct qstr qstr_t;
typedef struct super_block super_block_t;
typedef super_block_t vfs_t;
typedef struct vm_area_struct vm_area_t;


/*
 * EXTERNALS:
 */
#ifdef FIST_DEBUG

#define FPPF(str,page) printk("PPF %s 0x%x/%d: Lck:%d Err:%d Ref:%d Upd:%d Other::%d:%d:%d:%d:\n", \
		str, \
		(int) page, \
		(int) page->index, \
		(PageLocked(page) ? 1 : 0), \
		(PageError(page) ? 1 : 0), \
		(PageReferenced(page) ? 1 : 0), \
		(Page_Uptodate(page) ? 1 : 0), \
		(PageDecrAfter(page) ? 1 : 0), \
		(PageSlab(page) ? 1 : 0), \
		(PageSwapCache(page) ? 1 : 0), \
		(PageReserved(page) ? 1 : 0) \
		)
#define EZKDBG printk("EZK %s:%d:%s\n",__FILE__,__LINE__,__FUNCTION__)
#if 0
# define EZKDBG1 printk("EZK %s:%d\n",__FILE__,__LINE__)
#else
# define EZKDBG1
#endif

extern int fist_get_debug_value(void);
extern int fist_set_debug_value(int val);
extern void fist_dprint_internal(int level, char *str,...);
extern void fist_print_dentry(char *str, const dentry_t *dentry);
extern void fist_print_inode(char *str, const inode_t *inode);
extern void fist_print_file(char *str, const file_t *file);
extern void fist_print_buffer_flags(char *str, struct buffer_head *buffer);
extern void fist_print_page_flags(char *str, page_t *page);
extern void fist_print_page_bytes(char *str, page_t *page);
extern void fist_print_pte_flags(char *str, const page_t *page);
extern void fist_checkinode(inode_t *inode, char *msg);
extern char *add_indent(void);
extern char *del_indent(void);

#define STATIC
#define ASSERT(EX)	\
do {	\
    if (!(EX)) {	\
	printk(KERN_CRIT "ASSERTION FAILED: %s at %s:%d (%s)\n", #EX,	\
	       __FILE__, __LINE__, __FUNCTION__);	\
	(*((char *)0))=0;	\
    }	\
} while (0)

#define dprintk(format, args...) printk(KERN_DEBUG format, ##args)
#define fist_dprint(level, str, args...) fist_dprint_internal(level, KERN_DEBUG str, ## args)
#define print_entry_location() fist_dprint(4, "%sIN:  %s %s:%d\n", add_indent(), __FUNCTION__, __FILE__, __LINE__)
#define print_exit_location() fist_dprint(4, "%s OUT: %s %s:%d\n", del_indent(), __FUNCTION__, __FILE__, __LINE__)
#define print_exit_status(status) fist_dprint(4, "%s OUT: %s %s:%d, STATUS: %d\n", del_indent(), __FUNCTION__, __FILE__, __LINE__, status)
#define print_exit_pointer(status) \
do { \
  if (IS_ERR(status)) \
    fist_dprint(4, "%s OUT: %s %s:%d, RESULT: %ld\n", del_indent(), __FUNCTION__, __FILE__, __LINE__, PTR_ERR(status)); \
  else \
    fist_dprint(4, "%s OUT: %s %s:%d, RESULT: 0x%x\n", del_indent(), __FUNCTION__, __FILE__, __LINE__, PTR_ERR(status)); \
} while (0)

#else /* not FIST_DEBUG */

#define EZKDBG

#define fist_get_debug_value()	-1
#define fist_set_debug_value(a)	-1
#define fist_dprint_internal(level, str, args...)
#define fist_print_dentry(a, b)
#define fist_print_inode(a, b)
#define fist_print_file(a, b)
#define fist_print_buffer_flags(a, b)
#define fist_print_page_flags(a, b)
#define fist_print_page_bytes(a, b)
#define fist_print_pte_flags(a, b)
#define fist_checkinode(a, b)

#define STATIC	static
#define ASSERT(EX)
#define dprintk(format, args...)
#define fist_dprint(level, format, args...)
#define print_entry_location()
#define print_exit_location()
#define print_exit_status(status)
#define print_exit_pointer(status)

#endif /* not FIST_DEBUG */

#endif /* __KERNEL__ */


/*
 * DEFINITIONS FOR USER AND KERNEL CODE:
 * (Note: ioctl numbers 1--9 are reserved for fistgen, the rest
 *  are auto-generated automatically based on the user's .fist file.)
 */
#ifdef FIST_DEBUG
# define FIST_IOCTL_GET_DEBUG_VALUE	_IOR(0x15, 1, int)
# define FIST_IOCTL_SET_DEBUG_VALUE	_IOW(0x15, 2, int)
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
# define FIST_IOCTL_GET_FAST_TAIL_VALUE	_IOR(0x15, 3, int)
# define FIST_IOCTL_SET_FAST_TAIL_VALUE	_IOW(0x15, 4, int)
#endif /* FIST_FILTER_SCA */

#endif /* not __FIST_H_ */

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
