/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: fist_ioctl.c,v 1.11 2005/01/03 21:10:42 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include "fist.h"
#include "wrapfs.h"

#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#ifdef FIST_DEBUG
int opt_d = 0;
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
int opt_f = 0;
#endif /* FIST_FILTER_SCA */


void
usage(const char *progname)
{
#ifdef FIST_DEBUG
  fprintf(stderr, "Usage: %s -d file [val]\n\tto set/get debugging values\n", progname);
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
  fprintf(stderr, "Usage: %s -f file [val]\n\tto set/get fast-tail flag\n", progname);
#endif /* FIST_FILTER_SCA */
}


int
main(int argc, char *argv[])
{
  int fd, ret, val = 0;

#ifdef FIST_DEBUG
  if (argc < 3 || argc > 4) {
    usage(argv[0]);
    exit(1);
  }
  if (strcmp(argv[1], "-d") == 0)
    opt_d++;
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
  if (argc < 3 || argc > 4) {
    usage(argv[0]);
    exit(1);
  }
  if (strcmp(argv[1], "-f") == 0)
    opt_f++;
#endif /* FIST_FILTER_SCA */

  /* open target file */
  fd = open(argv[2], O_RDONLY);
  if (fd < 0) {
    perror(argv[2]);
    exit(1);
  }

#ifdef FIST_DEBUG
  /* if specified 3rd arg, want to set debug level */
  if (opt_d) {
    if (argc == 4) {
      val = atoi(argv[3]);
      ret = ioctl(fd, FIST_IOCTL_SET_DEBUG_VALUE, &val);
      if (ret < 0) {
	perror("ioctl set");
	exit(1);
      }
    } else {
      ret = ioctl(fd, FIST_IOCTL_GET_DEBUG_VALUE, &val);
      if (ret < 0) {
	perror("ioctl get");
	exit(1);
      }
      printf("debug ioctl returned value %d\n", val);
    }
    goto out;
  }
#endif /* FIST_DEBUG */

#ifdef FIST_FILTER_SCA
  /* if specified 3rd arg, want to set fast-tail flag */
  if (opt_f) {
    if (argc == 4) {
      val = atoi(argv[3]);
      ret = ioctl(fd, FIST_IOCTL_SET_FAST_TAIL_VALUE, &val);
      if (ret < 0) {
	perror("ioctl set");
	exit(1);
      }
    } else {
      ret = ioctl(fd, FIST_IOCTL_GET_FAST_TAIL_VALUE, &val);
      if (ret < 0) {
	perror("ioctl get");
	exit(1);
      }
      printf("fast-tail ioctl returned value %d\n", val);
    }
    goto out;
  }
#endif /* FIST_FILTER_SCA */

 out:
  close(fd);
  exit(0);
}
