/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: fist_ioctl.c,v 1.6 2005/01/03 21:10:42 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include "fist.h"
#include "wrapfs.h"

#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#ifdef FIST_DEBUG
static int opt_d = 0;
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
static int opt_f = 0;
#endif /* FIST_FILTER_SCA */
#ifdef FIST_MNTSTYLE_ATTACH
static int opt_attach = 0, opt_detach = 0;
static struct fist_ioctl_attach_data attach_data;
static struct fist_ioctl_detach_data detach_data;
#endif /* FIST_MNTSTYLE_ATTACH */
static int optcount;
static const char *progname;


void
usage(void)
{
#ifdef FIST_DEBUG
	fprintf(stderr, "Usage: %s -d file [val]\n\tto set/get debugging values\n", progname);
#endif /* FIST_DEBUG */
#ifdef FIST_FILTER_SCA
	fprintf(stderr, "Usage: %s -f file [val]\n\tto set/get fast-tail flag\n", progname);
#endif /* FIST_FILTER_SCA */
#ifdef FIST_MNTSTYLE_ATTACH
	fprintf(stderr, "Usage: %s +a root node target\n\tto attach node to target, inside directory root\n", progname);
	fprintf(stderr, "Usage: %s -a root node\n\tto detach path (root/node)\n", progname);
#endif /* FIST_MNTSTYLE_ATTACH */
	exit(1);
}


int
main(int argc, char *argv[])
{
	int fd, ret, val = 0;

	progname = argv[0];

	/* check that minimum number of args were specified */
	if (argc < 3)
		usage();

#ifdef FIST_MNTSTYLE_ATTACH
	if (strcmp(argv[1], "+a") == 0) {
		if (argc != 5)
			usage();
		opt_attach++;
		optcount++;
		attach_data.from = argv[3];
		attach_data.to = argv[4];
	} else if (strcmp(argv[1], "-a") == 0) {
		if (argc != 4)
			usage();
		opt_detach++;
		optcount++;
		detach_data.from = argv[3];
	}
#endif /* FIST_MNTSTYLE_ATTACH */

#ifdef FIST_DEBUG
	if (strcmp(argv[1], "-d") == 0) {
		if (argc > 4)
			usage();
		opt_d++;
		optcount++;
	}
#endif /* FIST_DEBUG */

#ifdef FIST_FILTER_SCA
	if (strcmp(argv[1], "-f") == 0) {
		if (argc > 4)
			usage();
		opt_f++;
		optcount++;
	}
#endif /* FIST_FILTER_SCA */

	/* check that at least one option was used */
	if (!optcount)
		usage();

	/* open file on which ioctl will operate */
	fd = open(argv[2], O_RDONLY);
	if (fd < 0) {
		perror(argv[2]);
		exit(1);
	}

#ifdef FIST_DEBUG
	/* if specified 3rd arg, want to set debug level */
	if (opt_d) {
		if (argc == 4) {
			val = atoi(argv[3]);
			ret = ioctl(fd, FIST_IOCTL_SET_DEBUG_VALUE, &val);
			if (ret < 0) {
				perror("ioctl set");
				exit(1);
			}
		} else {
			ret = ioctl(fd, FIST_IOCTL_GET_DEBUG_VALUE, &val);
			if (ret < 0) {
				perror("ioctl get");
				exit(1);
			}
			printf("debug ioctl returned value %d\n", val);
		}
		goto out;
	}
#endif /* FIST_DEBUG */

#ifdef FIST_FILTER_SCA
	/* if specified 3rd arg, want to set fast-tail flag */
	if (opt_f) {
		if (argc == 4) {
			val = atoi(argv[3]);
			ret = ioctl(fd, FIST_IOCTL_SET_FAST_TAIL_VALUE, &val);
			if (ret < 0) {
				perror("ioctl set");
				exit(1);
			}
		} else {
			ret = ioctl(fd, FIST_IOCTL_GET_FAST_TAIL_VALUE, &val);
			if (ret < 0) {
				perror("ioctl get");
				exit(1);
			}
			printf("fast-tail ioctl returned value %d\n", val);
		}
		goto out;
	}
#endif /* FIST_FILTER_SCA */

#ifdef FIST_MNTSTYLE_ATTACH
	if (opt_detach) {
		ret = ioctl(fd, FIST_IOCTL_DETACH, &detach_data);
		if (ret < 0) {
			perror("ioctl detach");
			exit(1);
		}
	}
	if (opt_attach) {
		ret = ioctl(fd, FIST_IOCTL_ATTACH, &attach_data);
		if (ret < 0) {
			perror("ioctl attach");
			exit(1);
		}
	}
#endif /* FIST_MNTSTYLE_ATTACH */

out:
	close(fd);
	exit(0);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
