/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: sca_list_idx.c,v 1.5 2005/01/03 21:10:42 ezk Exp $
 */
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "sca_aux.h"


void
usage(const char *progname)
{
	fprintf(stderr, "Usage: %s [idx file]\n", progname);
}


int
main(int argc, char **argv)
{
	int cnt, i, prev=0;
	unsigned int flags;
	struct fistfs_header hdr;

	if (argc != 2) {
		usage(argv[0]);
		exit(1);
	}

	if ((cnt = read_idx(argv[1], &hdr)) < 0) {
		fprintf(stderr, "sca_read_idx returns %d\n", cnt);
	}

	printf("Flag bits = 0x%x\n", hdr.flags);
	printf("Real file length %d, using %d chunks\n",
		   hdr.real_size, hdr.num_pages);
	for (i = 0; i < cnt; i++) {
		printf("%3d - %6ld [%ld]\n", i, hdr.offsets[i], hdr.offsets[i] - prev);
		prev = hdr.offsets[i];
	}
	exit(0);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
