/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: sca_mk_idx.c,v 1.5 2005/01/03 21:10:42 ezk Exp $
 */
#include <stdio.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <string.h>
#include <errno.h>

#include "sca_aux.h"
#include "sca_code.h"

extern int chunksize;	/* Must be the same as used to create the
			   file (put in header?) */
extern int do_fast_tails;


void
usage(const char *progname)
{
	fprintf(stderr,
                "Usage: %s [-c chunksize] [-f] file1 [file2 file3 ...]\n",
                progname);
}


int
main(int argc, char **argv)
{
	int i, rc = 0;

	if (argc < 2) {
		usage(argv[0]);
		exit(1);
	}

	while ((i = getopt(argc, argv, "c:f")) != EOF) {
		switch (i) {
		case 'c':
			chunksize = atoi(optarg);
			if (chunksize < 0) {
				fprintf(stderr, "Please use a positive chunk size\n");
				exit(1);
			}
			break;
		case 'f':
			do_fast_tails = 1;
			break;
		default:
			usage(argv[0]);
			exit(1);
		}
	}

	for (i = optind; i < argc; i++) {
		if ((rc = sca_fix_idx(argv[i]))) {
			fprintf(stderr, "Error fixing %s\n", argv[i]);
		}
	}
	exit(0);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
