/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: subr.c,v 1.5 2005/01/03 21:10:42 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include "fist.h"
#include "wrapfs.h"

#error do not compile this file directly. it is only an example.

#ifdef FIST_FILTER_DATA
/*
 * return the number of bytes written
 */
int
wrapfs_encode_block(const char *from, char *to, int len, const vnode_t *this_vnode, const vfs_t *this_vfsp, u_long pagenum)
{
        memcpy(to, from, len);
        return len;
}


int
wrapfs_decode_block(const char *from, char *to, int len, const vnode_t *this_vnode, const vfs_t *this_vfsp, u_long pagenum)
{
        memcpy(to, from, len);
        return len;
}
#endif /* FIST_FILTER_DATA */

#ifdef FIST_FILTER_NAME
int
wrapfs_encode_filename(const char *name, int length, char **encoded_name, int skip_dots, const vnode_t *this_vnode, const vfs_t *this_vfsp)
{
        int encoded_length;

        encoded_length = length + 1;
        *encoded_name = KMALLOC(encoded_length, GFP_KERNEL);
        if (!*encoded_name) {
                printk("<0>Kernel out of memory!\n");
                ASSERT(NULL);
        }
        memcpy(*encoded_name, name, length);
        (*encoded_name)[length] = '\0';

        return encoded_length;
}

/* returns length of decoded string, or -1 if error */
int
wrapfs_decode_filename(const char *name, int length, char **decoded_name, int skip_dots, const vnode_t *this_vnode, const vfs_t *this_vfsp)
{
        int error = 0;

        *decoded_name = KMALLOC(length, GFP_KERNEL);
        if (!*decoded_name) {
                printk("<0>Kernel out of memory!\n");
                ASSERT(NULL);
        }
        memcpy(*decoded_name, name, length);
        error = length;

        return error;
}
#endif /* FIST_FILTER_NAME */


/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
