/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
#ifdef FIST_USE_AUX_SRC
/*
 *  $$
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include <fist.h>
#include <wrapfs.h>


/*
 * Read "len" bytes from "filename" into "buf".
 * "buf" is in kernel space.
 */
int
wrapfs_read_file(const char *filename, void *buf, int len)
{
  vnode_t *vp;
  int err, closerr;
  int resid = 0;
  cred_t *cr = CRED();

  err = vn_open((char *)filename, UIO_SYSSPACE, FREAD,
		0640, &vp, (enum create)0);
  if (err)
    return err;

  err = vn_rdwr(UIO_READ, vp, buf, len,
		(offset_t)0, UIO_SYSSPACE, 0, (rlim64_t)0, cr, &resid);

  closerr = VOP_CLOSE(vp, FREAD, 1, (offset_t)0, cr);
  VN_RELE(vp);
  return (err ? err : closerr);
}


/*
 * Write "len" bytes from "buf" to "filename"
 * "buf" is in kernel space.
 */
int
wrapfs_write_file(const char *filename, void *buf, int len)
{
  vnode_t *vp;
  int err, closerr;
  int resid = 0;
  cred_t *cr = CRED();

  err = vn_open((char *)filename, UIO_SYSSPACE, FWRITE | FTRUNC | FCREAT,
		0640, &vp, (enum create)0);
  if (err)
    return err;

  err = vn_rdwr(UIO_WRITE, vp, buf, len,
		(offset_t)0, UIO_SYSSPACE, 0, (rlim64_t)0, cr, &resid);

  closerr = VOP_CLOSE(vp, FWRITE, 1, (offset_t)0, cr);
  VN_RELE(vp);
  return (err ? err : closerr);
}


/*
 * perform a special lookup with special permissions
 */
int
fist_lookup(vnode_t *dvp, char *name, vnode_t **vpp, pathname_t *pnp, int flags, vnode_t *rdir, cred_t *cr, uid_t uid, gid_t gid)
{
  int err;
  cred_t new_cr;

  bcopy(cr, &new_cr, sizeof(cred_t));
  new_cr.cr_uid = uid;
  new_cr.cr_gid = gid;
  err = VOP_LOOKUP(dvp, name, vpp, pnp, flags, rdir, &new_cr);
  return err;
}
#endif /* FIST_USE_AUX_SRC */
