/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: fist_ioctl.c,v 1.9 2005/01/03 21:10:42 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include <fist.h>
#include <wrapfs.h>

#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

int
main(int argc, char *argv[])
{
  int fd;
#ifdef FIST_DEBUG
  int ret, val = 0;
#endif /* FIST_DEBUG */

  if (argc < 2 || argc > 3) {
    fprintf(stderr, "Usage: %s file [val]\n", argv[0]);
    exit(1);
  }
  fd = open(argv[1], O_RDONLY);
  if (fd < 0) {
    perror(argv[1]);
    exit(1);
  }
#ifdef FIST_DEBUG
  /* if specified 3rd arg, want to set debug level */
  if (argc == 3) {
    val = atoi(argv[2]);
    ret = ioctl(fd, FIST_IOCTL_SET_DEBUG_VALUE, &val);
    if (ret < 0) {
      perror("ioctl set");
      exit(1);
    }
  } else {
    ret = ioctl(fd, FIST_IOCTL_GET_DEBUG_VALUE, &val);
    if (ret < 0) {
      perror("ioctl get");
      exit(1);
    }
    printf("ioctl returned value %d\n", val);
  }
#endif /* FIST_DEBUG */

  close(fd);
  exit(0);
}
