/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * Copyright (c) 1992 by Sun Microsystems, Inc.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef FISTGEN
# include "fist_wrapfs.h"
#endif /* FISTGEN */
#include <fist.h>
#include <wrapfs.h>

#if 0
#include <sys/param.h>
#include <sys/kmem.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <sys/cmn_err.h>
#include <sys/debug.h>
#include <sys/systm.h>
#include <sys/t_lock.h>
#include <sys/errno.h>
#include <sys/thread.h>
#include <sys/tiuser.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/clnt.h>
#include <vm/page.h>
#include <sys/pathname.h>

#include <fist.h>
#include FIST_HEADER
#endif

/* Print debugging functions */

#ifdef FIST_DEBUG

static int fist_debug_var = 0;


/* get value of debugging variable */
int
fist_get_debug_value(void)
{
  return fist_debug_var;
}


/* set debug level variable and return the previous value */
int
fist_set_debug_value(int val)
{
  int prev = fist_debug_var;

  fist_debug_var = val;
  return prev;
}


/*
 * Utilities used by both client and server
 * Standard levels:
 * 0) no debugging
 * 1) hard failures
 * 2) soft failures
 * 3) current test software
 * 4) main procedure entry points
 * 5) main procedure exit points
 * 6) utility procedure entry points
 * 7) utility procedure exit points
 * 8) obscure procedure entry points
 * 9) obscure procedure exit points
 * 10) random stuff
 * 11) all <= 1
 * 12) all <= 2
 * 13) all <= 3
 * ...
 */
void
fist_dprint_internal(int level, char *str, ...)
{
  va_list ap;
  int var = fist_get_debug_value();
#ifndef __GNUC__
  char newstr[256] = CONSOLE_PREFIX;
#endif /* not __GNUC__ */

  if (var == level || (var > 10 && (var - 10) >= level)) {
    va_start(ap, str);
#ifdef __GNUC__
    vcmn_err(CE_CONT, str, ap);
#else  /* not __GNUC__ */
    strcat(newstr, str);
    vcmn_err(CE_CONT, newstr, ap);
#endif /* not __GNUC__ */
    va_end(ap);
  }
  return;
}


#ifndef __GNUC__
void printk(char str, ...)
{
  va_list ap;
  char newstr[256] = CONSOLE_PREFIX;

  va_start(ap, str);
  strcat(newstr, str);
  vcmn_err(CE_CONT, newstr, ap);
  va_end(ap);
  return;
}
#endif /* not __GNUC__ */


void
fist_print_uap(char *fxn_name, struct mounta *uap)
{
  char namebuf[TYPICALMAXPATHLEN + 4];	/* +4 because of bug 1170077 */
  int len = 0;
  int error = 0;

  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNWON(print_uap)";

  if (uap) {
    fist_dprint(5, "%s: uap 0x%x\n", fxn_name, uap);

    /* what to mount */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->spec, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->spec %s\n", fxn_name, namebuf);

    /* on which mount point to mount */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->dir, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->dir %s\n", fxn_name, namebuf);

    /* primary mount flags */
    fist_dprint(5, "%s: uap->flags 0x%x\n", fxn_name, uap->flags);

    /* filesystem type ("fist_rot13fs") */
    strcpy(namebuf, "Null");
    len = 0;
    if (uap->spec) {
      error = copyinstr(uap->fstype, namebuf, TYPICALMAXPATHLEN, &len);
      if (error)
	strcpy(namebuf, "Null (copyinstr error)");
    }
    fist_dprint(5, "%s: uap->fstype %s\n", fxn_name, namebuf);

    /* data pointer is null so far */
    fist_dprint(5, "%s: uap->dataptr 0x%x\n", fxn_name, uap->dataptr);

    /* data length is 0 (because data pointer is null */
    fist_dprint(5, "%s: uap->datalen %d\n", fxn_name, uap->datalen);
  }
}


void
fist_print_vfs(char *fxn_name, struct vfs *vfsp)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNWON(print_vfs)";

  if (vfsp) {
    fist_dprint(5,
		"%s: vfsp 0x%x\n", fxn_name,
		vfsp);
    fist_dprint(5,
		"%s: vfsp->vfs_next 0x%x\n", fxn_name,
		vfsp->vfs_next);
    fist_dprint(5,
		"%s: vfsp->vfs_op 0x%x\n", fxn_name,
		vfsp->vfs_op);
    fist_dprint(5,
		"%s: vfsp->vfs_vnodecovered 0x%x\n", fxn_name,
		vfsp->vfs_vnodecovered);
    fist_dprint(5,
		"%s: vfsp->vfs_flag 0x%x\n", fxn_name,
		vfsp->vfs_flag);
    fist_dprint(5,
		"%s: vfsp->vfs_bsize %d\n", fxn_name,
		vfsp->vfs_bsize);
    fist_dprint(5,
		"%s: vfsp->vfs_fstype %d\n", fxn_name,
		vfsp->vfs_fstype);
    fist_dprint(5,
		"%s: vfsp->vfs_fsid 0x%x\n", fxn_name,
		vfsp->vfs_fsid);
    fist_dprint(5,
		"%s: vfsp->vfs_data 0x%x\n", fxn_name,
		vfsp->vfs_data);
    fist_dprint(5,
		"%s: vfsp->vfs_dev 0x%x\n", fxn_name,
		vfsp->vfs_dev);
    fist_dprint(5,
		"%s: vfsp->vfs_bcount %d\n", fxn_name,
		vfsp->vfs_bcount);
    fist_dprint(5,
		"%s: vfsp->vfs_nsubmounts %d\n", fxn_name,
		vfsp->vfs_nsubmounts);
    fist_dprint(5,
		"%s: vfsp->vfs_list 0x%x\n", fxn_name,
		vfsp->vfs_list);
    fist_dprint(5,
		"%s: vfsp->vfs_hash 0x%x\n", fxn_name,
		vfsp->vfs_hash);
    fist_dprint(5,
		"%s: vfsp->vfs_reflock 0x%x\n", fxn_name,
		vfsp->vfs_reflock);
  }
}


void
fist_print_uio(char *fxn_name, uio_t * uiop)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_uio)";

  fist_dprint(7, "BEGINNING UIO\n");
  fist_dprint(7,
	      "%s: uio 0x%x\n", fxn_name, uiop);
  if (uiop) {
    fist_dprint(7,
		"%s: uio_iov 0x%x\n", fxn_name, uiop->uio_iov);
    fist_dprint(7,
		"%s: uio_iovcnt %d\n", fxn_name, uiop->uio_iovcnt);
    fist_dprint(7,
		"%s: uio_loffset %d\n", fxn_name, uiop->uio_offset);
    fist_dprint(7,
		"%s: uio_segflg %d\n", fxn_name, uiop->uio_segflg);
    fist_dprint(7,
		"%s: uio_fmode 0x%x\n", fxn_name, (u_int) uiop->uio_fmode);
    fist_dprint(7,
		"%s: uio_limit %d\n", fxn_name, uiop->uio_limit);
    fist_dprint(7,
		"%s: uio_resid %d\n", fxn_name, uiop->uio_resid);
  }
  fist_dprint(7, "ENDING UIO\n");
}


void
fist_print_uios(char *fxn_name, uio_t * uiop)
{
  int i;
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_uios)";

  fist_dprint(7, "BEGINNING UIOs\n");
  fist_dprint(7,
	      "%s: uio 0x%x\n", fxn_name, uiop);
  if (uiop && uiop->uio_iovcnt) {
    fist_dprint(7,
		"%s: uio_iovcnt %d\n", fxn_name, uiop->uio_iovcnt);
    fist_dprint(7,
		"%s: uio_loffset %d\n", fxn_name, uiop->uio_offset);
    fist_dprint(7,
		"%s: uio_segflg %d\n", fxn_name, uiop->uio_segflg);
    fist_dprint(7,
		"%s: uio_fmode 0x%x\n", fxn_name, (u_int) uiop->uio_fmode);
    fist_dprint(7,
		"%s: uio_limit %d\n", fxn_name, uiop->uio_limit);
    fist_dprint(7,
		"%s: uio_resid %d\n", fxn_name, uiop->uio_resid);
    for (i = 0; i < uiop->uio_iovcnt; i++) {
      fist_dprint(7,
		  "%s: uio_iov[%d].iov_len %d\n",
		  fxn_name, i, uiop->uio_iov[i].iov_len);
      fist_dprint(7,
		  "%s: uio_iov[%d].iov_base is 0x%x\n",
		  fxn_name, i, uiop->uio_iov[i].iov_base);
    }
  }
  fist_dprint(7, "ENDING UIO\n");
}


void
fist_print_pnp(char *f_name, pathname_t *pnp)
{
  char *pn_buf;
  char *pn_path;

  /* safety */
  if (!f_name)
    f_name = "UNKNOWN(print_pnp)";

  if (pnp) {
    /* allocate memory for our temporary strings */
    pn_buf=kmem_alloc((pnp->pn_bufsize+1)*sizeof(char),KM_SLEEP);
    pn_path=kmem_alloc((pnp->pn_pathlen+1)*sizeof(char),KM_SLEEP);
    bcopy(pnp->pn_buf,pn_buf,pnp->pn_bufsize);
    bcopy(pnp->pn_path,pn_path,pnp->pn_pathlen);
    /* zero out the last byte */
    pn_buf[pnp->pn_bufsize]='\0';
    pn_path[pnp->pn_pathlen]='\0';

    fist_dprint(4,"%s: pnp->pn_buf %s\n",f_name,pn_buf);
    fist_dprint(4,"%s: pnp->pn_bufsize %d\n",f_name,pnp->pn_bufsize);
    fist_dprint(4,"%s: pnp->pn_path %s\n",f_name,pn_path);
    fist_dprint(4,"%s: pnp->pn_pathlen %d\n",f_name,pnp->pn_pathlen);
  }
}


void
fist_print_vnode(char *fxn_name, struct vnode *vp)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_vp)";

  if (vp) {
    fist_dprint(5,
		"%s: vp 0x%x\n", fxn_name,
		vp);
    fist_dprint(5,
		"%s: vp->v_lock 0x%x\n", fxn_name,
		vp->v_lock);
    fist_dprint(5,
		"%s: vp->v_flag 0x%x\n", fxn_name,
		vp->v_flag);
    fist_dprint(5,
		"%s: vp->v_count %d\n", fxn_name,
		vp->v_count);
    fist_dprint(5,
		"%s: vp->v_vfsmountedhere 0x%x\n", fxn_name,
		vp->v_vfsmountedhere);
    fist_dprint(5,
		"%s: vp->v_op 0x%x\n", fxn_name,
		vp->v_op);
    fist_dprint(5,
		"%s: vp->v_vfsp 0x%x\n", fxn_name,
		vp->v_vfsp);
    fist_dprint(5,
		"%s: vp->v_stream 0x%x\n", fxn_name,
		vp->v_stream);
    fist_dprint(5,
		"%s: vp->v_pages 0x%x\n", fxn_name,
		vp->v_pages);
    fist_dprint(5,
		"%s: vp->v_type 0x%x\n", fxn_name,
		vp->v_type);
    fist_dprint(5,
		"%s: vp->v_rdev 0x%x\n", fxn_name,
		vp->v_rdev);
    fist_dprint(5,
		"%s: vp->v_data 0x%x\n", fxn_name,
		vp->v_data);
    fist_dprint(5,
		"%s: vp->v_filocks 0x%x\n", fxn_name,
		vp->v_filocks);
    fist_dprint(5,
		"%s: vp->v_cv 0x%x\n", fxn_name,
		vp->v_cv);
  }
}


void
fist_print_pathname(char *fxn_name, struct pathname *pnp)
{
  /* safety */
  if (!fxn_name)
    fxn_name = "UNKNOWN(print_pathname)";

  if (pnp) {
    fist_dprint(8,
		"%s: pnp 0x%x\n", fxn_name,
		pnp);
    fist_dprint(8,
		"%s: pnp->pn_buf \"%s\"\n", fxn_name,
		pnp->pn_buf);
    fist_dprint(8,
		"%s: pnp->pn_path \"%s\"\n", fxn_name,
		pnp->pn_path);
    fist_dprint(8,
		"%s: pnp->pn_pathlen %d\n", fxn_name,
		pnp->pn_pathlen);
    fist_dprint(8,
		"%s: pnp->pn_bufsize %d\n", fxn_name,
		pnp->pn_bufsize);
  }
}

#endif /* FIST_DEBUG */
