/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * Copyright (c) 1992 by Sun Microsystems, Inc.
 */

#ifndef	__FIST_H_
#define	__FIST_H_

#include <sys/param.h>
#include <sys/kmem.h>
#include <sys/errno.h>
#include <sys/vnode.h>
#include <sys/vfs.h>
#include <sys/uio.h>
#include <sys/cred.h>
#include <sys/pathname.h>
#include <sys/dirent.h>
#include <sys/debug.h>
#include <sys/sysmacros.h>
#include <sys/thread.h>
#include <sys/tiuser.h>
#include <sys/cmn_err.h>
#include <sys/stat.h>
#include <sys/mode.h>
#include <sys/t_lock.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/clnt.h>
#include <sys/fs_subr.h>
#include <sys/mman.h>
#include <sys/vm.h>
#include <sys/mount.h>
#include <sys/mkdev.h>
#include <sys/ioccom.h>
#include <vm/as.h>
#include <vm/pvn.h>
#include <vm/seg_vn.h>
#include <vm/seg_kp.h>
#include <vm/seg_map.h>
#include <vm/page.h>

#include <stdarg.h>
/*
 * On Solaris 2.6, <sys/systm.h> includes <sys/varargs.h> which
 * which conflicts with some gcc definitions.
 */
#ifndef _SYS_VARARGS_H
# define _SYS_VARARGS_H
#endif /* not _SYS_VARARGS_H */
#include <sys/systm.h>


#ifdef FIST_DEBUG
/* for ioctl */
#define FIST_DBGIOC			('f' << 8)
#define FIST_IOCTL_GET_DEBUG_VALUE	(FIST_DBGIOC | 01)
#define FIST_IOCTL_SET_DEBUG_VALUE	(FIST_DBGIOC | 02)
/* reserve 10h-20h for specific fs */
#endif /* FIST_DEBUG */

#ifdef _KERNEL

/* common header definitions to all fist kernel modules */

#define	TYPICALMAXPATHLEN	64

#ifdef FIST_DEBUG

extern void fist_dprint_internal(int level, char *str, ...);
extern void fist_print_vnode(char *, vnode_t *);
extern void fist_print_vfs(char *, struct vfs *);
extern void fist_print_uap(char *, struct mounta *);
extern void fist_print_uio(char *, uio_t *);
extern void fist_print_uios(char *, uio_t *);
extern void fist_print_pnp(char *, pathname_t *);
extern void fist_print_pathname(char *fxn_name, struct pathname *pnp);
extern int fist_get_debug_value(void);
extern int fist_set_debug_value(int val);
#define print_location() \
	fist_dprint(4, "%s %s:%d\n", __FUNCTION__, __FILE__, __LINE__)

#define EZKDBG printk("EZK %s:%d:%s\n",__FILE__,__LINE__,__FUNCTION__)

#undef CONSOLE_DEBUG
#ifdef CONSOLE_DEBUG
# define CONSOLE_PREFIX ""
#else /* not CONSOLE_PREFIX */
# define CONSOLE_PREFIX "!"
#endif /* not CONSOLE_PREFIX */

#ifdef __GNUC__
#define printk(format, args...) \
	cmn_err(CE_CONT, CONSOLE_PREFIX format, ## args)
#define fist_dprint(level, str, args...) \
	fist_dprint_internal(level, CONSOLE_PREFIX str, ## args)
#else  /* not __GNUC__ */
void printk(char str, ...);
#define fist_dprint fist_dprint_internal
#endif /* not __GNUC__ */

#else /* not FIST_DEBUG */

#ifdef __GNUC__
#define printk(format, args...)
#define fist_dprint(level, format, args...)
#else  /* __GNUC__ */
/* this prints warnings with gcc, but it's not for gcc consumption anyway... */
#define printk (void)
#define fist_dprint (void)
#endif /* __GNUC__ */
#define print_location()
#define fist_print_vnode(a, b)
#define fist_print_vfs(a, b)
#define fist_print_uap(a, b)
#define fist_print_pathname(a, b)
#define fist_get_debug_value()	(-1)
#define fist_print_uio(a, b)
#define fist_print_uios(a, b)
#define fist_set_debug_value(a)
#define EZKDBG

#endif /* not FIST_DEBUG */

extern vnode_t *fist_ht_find_vp(const vnode_t * hidden_vp, const vfs_t * this_vfsp);
extern void fist_ht_del_vp(const vnode_t * hidden_vp, const vfs_t * this_vfsp);
extern void fist_ht_insert_vp(vnode_t * hidden_vp, vnode_t * this_vp);
extern int fist_ht_empty_assert(const vfs_t * this_vfsp);

#define	FIST_HT_SIZE	64
#define	fisttablehash(vp)	((((int)(vp))>>10) & (FIST_HT_SIZE-1))

typedef struct fist_bucket {
  vnode_t *hidden_vp;		/* index */
  vnode_t *this_vp;
  struct fist_bucket *next;
} fist_bucket_t;

#endif /* _KERNEL */

#endif /* not __FIST_H_ */
