/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
#include <sys/types.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/mntent.h>
#include <stdio.h>

int main(int argc, char **argv)
{
  int err = 0;
  char fs_name[100];

  /* validate input */
  if (argc != 4) {
    fprintf(stderr, "Usage: %s [fs_type interposed_dir mount_point]\n",
	    argv[0]);
    exit(1);
  }
  sprintf(fs_name, "%s", argv[1]);

  err = mount(argv[2], argv[3] , MS_FSS, fs_name, 0, 0);
  if (err < 0) {
    perror(argv[0]);
  }
  exit(err);
}
