/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 * Copyright (c) 1992 by Sun Microsystems, Inc.
 */

/*
 * fist_wrapfs mount info - one per mount
 */

#ifndef	__WRAPFS_H_
#define	__WRAPFS_H_

#if 0
#include <vm/page.h>
#include <sys/tiuser.h>
#endif

#undef	MAXNAMLEN
#define	MAXNAMLEN	255

#if 0
struct wrapfs_args {
  struct netbuf addr;		/* daemon address */
  char *path;			/* fist_wrapfs mountpoint */
  char *opts;			/* default mount options */
  char *map;			/* name of map */
  int mount_to;			/* time in sec the fs is to remain */
  /* mounted after last reference */
  int rpc_to;			/* timeout for rpc calls */
  int direct;			/* 1 = direct mount */
};
#endif

#ifdef	_KERNEL

#define FIST_HASH_SHIFT  4
#define FIST_HASH_SIZE  (1 << FIST_HASH_SHIFT)
#define FIST_HASH_MASK  (FIST_HASH_SIZE - 1)

struct wrapfs_callargs {
  vnode_t *fwc_vp;		/* vnode */
  char *fwc_name;		/* name of path to mount */
  cred_t *fwc_cred;
};

/* per-vfs structure */
struct fist_wrapfs_info {
  struct vfs *fwi_mountvfs;	/* vfs we interpose on */
  struct vnode *fwi_rootvnodep;	/* root vnode */
  int fwi_num_vnodes;		/* # of interposed vnodes */
  /* HT to map hidden_vp to vp */
  fist_bucket_t *fwi_buckets[FIST_HT_SIZE];
  kmutex_t fwi_ht_lock;	/* lock for HT */
  /* additional per-vfs BDTs */
  FIST_VFS_FIELDS;
};

/*
 * Per-vnode data structure.
 * The fist_wrapfs_node is the "inode" for fist_wrapfs.  It contains
 * all the information necessary to handle fist_wrapfs mounting.
 */
typedef struct fist_wrapfs_node {
  vnode_t *fwn_vnodep;		/* interposed vnode pointer */
  u_int fwn_mapcnt;		/* mapped pages counter */
  kmutex_t fwn_lock;		/* lock for private data */
} fist_wrapfs_node_t;


/*
 * Convert between vfs/fist_wrapfs_info & vnode/fist_wrapfs_node
 */
#define	fwntovn(ap)	(&((ap)->fwn_vnode))
#define	vntofwn(vp)	((struct fist_wrapfs_node *) ((vp)->v_data))
#define	vfstofwi(vfsp)	((struct fist_wrapfs_info *) ((vfsp)->vfs_data))
#define vfs2priv	vfstofwi
#define vnode2lower(x)	vntofwn(x)->fwn_vnodep
#define dir2lower(x)	vntofwn(x)->fwn_vnodep
#define memcpy(x,y,n)	bcopy((y),(x),(n))

/*
 * Flags for wrapfs_{en,de}code_filename
 * DO_DOTS means the special entries . and .. should be encoded (for symlink)
 * SKIP_DOTS means they should be preserved intact
 */
#define DO_DOTS   0
#define SKIP_DOTS 1

extern kmutex_t fist_wrapfs_node_list_lock;
extern struct fist_wrapfs_node *fist_wrapfs_node_list;
extern kmutex_t fist_wrapfs_node_count_lock;
extern int anode_cnt, make_fist_wrapfs_node_count, free_fist_wrapfs_node_count;

extern int do_mount(vnode_t *, char *, cred_t *);
extern int fist_wrapfs_dir_lookup(vnode_t *, char *, vnode_t **, cred_t *);
extern int wrapfs_direnter(fist_wrapfs_node_t *, fist_wrapfs_node_t *);
extern void do_unmount(void);
extern vnode_t *make_fist_wrapfs_node(vtype_t, vfs_t *, cred_t *);
extern void free_fist_wrapfs_node(fist_wrapfs_node_t * anp);

/* for page to kernel virtual memory mapping */
extern caddr_t ppmapin(page_t * pp, u_int vprot, caddr_t hint);
extern void ppmapout(caddr_t va);
extern vnode_t *wrapfs_interpose(vnode_t * hidden_vp, vfs_t * this_vfsp);
extern int isbad(caddr_t base, int len);

#ifdef FIST_FILTER_DATA
extern int wrapfs_encode_block(const char *from, char *to, int len, const vnode_t *this_vnode, const vfs_t *this_vfsp);
extern int wrapfs_decode_block(const char *from, char *to, int len, const vnode_t *this_vnode, const vfs_t *this_vfsp);
#endif /* FIST_FILTER_DATA */

#ifdef FIST_FILTER_NAME
extern int wrapfs_decode_filename(const char *name, int length, char **decoded_name, int skip_dots, const vnode_t *this_vnode, const vfs_t *this_vfsp);
extern int wrapfs_encode_filename(const char *name, int length, char **encoded_name, int skip_dots, const vnode_t *this_vnode, const vfs_t *this_vfsp);
#endif /* FIST_FILTER_NAME */

#ifdef FIST_USE_AUX_SRC
extern int wrapfs_read_file(const char *filename, void *buf, int len);
extern int wrapfs_write_file(const char *filename, void *buf, int len);
extern int fist_lookup(vnode_t *dvp, char *name, vnode_t **vpp, pathname_t *pnp, int flags, vnode_t *rdir, cred_t *cr, uid_t uid, gid_t gid);
#endif /* FIST_USE_AUX_SRC */

/* auto-generated extern definitions */
FIST_AUTO_GENERATED_EXTERNS

#endif /* _KERNEL */

/*
 * Definitions for user and kernel code
 */

/* ioctls */
FIST_IOCTL_DEFS

#endif /* __WRAPFS_H_ */
