/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
/*
 *  $Id: sca_code.c,v 1.8 2005/01/03 21:10:42 ezk Exp $
 */

#include "sca_code.h"
#include "sca_aux.h"


int
sca_encode_page(unsigned char *in, int inlen, unsigned char **out, int *outlen)
{
  int i;
  int incnt, outcnt;
  unsigned char A, B, C;

  A = B = C = 0;

  i = 4 * (inlen / 3);	/* Every 3 characters -> 4 */
  if (inlen % 3)
    i+=4;

  *out = (unsigned char *) malloc(i);

  if (*out == NULL) {
    fprintf(stderr, "malloc failed on %d with %d\n", inlen, errno);
    return(-1);
  }

  (*outlen) = i;

  incnt = outcnt = 0;
  /* First do full lines */
  while ((inlen - incnt) > 3) {
    A = in[incnt];
    B = in[incnt+1];
    C = in[incnt+2];
    (*out)[outcnt]   = 0x20 + (( A >> 2 ) & 0x3F);
    (*out)[outcnt+1] = 0x20 +
      ((( A << 4 ) | ((B >> 4) & 0xF)) & 0x3F);
    (*out)[outcnt+2] = 0x20 +
      ((( B << 2 ) | ((C >> 6) & 0x3)) & 0x3F);
    (*out)[outcnt+3] = 0x20 +
      ((C) & 0x3F);
    outcnt += 4;		/* Move ahead 4 bytes */
    incnt += 3;
  }

  /* Now do a partial line */
  switch (inlen - incnt) {
  case 0:
    break;

  case 1:
    A = in[incnt];
    B = 0;
    C = 0;
    incnt+=1;
    break;
  case 2:
    A = in[incnt];
    B = in[incnt+1];
    C = 0;
    incnt+=2;
    break;
  default:
    A = in[incnt];
    B = in[incnt+1];
    C = in[incnt+2];
    incnt += 3;
    break;
  }

  (*out)[outcnt]   = 0x20 + (( A >> 2 ) & 0x3F);
  (*out)[outcnt+1] = 0x20 +
    ((( A << 4 ) | ((B >> 4) & 0xF)) & 0x3F);
  (*out)[outcnt+2] = 0x20 +
    ((( B << 2 ) | ((C >> 6) & 0x3)) & 0x3F);
  (*out)[outcnt+3] = 0x20 +
    ((C) & 0x3F);
  outcnt += 4;		/* Move ahead 4 bytes */

end:
  /*   fprintf(stderr,"outcnt = %d, outlen = %d\n",outcnt, *outlen); */
  return(outcnt);
}


int
sca_decode_page(unsigned char *in, int inlen, unsigned char **out, int *outlen)
{
  int outsize = 0, i,j;
  unsigned char *ptr;
  int outcnt = 0;
  unsigned char A, B, C, D;

  i = (inlen * 3);
  j = i/4;
  if (i % 4)
    j+=3;

  (*out) = (unsigned char *) malloc(j);
  if (j > chunksize)
    outsize = chunksize;

  if ((*out) == NULL) {
    fprintf(stderr, "malloc failed on %d with %d\n", inlen, errno);
    return(-1);
  }

  (*outlen) = j;
  outcnt = 0;
  i=0;
  while (i < inlen) {
    A = in[i] - 0x20;
    B = in[i+1] - 0x20;
    C = in[i+2] - 0x20;
    D = in[i+3] - 0x20;

    (*out)[outcnt] = (A<<2) | (B>>4);
    (*out)[outcnt+1] = (B<<4) | (C>>2);
    (*out)[outcnt+2] = (C<<6) | D;
    if (outsize > 3)
      outcnt += 3;
    else
      outcnt += outsize;
    outsize -= 3;
    i += 4;
  }
  /*   fprintf(stderr,"outcnt = %d, outlen = %d\n",outcnt, *outlen); */
  return(outcnt);
}


int
sca_fix_idx(char *name)
{
  int srcfd;
  unsigned char *ptr, *data;
  char filename[PATH_MAX];
  int cnt, rc, offset = 0, remainder, tmp;
  struct fistfs_header hdr;
  struct stat sb;

  hdr.num_pages = 0;
  hdr.real_size = 0;
  hdr.offsets = NULL;

  if (name == NULL)
    return(-1);
  if ((srcfd = open(name,O_RDONLY)) < 0)
    return(-1);

  if (do_fast_tails)
    hdr.flags |= 0x80000000;

  if ((ptr = strrchr(name,'.')) == NULL) {
    fprintf(stderr, "No .gzf suffix, creating %s.idx\n", name);
    sprintf(filename, "%s.idx", name);
  } else {
    ptr[0] = '\0';
    strncpy(filename, name, PATH_MAX-5);
    cnt = strlen(filename);
    filename[cnt] = '.';
    filename[cnt+1] = 'i';
    filename[cnt+2] = 'd';
    filename[cnt+3] = 'x';
    fprintf(stderr, "Creating %s\n", filename);
  }

  if ((fstat(srcfd,&sb)) < 0)
    return(-1);

  offset = chunksize/3;
  if (chunksize % 3) offset++;
  offset *= 4;

  cnt = (sb.st_size/offset);
  if ((do_fast_tails == 0) && (sb.st_size % offset))
    cnt++;

  hdr.num_pages = cnt;
  if ((hdr.offsets = (off_t *) malloc (sizeof(off_t) * cnt)) == NULL) {
    return(-1);
  }

  cnt = (sb.st_size/offset);
  if (do_fast_tails == 0)
    cnt++;
  else if ((sb.st_size % chunksize) == 0)
    cnt++;
  /* Otherwise, the last page is missing  */

  for (rc=0; rc<cnt; rc++)
    hdr.offsets[rc] = (rc+1) * offset;

  hdr.real_size = chunksize * (hdr.num_pages-1);
  if (do_fast_tails == 0) {
    hdr.offsets[rc-2] = sb.st_size;
    tmp = ((hdr.offsets[rc-2] - hdr.offsets[rc-3]) * 3)/4;
    if (tmp > chunksize) tmp = chunksize;
    hdr.real_size += tmp;
    if (((hdr.offsets[rc-2] - hdr.offsets[rc-3]) * 3)%4)
      hdr.real_size += 4;
  } else {
    hdr.real_size += sb.st_size - hdr.offsets[rc-2];
  }

  if (write_idx(filename, &hdr) < 0) {
    fprintf(stderr, "Error writing %s (%d)\n", filename, errno);
    return(-1);
  }
  return(0);
}
