/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
%{
/*
 * wparse.y: C source (wrapfs) mini-parser
 * Fistgen sources.
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


extern char *yytext;
extern int wyylex(void);
extern int wyylineno;
extern void free(void *);

static int yyerror(const char *s);
extern int print_code;
extern FILE *wyyout;
static int sv;

extern int wll_input(void);
extern void wll_unput(int c);
int c;				/* temp for reading chars */
#define SKIP_NEWLINE	if ((c = wll_input()) != '\n') wll_unput(c); \
				else wyylineno++
#define SET_PRINT_STATE(cur,new) (cur) = (new)

#define YYDEBUG 0
#define PARSE_DEBUG 0

#if PARSE_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), wyylineno, (s))
# define fist_return(v)
#else /* not PARSE_DEBUG */
# define dprintf(f,s)
# define fist_return(v) return((v))
#endif /* not PARSE_DEBUG */

static int parsedebug;

%}

%union {
char *strtype;
int inttype;
}

%token NEWLINE
%token <strtype> PND_ELSE PND_ENDIF
%token <strtype> PND_IF PND_IFDEF PND_IFNDEF PND_ELIF
%token <strtype> FWORD

%start file
%%

/****************************************************************************/
file		: {
		   wyylineno = 1;
#if YYDEBUG != 0
		   yydebug = YYDEBUG;
#endif /* YYDEBUG != 0 */
		   parsedebug = PARSE_DEBUG;
		   print_code = TRUE;
		   stk_init();
		  } text
		;

text		: cpps_or_words
		| /* can be empty */
		;

cpps_or_words	: cpp_or_word
		| cpp_or_word cpps_or_words
		;

cpp_or_word	: cpp_conditional
		| word
		;

word		: FWORD
		{
		  if (parsedebug)
		    fprintf(stderr, "fword +%s\n", $1);
		  expand_fword($1);
		}
		;

cpp_conditional : if_line text elif_parts else_part endif_part
		| if_line text else_part endif_part
		| if_line text elif_parts endif_part
		| if_line text endif_part
		;

if_line		: PND_IF
		{
		  if (parsedebug)
		    fprintf(stderr, "pnd_if +%s\n", $1);
		  stk_push(print_code);
		  sv = symtab_val($1);
		  if (sv < 0) {	/* unknown symbol */
		    wyy_echo("#if ");
		    wyy_echo($1);
		    if (print_code)
		      SET_PRINT_STATE(print_code, 2);
		  } else {	/* symbol is known */
		    if (print_code) {
		      SET_PRINT_STATE(print_code, sv);
		      SKIP_NEWLINE;
		    }
		  }
		}
		| PND_IFDEF
		{
		  if (parsedebug)
		    fprintf(stderr, "pnd_ifdef +%s\n", $1);
		  stk_push(print_code);
		  sv = symtab_val($1);
		  if (sv < 0) {	/* unknown symbol */
		    wyy_echo("#ifdef ");
		    wyy_echo($1);
		    if (print_code)
		      SET_PRINT_STATE(print_code, 2);
		  } else {	/* symbol is known */
		    if (print_code) {
		      SET_PRINT_STATE(print_code, sv);
		      SKIP_NEWLINE;
		    }
		  }
		}
		| PND_IFNDEF
		{
		  if (parsedebug)
		    fprintf(stderr, "pnd_ifndef +%s\n", $1);
		  stk_push(print_code);
		  sv = symtab_val($1);
		  if (sv < 0) {	/* unknown symbol */
		    wyy_echo("#ifndef ");
		    wyy_echo($1);
		    if (print_code)
		      SET_PRINT_STATE(print_code, 2);
		  } else {	/* symbol is known */
		    if (print_code) {
		      SET_PRINT_STATE(print_code, NEGATE(sv));
		      SKIP_NEWLINE;
		    }
		  }
		}
		;

elif_parts	: elif_part
		| elif_part elif_parts
		;

elif_part	: elif_line text
		;

elif_line	: PND_ELIF
		{
		  if (parsedebug)
		    fprintf(stderr, "elif fword +%s\n", $1);
		  sv = symtab_val($1);
		  if (sv < 0) {	/* unknown symbol */
		    wyy_echo("#elif ");
		    wyy_echo($1);
		    if (print_code)
		      SET_PRINT_STATE(print_code, 2);
		  } else {	/* symbol is known */
		    if (print_code) {
		      SET_PRINT_STATE(print_code, sv);
		      SKIP_NEWLINE;
		    }
		  }
		}
		;

else_part	: else_line text
		;

else_line	: PND_ELSE
		{
		  if (print_code > 1) {
		    wyy_echo($1);
		  } else {
		    if (stk_top()) {
		      SET_PRINT_STATE(print_code,  NEGATE(print_code));
		    }
		    SKIP_NEWLINE;
		  }
		}
		;

endif_part	: PND_ENDIF
		{
		  if (print_code > 1) {
		    wyy_echo($1);
		  } else {
		    SKIP_NEWLINE;
		  }
		  SET_PRINT_STATE(print_code, stk_pop());
		}
		;

/****************************************************************************/

%%

static int
yyerror(const char *s)
{
  fprintf(stderr, "%s:%d: %s\n", current_file, wyylineno, s);
  exit(1);
  return 1;	/* to fool compilers that insist on a return statement */
}


void
wyy_echo(const char *s)
{
#if 0
  static int last_pc;

  if (last_pc == 0 && print_code) {
    fprintf(wyyout, "#line %d\t\"%s%s\"\n", wyylineno+1,
	    (current_file[0] == '/' ? "" : "../../../"),
	    current_file);
  }
  last_pc = print_code;
#endif
  if (print_code)
    fputs(s, wyyout);
}
