/*
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package, or get one from ftp://ftp.filesystems.org/pub/fistgen/COPYING.
 *
 * This Copyright notice must be kept intact and distributed with all
 * fistgen sources INCLUDING sources generated by fistgen.
 */
%{
/*
 * wtok.l: Lexical analyzer for wrapfs template parser
 * Fistgen sources.
 * Copyright (c) 1997-2005 Erez Zadok <ezk@cs.stonybrook.edu>
 * Copyright (c) 2001-2005 Stony Brook University
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */


/*
 * Some systems include a definition for the macro ECHO in <sys/ioctl.h>,
 * and their (bad) version of lex defines it too at the very beginning of
 * the generated lex.yy.c file (before it can be easily undefined),
 * resulting in a conflict.  So undefine it here before needed.
 * Luckily, it does not appear that this macro is actually used in the rest
 * of the generated lex.yy.c file.
 */
#ifdef ECHO
# undef ECHO
#endif /* ECHO */
static void ll_echo(void);	/* forward definition */
#define ECHO ll_echo()
#include <wparse.h>

static void ll_putc(char c);	/* forward */
static void ll_puts(const char *s); /* forward */
static char *cp;

/*
 * There are some things that need to be defined only if useing GNU flex.
 * These must not be defined if using standard lex
 */
#ifdef FLEX_SCANNER
int wyylineno;
#endif /* FLEX_SCANNER */

int print_code;			/* boolean: print code or not? */

int yylex(void);
int yywrap(void);

#define TOK_DEBUG 0

#if TOK_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), wyylineno, (s))
# define fist_return(v)
#else
# define dprintf(f,s)
# define fist_return(v) return((v))
#endif /* TOK_DEBUG */

/* no need to use yyunput() or yywrap() */
/* #define YY_NO_UNPUT */
#define YY_SKIP_YYWRAP

%}

%x OPT_DECLS FIST_DECLS FIST_RULES OPT_CODE

WS		[[:blank:]]+
OPTWS		[[:blank:]]*
NOT_WS		[^[:blank:]\n]+
NL		\r?\n
NON_NL		[^\r\n]
WORD		([[:alpha:]_][[:alnum:]_]*)
FWORD		FIST_{WORD}
ALPHA		([[:alpha:]_]+){3,}
NON_WORD	[^[:alpha:]_*\n]+
NUMBER		[0-9][0-9]*
NON_FIST_DECL	[^[:alpha:]_;:{}\[\]\r\n]
VARG		{ALPHA}
ATTR		{WORD}
FUNCTIONS	fistGetFoo|fistGetBar

%%

<INITIAL>{

	{NL}		{
			wyylineno++;
			ll_putc('\n');
			}

	"/*"		{
			  register int c; /* temp for reading chars */
			  int comment_start_line = wyylineno;
			  dprintf("%8d: start of comment \"%s\"\n", yytext);
			  ll_puts("/*");
			  while (1) {
			      /* eat up text of comment */
			      while ((c = input()) != '*' &&
				     c != '\n' &&
				     c != EOF )
				ll_putc(c);
			      if (c == '\n') {
				ll_putc(c);
				wyylineno++;
			      }
			      if (c == '*') {
				ll_putc(c);
				while ( (c = input()) == '*' )
				  ll_putc(c);
				ll_putc(c);
				if (c == '/')
				  break;	/* found the end */
			      }
			      if (c == EOF) {
				char buf[80];
				sprintf(buf, "%s:%d: start of unterminated comment (EOF on line %d)", in_file, comment_start_line, wyylineno);
				YY_FATAL_ERROR(buf);
				break;
			      }
			  }
			}

	"\""		{
			  register int c; /* temp for reading chars */
			  int quote_start_line = wyylineno;
			  dprintf("%8d: start of quote \"%s\"\n", yytext);
			  ll_putc('"');
			  while (1) {
			      /* eat up text quote */
			      while ((c = input()) != '"' &&
				     c != '\n' &&
				     c != EOF )
				ll_putc(c);
			      if (c == '\n') {
				ll_putc(c);
				wyylineno++;
			      }
			      if (c == '"') {
				ll_putc(c);
				break; /* found the end */
			      }
			      if (c == EOF) {
				char buf[80];
				sprintf(buf, "%s:%d: start of unterminated quote (EOF on line %d)", in_file, quote_start_line, wyylineno);
				YY_FATAL_ERROR(buf);
				break;
			      }
			  }
			}

^"#"{OPTWS}"if"{WS}{NOT_WS}	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  cp = &yytext[strlen(yytext)-1];
			  while (!isspace((int)*--cp)) ;
			  wyylval.strtype = strdup(++cp);
			  fist_return(PND_IF);
			}

^"#"{OPTWS}"ifdef"{WS}{NOT_WS}	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  cp = &yytext[strlen(yytext)-1];
			  while (!isspace((int)*--cp)) ;
			  wyylval.strtype = strdup(++cp);
			  /* skip newline if last next char */
			  /*			  if ((c = input()) != '\n')
						  unput(c); */
			  fist_return(PND_IFDEF);
			}

^"#"{OPTWS}"ifndef"{WS}{NOT_WS}	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  cp = &yytext[strlen(yytext)-1];
			  while (!isspace((int)*--cp)) ;
			  wyylval.strtype = strdup(++cp);
			  fist_return(PND_IFNDEF);
			}

^"#"{OPTWS}"elif"{WS}{NOT_WS}	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  cp = &yytext[strlen(yytext)-1];
			  while (!isspace((int)*--cp)) ;
			  wyylval.strtype = strdup(++cp);
			  fist_return(PND_ELIF);
			}

^"#"{OPTWS}"else"{NON_NL}*	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  wyylval.strtype = strdup(yytext);
			  fist_return(PND_ELSE);
			}

^"#"{OPTWS}"endif"{NON_NL}*	{
			  dprintf("%8d: pnd_cmd \"%s\"\n", yytext);
			  wyylval.strtype = strdup(yytext);
			  fist_return(PND_ENDIF);
			}
	{FWORD}		{
			  dprintf("%8d: fword \"%s\"\n", yytext);
			  wyylval.strtype = strdup(yytext);
			  fist_return(FWORD);
			}

	/* we set wyyout to copy unmatched text to output file */
}

%%


int
yywrap(void)
{
  return 1;
}


static void
ll_echo(void)
{
  if (print_code)
    fwrite( yytext, yyleng, 1, wyyout );
}


static void
ll_putc(char c)
{
  if (print_code)
    fputc(c, wyyout);
}


static void
ll_puts(const char *s)
{
  if (print_code)
    fputs(s, wyyout);
}


int
wll_input(void)
{
  return input();
}


void
wll_unput(int c)
{
#if 0
  /*
   * As of flex-2.5.31, I cannot call unput directly, because
   * it doesn't find the definition for yytext_ptr; the definition
   * is added to the output file, but after it is used.  Bug.
   * So I just "expanded" the unput macro below. -Erez.
   */
  unput(c);
#else
  yyunput(c, yytext);
#endif
}
