/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.Op;
import edu.ucdavis.jr.jrRuntimeError;
import edu.ucdavis.jr.jrx.InLock;
import edu.ucdavis.jr.jrx.LockId;
import edu.ucdavis.jr.jrx.LockNotHeldError;
import edu.ucdavis.jr.jrx.PLIterator;
import edu.ucdavis.jr.jrx.PNode;
import edu.ucdavis.jr.jrx.PairBoolean;
import edu.ucdavis.jr.jrx.PriorityList;
import edu.ucdavis.jr.jrx.Semaphore;
import edu.ucdavis.jr.jrx.jrvm;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;

public class InLock_impl
extends UnicastRemoteObject
implements InLock {
    private boolean locked;
    private PriorityList waitQ;
    private PriorityList entryQ;
    private PLIterator waitIt;
    private long onQc;
    private long enQc;
    private InLock theLock;
    private boolean switching;
    private long timestamp;
    private PairBoolean offQueue;
    private Thread thrd;
    private LockId myLockId;
    private Hashtable waitingOps;
    private Semaphore mutex;
    private Semaphore forward;
    protected static final long ZONE_OFFSET = Calendar.getInstance().get(15);
    protected static final long DST_OFFSET = Calendar.getInstance().get(16);
    protected static final boolean ISEC = true;
    protected static final boolean ISMES = true;
    protected static final int MESSAGES = 1;
    protected static final int ENTRY = 16;
    protected static final int ECSELECT = 16;
    private static int lockNumber = 0;

    public InLock_impl(String string, boolean bl) throws RemoteException {
        this.locked = bl;
        this.waitQ = new PriorityList();
        this.entryQ = new PriorityList();
        this.onQc = 0L;
        this.enQc = 0L;
        this.switching = false;
        this.theLock = this;
        this.mutex = new Semaphore(1);
        this.myLockId = new LockId(string, InLock_impl.nextLockNumber());
        this.waitingOps = new Hashtable();
        jrvm.registerRemote(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws RemoteException {
        jrvm.ariseAndReceive();
        try {
            this.lock(false);
        }
        finally {
            jrvm.sendAndDie();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockEC() throws RemoteException {
        jrvm.ariseAndReceive();
        try {
            this.lock(true);
        }
        finally {
            jrvm.sendAndDie();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(boolean bl) throws RemoteException {
        boolean bl2;
        long l = System.currentTimeMillis() + ZONE_OFFSET + DST_OFFSET;
        do {
            jrvm.sendAndDie();
            try {
                bl2 = this.theLock.acquireInnerLock(l, bl);
            }
            finally {
                jrvm.ariseAndReceive();
            }
        } while (!bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireInnerLock(long l, boolean bl) throws RemoteException {
        Object object;
        boolean bl2 = false;
        boolean bl3 = false;
        jrvm.ariseAndReceive();
        this.mutex.acquire();
        if (this.theLock != this) {
            this.mutex.release();
            jrvm.sendAndDie();
            return this.theLock.acquireInnerLock(l, bl);
        }
        PairBoolean pairBoolean = new PairBoolean(false, false);
        if (this.locked) {
            this.entryQ.insert(l, Thread.currentThread(), bl, pairBoolean);
            ++this.enQc;
            bl2 = true;
            this.mutex.release();
            object = pairBoolean;
            synchronized (object) {
                jrvm.threadDeath();
                while (!pairBoolean.getFirstValue()) {
                    try {
                        pairBoolean.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.mutex.acquire();
            if (this.switching) {
                --this.enQc;
                if (this.onQc == 0L && this.enQc == 0L) {
                    this.forward.release();
                }
                this.mutex.release();
                jrvm.sendAndDie();
                return false;
            }
        }
        if (bl2 && !this.waitQ.empty() && !bl) {
            this.mutex.release();
            object = pairBoolean;
            synchronized (object) {
                jrvm.threadDeath();
                while (!pairBoolean.getSecondValue()) {
                    try {
                        pairBoolean.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.mutex.acquire();
            if (this.switching) {
                --this.onQc;
                if (this.onQc == 0L && this.enQc == 0L) {
                    this.forward.release();
                }
                this.mutex.release();
                jrvm.sendAndDie();
                return false;
            }
        } else if (!bl) {
            object = this.waitQ.insert(l, Thread.currentThread(), bl, pairBoolean);
            ++this.onQc;
            this.timestamp = l;
            this.offQueue = pairBoolean;
            this.thrd = Thread.currentThread();
            this.waitIt = new PLIterator((PNode)object, this.waitQ);
        }
        this.locked = true;
        this.mutex.release();
        jrvm.sendAndDie();
        return true;
    }

    public boolean lock_or_register(Op op) throws RemoteException {
        return this.theLock.innerLorR(op);
    }

    public boolean innerLorR(Op op) throws RemoteException {
        boolean bl = false;
        this.mutex.acquire();
        if (this.theLock != this) {
            this.mutex.release();
            return this.theLock.lock_or_register(op);
        }
        if (this.locked) {
            this.waitingOps.put(op, op);
            this.mutex.release();
            return false;
        }
        this.locked = true;
        this.mutex.release();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws RemoteException {
        jrvm.ariseAndReceive();
        try {
            this.theLock.releaseInnerLock(false, false);
        }
        finally {
            jrvm.sendAndDie();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockEC() throws RemoteException {
        jrvm.ariseAndReceive();
        try {
            this.theLock.releaseInnerLock(true, false);
        }
        finally {
            jrvm.sendAndDie();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockMes() throws RemoteException {
        this.theLock.releaseInnerLock(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInnerLock(boolean bl, boolean bl2) throws RemoteException {
        int n;
        boolean bl3 = false;
        this.mutex.acquire();
        if (this.theLock != this) {
            this.mutex.release();
            this.theLock.releaseInnerLock(bl, bl2);
            return;
        }
        this.timestamp = -1L;
        this.thrd = null;
        if (!bl && !bl2) {
            if (!this.waitIt.isNull()) {
                this.waitIt.remove();
                --this.onQc;
            } else {
                System.err.println("waitIt is null for some reason -- this probably isn't good");
            }
        }
        if (((n = ((InLock_impl)this.theLock).allowDeliveries(17)) & 0x10) != 0) {
            this.mutex.release();
            return;
        }
        while (!this.waitQ.empty() && !this.waitQ.thread().isAlive()) {
            this.waitQ.removeHead();
            --this.onQc;
        }
        if (this.onQc > 0L) {
            this.timestamp = this.waitQ.headPriority();
            this.offQueue = this.waitQ.getLock();
            this.thrd = this.waitQ.thread();
            this.waitIt = this.waitQ.iterator();
            if (this.offQueue == null) {
                throw new jrRuntimeError("Null lock on queue : 2");
            }
            PairBoolean pairBoolean = this.offQueue;
            synchronized (pairBoolean) {
                jrvm.threadBirth();
                this.offQueue.setSecondValue(true);
                this.offQueue.notify();
            }
        } else {
            this.locked = false;
        }
        this.mutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnLock() throws RemoteException {
        jrvm.ariseAndReceive();
        long l = 0L;
        jrvm.sendAndDie();
        try {
            l = this.theLock.waitInnerLock();
        }
        finally {
            jrvm.ariseAndReceive();
        }
        if (l >= 0L) {
            boolean bl;
            do {
                jrvm.sendAndDie();
                try {
                    bl = this.theLock.acquireInnerLock(l, false);
                }
                finally {
                    jrvm.ariseAndReceive();
                }
            } while (!bl);
        }
        jrvm.sendAndDie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitInnerLock() throws RemoteException {
        jrvm.ariseAndReceive();
        this.mutex.acquire();
        long l = this.timestamp;
        PairBoolean pairBoolean = this.offQueue;
        if (this.theLock != this) {
            this.mutex.release();
            jrvm.sendAndDie();
            return this.theLock.waitInnerLock();
        }
        this.timestamp = -1L;
        this.offQueue = null;
        this.thrd = null;
        this.waitIt.setThread(Thread.currentThread());
        PLIterator pLIterator = this.waitIt.cloneIterator();
        this.waitIt.next();
        while (!this.waitIt.isNull() && !this.waitIt.thread().isAlive()) {
            this.waitIt.remove();
            --this.onQc;
        }
        pairBoolean.setSecondValue(false);
        if (!this.waitIt.isNull()) {
            pLIterator = null;
            this.timestamp = this.waitIt.priority();
            this.offQueue = this.waitIt.getLock();
            this.thrd = this.waitIt.thread();
            if (this.offQueue == null) {
                throw new jrRuntimeError("Null lock on queue : 3");
            }
            PairBoolean pairBoolean2 = this.offQueue;
            synchronized (pairBoolean2) {
                jrvm.threadBirth();
                this.offQueue.setSecondValue(true);
                this.offQueue.notify();
            }
        } else {
            long l2 = this.onQc;
            int n = ((InLock_impl)this.theLock).allowDeliveries(17);
            if ((n & 0x10) != 0) {
                pLIterator = null;
            } else if ((n & 1) != 0 || l2 < this.onQc) {
                this.waitIt = this.waitQ.iterator();
                pLIterator = null;
                this.timestamp = this.waitIt.priority();
                this.offQueue = this.waitIt.getLock();
                this.thrd = this.waitIt.thread();
                if (this.offQueue == null) {
                    throw new jrRuntimeError("Null lock on queue : 1");
                }
                PairBoolean pairBoolean3 = this.offQueue;
                synchronized (pairBoolean3) {
                    jrvm.threadBirth();
                    this.offQueue.setSecondValue(true);
                    this.offQueue.notify();
                }
            } else {
                pLIterator = null;
                this.locked = false;
            }
        }
        this.mutex.release();
        PairBoolean pairBoolean4 = pairBoolean;
        synchronized (pairBoolean4) {
            jrvm.threadDeath();
            while (!pairBoolean.getSecondValue()) {
                try {
                    pairBoolean.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.mutex.acquire();
        if (this.switching) {
            --this.onQc;
            if (this.onQc == 0L && this.enQc == 0L) {
                this.forward.release();
            }
            this.mutex.release();
            jrvm.sendAndDie();
            return l;
        }
        this.mutex.release();
        jrvm.sendAndDie();
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InLock getInnerLock() throws RemoteException {
        this.mutex.acquire();
        try {
            if (this.theLock != this) {
                InLock inLock = this.theLock.getInnerLock();
                return inLock;
            }
            InLock_impl inLock_impl = this;
            return inLock_impl;
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockId getLockId() throws RemoteException {
        this.mutex.acquire();
        try {
            if (this.theLock != this) {
                LockId lockId = this.theLock.getLockId();
                return lockId;
            }
            LockId lockId = this.myLockId;
            return lockId;
        }
        finally {
            this.mutex.release();
        }
    }

    public void forwardTo(InLock inLock) throws RemoteException {
        jrvm.ariseAndReceive();
        boolean bl = false;
        this.mutex.acquire();
        if (this.theLock != this) {
            this.mutex.release();
            jrvm.sendAndDie();
            this.theLock.forwardTo(inLock);
            return;
        }
        if (!this.locked) {
            this.mutex.release();
            jrvm.sendAndDie();
            throw new LockNotHeldError();
        }
        if (this.theLock == inLock) {
            System.err.println("\n\t **** Forwarding to self ****");
            System.err.println("\t  Please report this error. \n");
        }
        ((InLock_impl)this.theLock).allowDeliveries(1);
        if (this.theLock != inLock) {
            this.theLock = inLock.getInnerLock();
            this.myLockId = this.theLock.getLockId();
        }
        this.switching = true;
        PLIterator pLIterator = this.entryQ.iterator();
        while (!pLIterator.isNull()) {
            jrvm.threadBirth();
            pLIterator.releaseFirst();
            pLIterator.next();
        }
        pLIterator = this.waitQ.iterator();
        while (!pLIterator.isNull()) {
            PairBoolean pairBoolean = pLIterator.getLock();
            jrvm.threadBirth();
            pLIterator.releaseSecond();
            pLIterator.next();
        }
        if (this.onQc + this.enQc > 0L) {
            this.forward = new Semaphore(0);
            this.mutex.release();
            this.forward.acquire();
            this.mutex.acquire();
        }
        this.waitQ.clear();
        this.entryQ.clear();
        this.waitQ = null;
        this.entryQ = null;
        this.waitingOps = null;
        jrvm.sendAndDie();
        this.mutex.release();
    }

    public static synchronized int nextLockNumber() {
        return lockNumber++;
    }

    private int allowDeliveries(int n) {
        Enumeration enumeration;
        int n2 = 0;
        if ((n & 1) != 0) {
            enumeration = this.waitingOps.elements();
            if (enumeration.hasMoreElements()) {
                n2 |= 1;
            }
            while (enumeration.hasMoreElements()) {
                try {
                    ((Op)enumeration.nextElement()).deliverPendingMessages();
                }
                catch (Exception exception) {}
            }
            this.waitingOps.clear();
        }
        if ((n & 0x10) != 0) {
            enumeration = this.entryQ.iterator();
            while (!((PLIterator)((Object)enumeration)).isNull()) {
                if (((PLIterator)((Object)enumeration)).isEC()) {
                    n2 |= 0x10;
                    ((PLIterator)((Object)enumeration)).next();
                    continue;
                }
                this.waitQ.insert(((PLIterator)((Object)enumeration)).priority(), ((PLIterator)((Object)enumeration)).thread(), false, ((PLIterator)((Object)enumeration)).getLock());
                ++this.onQc;
                jrvm.threadBirth();
                ((PLIterator)((Object)enumeration)).releaseFirst();
                ((PLIterator)((Object)enumeration)).remove();
                --this.enQc;
            }
            if ((n2 & 0x10) != 0) {
                enumeration = this.entryQ.iterator();
                this.timestamp = ((PLIterator)((Object)enumeration)).priority();
                this.thrd = ((PLIterator)((Object)enumeration)).thread();
                jrvm.threadBirth();
                ((PLIterator)((Object)enumeration)).releaseFirst();
                ((PLIterator)((Object)enumeration)).remove();
                --this.enQc;
            }
        }
        return n2;
    }
}

