/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.BinaryAssignExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.ConvertExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldUpdater;
import edu.ucdavis.jr.trans.sun.tools.tree.IdentifierExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.IntExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public abstract class AssignOpExpression
extends BinaryAssignExpression {
    protected Type itype;
    final int NOINC = Integer.MAX_VALUE;
    protected FieldUpdater updater = null;

    public AssignOpExpression(int n, long l, String string, Expression expression, Expression expression2) {
        super(n, l, string, expression, expression2);
    }

    final void selectType(Environment environment, Context context, int n) {
        Type type = null;
        switch (this.op) {
            case 5: {
                if (this.left.type == Type.tString) {
                    if (this.right.type == Type.tVoid) {
                        environment.error(this.where, "incompatible.type", Constants.opNames[this.op], Type.tVoid, Type.tString);
                        this.type = Type.tError;
                    } else {
                        this.type = this.itype = Type.tString;
                    }
                    return;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if ((n & 0x80) != 0) {
                    this.itype = Type.tDouble;
                    break;
                }
                if ((n & 0x40) != 0) {
                    this.itype = Type.tFloat;
                    break;
                }
                if ((n & 0x20) != 0) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                if ((n & 1) != 0) {
                    this.itype = Type.tBoolean;
                    break;
                }
                if ((n & 0x20) != 0) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                type = Type.tInt;
                if (this.right.type.inMask(62)) {
                    this.right = new ConvertExpression(this.where, this.file, Type.tInt, this.right);
                }
                if (this.left.type == Type.tLong) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            default: {
                throw new CompilerError("Bad assignOp type: " + this.op);
            }
        }
        if (type == null) {
            type = this.itype;
        }
        this.right = this.convert(environment, context, type, this.right);
        this.type = this.left.type;
    }

    int getIncrement() {
        if (this.left.op == 60 && this.type.isType(4) && this.right.op == 65 && (this.op == 5 || this.op == 6) && ((IdentifierExpression)this.left).field.isLocal()) {
            int n = ((IntExpression)this.right).value;
            if (this.op == 6) {
                n = -n;
            }
            if (n == (short)n) {
                return n;
            }
        }
        return Integer.MAX_VALUE;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.left.checkAssignOp(environment, context, vset, hashtable, this);
        vset = this.right.checkValue(environment, context, vset, hashtable);
        int n = this.left.type.getTypeMask() | this.right.type.getTypeMask();
        if ((n & 0x2000) != 0) {
            return vset;
        }
        this.selectType(environment, context, n);
        if (!this.type.isType(13)) {
            this.convert(environment, context, this.itype, this.left);
        }
        this.updater = this.left.getUpdater(environment, context);
        return vset;
    }

    public Expression inlineValue(Environment environment, Context context) {
        this.left = this.left.inlineValue(environment, context);
        this.right = this.right.inlineValue(environment, context);
        if (this.updater != null) {
            this.updater = this.updater.inline(environment, context);
        }
        return this;
    }

    public Expression copyInline(Context context) {
        AssignOpExpression assignOpExpression = (AssignOpExpression)this.clone();
        assignOpExpression.left = this.left.copyInline(context);
        assignOpExpression.right = this.right.copyInline(context);
        if (this.updater != null) {
            assignOpExpression.updater = this.updater.copyInline(context);
        }
        return assignOpExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        if (this.updater == null) {
            return this.getIncrement() != Integer.MAX_VALUE ? 3 : this.right.costInline(n, environment, context) + this.left.costInline(n, environment, context) + 4;
        }
        return this.right.costInline(n, environment, context) + this.updater.costInline(n, environment, context, true) + 1;
    }

    public void print(PrintStream printStream) {
        printStream.print("(" + Constants.opNames[this.op] + " ");
        this.left.print(printStream);
        printStream.print(" ");
        this.right.print(printStream);
        printStream.print(")");
    }

    public void jrPrint(PrintStream printStream) {
        if (!this.noParens) {
            printStream.print("(");
        }
        this.left.jrPrint(printStream);
        printStream.print(" ");
        printStream.print(Constants.opNames[this.op]);
        printStream.print(" ");
        this.right.jrPrint(printStream);
        if (!this.noParens) {
            printStream.print(")");
        }
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        if (debugName) {
            printStream.println("ASSIGNOPEXPRESSION");
        }
        if (!this.noParens) {
            printStream.print("(");
        }
        this.left.jrPrintWhere(printStream, this.left.getWhere());
        printStream.print(" ");
        printStream.print(Constants.opNames[this.op]);
        printStream.print(" ");
        this.right.jrPrintWhere(printStream, this.right.getWhere());
        if (!this.noParens) {
            printStream.print(")");
        }
    }
}

