/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.ConditionVars;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.ExpressionStatement;
import edu.ucdavis.jr.trans.sun.tools.tree.NotExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class IfStatement
extends Statement {
    Expression cond;
    Statement ifTrue;
    Statement ifFalse;

    public IfStatement(long l, String string, Expression expression, Statement statement, Statement statement2) {
        super(90, l, string);
        this.cond = expression;
        this.ifTrue = statement;
        this.ifFalse = statement2;
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        boolean bl = vset.justReplied();
        this.checkLabel(environment, context);
        CheckContext checkContext = new CheckContext(context, this);
        ConditionVars conditionVars = this.cond.checkCondition(environment, checkContext, this.reach(environment, vset), hashtable);
        this.cond = this.convert(environment, checkContext, Type.tBoolean, this.cond);
        Vset vset2 = conditionVars.vsTrue.clearDeadEnd();
        Vset vset3 = conditionVars.vsFalse.clearDeadEnd();
        vset2 = this.ifTrue.check(environment, checkContext, vset2, hashtable);
        if (this.ifFalse != null) {
            vset3 = this.ifFalse.check(environment, checkContext, vset3, hashtable);
        }
        vset = vset2.join(vset3.join(checkContext.vsBreak));
        if (bl) {
            vset.setReplied();
        }
        return context.removeAdditionalVars(vset);
    }

    public Statement inline(Environment environment, Context context) {
        context = new Context(context, this);
        this.cond = this.cond.inlineValue(environment, context);
        if (this.ifTrue != null) {
            this.ifTrue = this.ifTrue.inline(environment, context);
        }
        if (this.ifFalse != null) {
            this.ifFalse = this.ifFalse.inline(environment, context);
        }
        if (this.cond.equals(true)) {
            return this.eliminate(environment, this.ifTrue);
        }
        if (this.cond.equals(false)) {
            return this.eliminate(environment, this.ifFalse);
        }
        if (this.ifTrue == null && this.ifFalse == null) {
            return this.eliminate(environment, new ExpressionStatement(this.where, this.file, this.cond).inline(environment, context));
        }
        if (this.ifTrue == null) {
            this.cond = new NotExpression(this.cond.where, this.cond.file, this.cond).inlineValue(environment, context);
            return this.eliminate(environment, new IfStatement(this.where, this.file, this.cond, this.ifFalse, null));
        }
        return this;
    }

    public Statement copyInline(Context context, boolean bl) {
        IfStatement ifStatement = (IfStatement)this.clone();
        ifStatement.cond = this.cond.copyInline(context);
        if (this.ifTrue != null) {
            ifStatement.ifTrue = this.ifTrue.copyInline(context, bl);
        }
        if (this.ifFalse != null) {
            ifStatement.ifFalse = this.ifFalse.copyInline(context, bl);
        }
        return ifStatement;
    }

    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1 + this.cond.costInline(n, environment, context);
        if (this.ifTrue != null) {
            n2 += this.ifTrue.costInline(n, environment, context);
        }
        if (this.ifFalse != null) {
            n2 += this.ifFalse.costInline(n, environment, context);
        }
        return n2;
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("if ");
        this.cond.print(printStream);
        printStream.print(" ");
        this.ifTrue.print(printStream, n);
        if (this.ifFalse != null) {
            printStream.print(" else ");
            this.ifFalse.print(printStream, n);
        }
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.jrPrint(printStream, n);
        printStream.print("if (");
        this.cond.jrPrintWhere(printStream, this.typeWhere);
        printStream.println(")");
        this.ifTrue.jrPrint(printStream, n);
        printStream.println("");
        if (this.ifFalse != null) {
            printStream.print(" else ");
            this.ifFalse.jrPrint(printStream, n);
            printStream.println("");
        }
    }
}

