/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FieldUpdater;
import edu.ucdavis.jr.trans.sun.tools.tree.LocalMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class ThisExpression
extends Expression {
    LocalMember field;
    Expression implementation;
    Expression outerArg;
    boolean noOuter;

    public ThisExpression(long l, String string) {
        super(82, l, string, Type.tObject);
        this.noOuter = true;
    }

    protected ThisExpression(int n, long l, String string) {
        super(n, l, string, Type.tObject);
        this.noOuter = true;
    }

    public ThisExpression(long l, String string, LocalMember localMember) {
        super(82, l, string, Type.tObject);
        this.field = localMember;
        ++localMember.readcount;
        this.noOuter = true;
    }

    public ThisExpression(long l, String string, Context context) {
        super(82, l, string, Type.tObject);
        this.field = context.getLocalField(Constants.idThis);
        ++this.field.readcount;
        this.noOuter = true;
    }

    public ThisExpression(long l, String string, Expression expression) {
        this(l, string);
        this.outerArg = expression;
        this.noOuter = expression == null;
    }

    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    public Expression getOuterArg() {
        return this.outerArg;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (context.field.isStatic() || context.inniStatic()) {
            environment.error(this.where, "undef.var", Constants.opNames[this.op]);
            this.type = Type.tError;
            return vset;
        }
        if (this.field == null) {
            this.field = context.getLocalField(Constants.idThis);
            ++this.field.readcount;
        }
        if (this.field.scopeNumber < context.frameNumber) {
            this.implementation = context.makeReference(environment, this.field);
        }
        if (!vset.testVar(this.field.number)) {
            environment.error(this.where, "access.inst.before.super", Constants.opNames[this.op]);
        }
        this.type = this.field == null ? context.field.getClassDeclaration().getType() : this.field.getType();
        return vset;
    }

    public boolean isNonNull() {
        return true;
    }

    public FieldUpdater getAssigner(Environment environment, Context context) {
        return null;
    }

    public FieldUpdater getUpdater(Environment environment, Context context) {
        return null;
    }

    public Expression inlineValue(Environment environment, Context context) {
        Expression expression;
        if (this.implementation != null) {
            return this.implementation.inlineValue(environment, context);
        }
        if (this.field != null && this.field.isInlineable(environment, false) && (expression = (Expression)this.field.getValue(environment)) != null) {
            expression = expression.copyInline(context);
            expression.type = this.type;
            return expression;
        }
        return this;
    }

    public Expression copyInline(Context context) {
        if (this.implementation != null) {
            return this.implementation.copyInline(context);
        }
        ThisExpression thisExpression = (ThisExpression)this.clone();
        if (this.field == null) {
            thisExpression.field = context.getLocalField(Constants.idThis);
            ++thisExpression.field.readcount;
        } else {
            thisExpression.field = this.field.getCurrentInlineCopy(context);
        }
        if (this.outerArg != null) {
            thisExpression.outerArg = this.outerArg.copyInline(context);
        }
        return thisExpression;
    }

    public void print(PrintStream printStream) {
        if (this.outerArg != null) {
            printStream.print("(outer=");
            this.outerArg.print(printStream);
            printStream.print(" ");
        }
        String string = this.field == null ? "" : this.field.getClassDefinition().getName().getFlatName().getName() + ".";
        string = string + Constants.opNames[this.op];
        printStream.print(string + "#" + (this.field != null ? this.field.hashCode() : 0));
        if (this.outerArg != null) {
            printStream.print(")");
        }
    }

    public void jrPrint(PrintStream printStream) {
        if (this.outerArg != null && !this.noOuter) {
            this.outerArg.jrPrint(printStream);
            printStream.print(".");
        }
        printStream.print(Constants.opNames[this.op]);
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        if (debugName) {
            printStream.println("THISEXPRESSION");
        }
        if (this.outerArg != null && !this.noOuter) {
            this.outerArg.jrPrintWhere(printStream, this.outerArg.getWhere());
            printStream.print(".");
        }
        printStream.print(Constants.opNames[this.op]);
    }
}

