/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.java;

import edu.ucdavis.jr.trans.sun.tools.java.ArrayType;
import edu.ucdavis.jr.trans.sun.tools.java.CapType;
import edu.ucdavis.jr.trans.sun.tools.java.ClassDeclaration;
import edu.ucdavis.jr.trans.sun.tools.java.ClassType;
import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.IdentifierToken;
import edu.ucdavis.jr.trans.sun.tools.java.MethodType;
import edu.ucdavis.jr.trans.sun.tools.java.OpType;
import edu.ucdavis.jr.trans.sun.tools.java.ResCapType;
import java.util.Arrays;
import java.util.Hashtable;

public class Type
implements Constants {
    private static final Hashtable typeHash = new Hashtable(231);
    protected static Hashtable lexs = new Hashtable();
    protected boolean blockLocal = false;
    protected int typeCode;
    protected String typeSig;
    public static final Type[] noArgs = new Type[0];
    public static final Type tError = new Type(13, "?");
    public static final Type tPackage = new Type(13, ".");
    public static final Type tNull = new Type(8, "*");
    public static final Type tNoop = new Type(18, "@");
    public static final Type tVoid = new Type(11, "V");
    public static final Type tBoolean = new Type(0, "Z");
    public static final Type tByte = new Type(1, "B");
    public static final Type tChar = new Type(2, "C");
    public static final Type tShort = new Type(3, "S");
    public static final Type tInt = new Type(4, "I");
    public static final Type tFloat = new Type(6, "F");
    public static final Type tLong = new Type(5, "J");
    public static final Type tDouble = new Type(7, "D");
    public static final Type tVM = new Type(17, "M");
    public static final Type tObject;
    public static final Type tClassDesc;
    public static final Type tString;
    public static final Type tCloneable;
    public static final Type tSerializable;
    public static final Type tInvocation;
    public static final Type tArmEnumeration;
    public static final Type tInvocationEnumeration;
    public static final Type tJrvm;
    public static final Type tSelectMethod;
    public static final Type tQuiescentCap;
    public static final Type tRegisterQuiescenceActionReal;
    public static final Type tRegisterQuiescenceActionFake;
    public static final Type tjrTimerReal;
    public static final Type tjrTimerFake;
    public static final String JrVMName = "edu.ucdavis.jr.jrx.VM";
    long where;
    String file;

    protected Type(int n, String string) {
        this.typeCode = n;
        this.typeSig = string;
        typeHash.put(string, this);
    }

    public final String getTypeSignature() {
        return this.typeSig;
    }

    public final int getTypeCode() {
        return this.typeCode;
    }

    public final int getTypeMask() {
        return 1 << this.typeCode;
    }

    public final boolean isType(int n) {
        return this.typeCode == n;
    }

    public boolean isVoidArray() {
        if (!this.isType(9)) {
            return false;
        }
        Type type = this;
        while (type.isType(9)) {
            type = type.getElementType();
        }
        return type.isType(11);
    }

    public final boolean inMask(int n) {
        return (1 << this.typeCode & n) != 0;
    }

    public static synchronized Type tArray(Type type) {
        String string = new String("[" + type.getTypeSignature());
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new ArrayType(string, type);
        }
        return type2;
    }

    public Type getElementType() {
        throw new CompilerError("getElementType");
    }

    public Type getBaseElementType() {
        throw new CompilerError("getBaseElementType");
    }

    public int getArrayDimension() {
        return 0;
    }

    public static synchronized Type tClass(Identifier identifier) {
        if (identifier.isInner()) {
            Type type = Type.tClass(Type.mangleInnerType(identifier));
            if (type.getClassName() != identifier) {
                Type.changeClassName(type.getClassName(), identifier);
            }
            return type;
        }
        if (identifier.typeObject != null) {
            return identifier.typeObject;
        }
        String string = new String("L" + identifier.toString().replace('.', '/') + ";");
        Type type = (Type)typeHash.get(string);
        if (type == null) {
            type = new ClassType(string, identifier);
        }
        identifier.typeObject = type;
        return type;
    }

    public Identifier getClassName() {
        throw new CompilerError("getClassName:" + this);
    }

    public static Identifier mangleInnerType(Identifier identifier) {
        if (!identifier.isInner()) {
            return identifier;
        }
        Identifier identifier2 = Identifier.lookup(identifier.getFlatName().toString().replace('.', '$'));
        if (identifier2.isInner()) {
            throw new CompilerError("mangle " + identifier2);
        }
        Identifier identifier3 = Identifier.lookup(identifier.getQualifier(), identifier2);
        identifier3.setLexicalName(identifier.getLexicalName());
        return identifier3;
    }

    static void changeClassName(Identifier identifier, Identifier identifier2) {
        ((ClassType)Type.tClass((Identifier)identifier)).className = identifier2;
    }

    static void changeClassNameR(Identifier identifier, Identifier identifier2) {
        ((ResCapType)Type.tResCap(identifier)).setClassName(identifier2);
    }

    public static synchronized Type tMethod(Type type) {
        return Type.tMethod(type, noArgs);
    }

    public static synchronized Type tMethod(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuffer.append(typeArray[i].getTypeSignature());
        }
        stringBuffer.append(")");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new MethodType(string, type, typeArray);
        }
        return type2;
    }

    public static synchronized Type tOp(Type type, Type[] typeArray, IdentifierToken[] identifierTokenArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("O");
        for (n = 0; n < typeArray.length; ++n) {
            stringBuffer.append(typeArray[n].getTypeSignature());
        }
        stringBuffer.append("+");
        if (identifierTokenArray != null) {
            for (n = 0; n < identifierTokenArray.length; ++n) {
                stringBuffer.append(identifierTokenArray[n]);
            }
        }
        stringBuffer.append(".");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new OpType(string, type, typeArray, identifierTokenArray);
        }
        return type2;
    }

    public static synchronized Type tOp(Type type, Type[] typeArray, IdentifierToken[] identifierTokenArray, ClassDeclaration[] classDeclarationArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("O");
        for (n = 0; n < typeArray.length; ++n) {
            stringBuffer.append(typeArray[n].getTypeSignature());
        }
        stringBuffer.append("+");
        if (classDeclarationArray != null) {
            for (n = 0; n < classDeclarationArray.length; ++n) {
                stringBuffer.append(classDeclarationArray[n].getType().getTypeSignature());
            }
        }
        stringBuffer.append(".");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new OpType(string, type, typeArray, identifierTokenArray, classDeclarationArray);
        }
        return type2;
    }

    public static synchronized Type tCap(Type type, Type[] typeArray, IdentifierToken[] identifierTokenArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("K");
        for (n = 0; n < typeArray.length; ++n) {
            stringBuffer.append(typeArray[n].getTypeSignature());
        }
        stringBuffer.append("+");
        if (identifierTokenArray != null) {
            for (n = 0; n < identifierTokenArray.length; ++n) {
                stringBuffer.append(identifierTokenArray[n]);
            }
        }
        stringBuffer.append("*");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new CapType(string, type, typeArray, identifierTokenArray);
        }
        return type2;
    }

    public static synchronized Type tCap(Type type, Type[] typeArray, IdentifierToken[] identifierTokenArray, ClassDeclaration[] classDeclarationArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("K");
        for (n = 0; n < typeArray.length; ++n) {
            stringBuffer.append(typeArray[n].getTypeSignature());
        }
        stringBuffer.append("+");
        if (classDeclarationArray != null) {
            for (n = 0; n < classDeclarationArray.length; ++n) {
                stringBuffer.append(classDeclarationArray[n].getType());
            }
        }
        stringBuffer.append("*");
        stringBuffer.append(type.getTypeSignature());
        String string = stringBuffer.toString();
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new CapType(string, type, typeArray, identifierTokenArray, classDeclarationArray);
        }
        return type2;
    }

    public static synchronized Type tResCap(Identifier identifier) {
        String string = new String("R" + identifier.toString().replace('.', '/') + ">");
        Type type = (Type)typeHash.get(string);
        if (type == null) {
            type = new ResCapType(string, Type.tClass(identifier));
        }
        return type;
    }

    public static synchronized Type tResCap(Type type) {
        String string = new String("R" + type.getTypeSignature() + ">");
        Type type2 = (Type)typeHash.get(string);
        if (type2 == null) {
            type2 = new ResCapType(string, type);
        }
        return type2;
    }

    public static synchronized Type tVMCap() {
        Type type = (Type)typeHash.get("M");
        if (type == null) {
            type = new Type(17, "M");
        }
        return type;
    }

    public Type getReturnType() {
        throw new CompilerError("getReturnType");
    }

    public Type[] getArgumentTypes() {
        throw new CompilerError("getArgumentTypes");
    }

    public static synchronized Type tType(String string) {
        Type type = (Type)typeHash.get(string);
        if (type != null) {
            return type;
        }
        switch (string.charAt(0)) {
            case '[': {
                return Type.tArray(Type.tType(string.substring(1)));
            }
            case 'L': {
                return Type.tClass(Identifier.lookup(string.substring(1, string.length() - 1).replace('/', '.')));
            }
            case '(': {
                Type[] typeArray;
                Type[] typeArray2 = new Type[8];
                int n = 0;
                int n2 = 1;
                while (string.charAt(n2) != ')') {
                    int n3 = n2;
                    while (string.charAt(n3) == '[') {
                        ++n3;
                    }
                    if (string.charAt(n3++) == 'L') {
                        while (string.charAt(n3++) != ';') {
                        }
                    }
                    if (n == typeArray2.length) {
                        typeArray = new Type[n * 2];
                        System.arraycopy(typeArray2, 0, typeArray, 0, n);
                        typeArray2 = typeArray;
                    }
                    typeArray2[n++] = Type.tType(string.substring(n2, n3));
                    n2 = n3;
                }
                typeArray = new Type[n];
                System.arraycopy(typeArray2, 0, typeArray, 0, n);
                return Type.tMethod(Type.tType(string.substring(n2 + 1)), typeArray);
            }
        }
        throw new CompilerError("invalid TypeSignature:" + string);
    }

    public boolean equalArguments(Type type) {
        return false;
    }

    public boolean equalExceptions(Type type) {
        return false;
    }

    public int stackSize() {
        switch (this.typeCode) {
            case 11: 
            case 13: {
                return 0;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 17: {
                return 1;
            }
            case 5: 
            case 7: {
                return 2;
            }
        }
        throw new CompilerError("stackSize " + this.toString());
    }

    public int getTypeCodeOffset() {
        switch (this.typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
            case 9: 
            case 10: {
                return 4;
            }
        }
        throw new CompilerError("invalid typecode: " + this.typeCode);
    }

    public String typeString(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.typeString(string, bl, bl2);
    }

    public String typeString(String string, boolean bl, boolean bl2) {
        String string2 = null;
        switch (this.typeCode) {
            case 8: {
                string2 = "null";
                break;
            }
            case 18: {
                string2 = "noop";
                break;
            }
            case 11: {
                string2 = "void";
                break;
            }
            case 0: {
                string2 = "boolean";
                break;
            }
            case 1: {
                string2 = "byte";
                break;
            }
            case 2: {
                string2 = "char";
                break;
            }
            case 3: {
                string2 = "short";
                break;
            }
            case 4: {
                string2 = "int";
                break;
            }
            case 5: {
                string2 = "long";
                break;
            }
            case 6: {
                string2 = "float";
                break;
            }
            case 7: {
                string2 = "double";
                break;
            }
            case 17: {
                string2 = "vm";
                break;
            }
            case 13: {
                string2 = "<error>";
                if (this != tPackage) break;
                string2 = "<package>";
                break;
            }
            default: {
                string2 = "unknown";
            }
        }
        return string.length() > 0 ? string2 + " " + string : string2;
    }

    public String jrTypeString(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.jrTypeString(string, bl, bl2);
    }

    public String jrTypeString(String string, boolean bl, boolean bl2) {
        if (this.typeCode == 17) {
            return string.length() > 0 ? "edu.ucdavis.jr.jrx.VM " + string : JrVMName;
        }
        return this.typeString(string, bl, bl2);
    }

    public String jrTypeString(String string, boolean bl, boolean bl2, long l, String string2, boolean bl3) {
        return this.jrTypeString(string, bl, bl2, l, string2);
    }

    public String jrTypeString(String string, boolean bl, boolean bl2, long l, String string2) {
        return this.jrTypeString(string, bl, bl2);
    }

    public String jrRealTypeString(String string, boolean bl, boolean bl2) {
        return this.jrTypeString(string, bl, bl2);
    }

    public String jrSafeTypeString(String string, boolean bl, boolean bl2) {
        return Type.jrName(this.jrTypeString(string, bl, bl2));
    }

    public String typeString(String string) {
        return this.typeString(string, false, true);
    }

    public String toString() {
        return this.typeString("", false, true);
    }

    public String toString(boolean bl) {
        return this.typeString("", false, true, bl);
    }

    public String jrToString() {
        return this.typeString("", false, true);
    }

    public static void setLexicalName(String string, long l, String string2) {
        if (string == null) {
            return;
        }
        lexs.put(string2 + l, string);
    }

    public void setLexicalName(String string) {
    }

    public String getLexicalName() {
        return "<lexicalName not set>";
    }

    public static String getLexicalName(long l, String string) {
        String string2 = (String)lexs.get(string + l);
        if (string2 == null) {
            string2 = "<--<lexicalName not set>-->";
        }
        return string2;
    }

    public void setWhere(long l) {
        this.where = l;
    }

    public long getWhere() {
        return this.where;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getFile() {
        return this.file;
    }

    public static String jrName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    continue block8;
                }
                case '[': {
                    stringBuffer.append("bkt");
                    continue block8;
                }
                case ']': {
                    continue block8;
                }
                case '.': {
                    stringBuffer.append("dot");
                    continue block8;
                }
                case 'b': {
                    if (i + 2 < n && string.charAt(i + 1) == 'k' && string.charAt(i + 2) == 't') {
                        stringBuffer.append("JRbkt");
                        i += 2;
                        continue block8;
                    }
                    stringBuffer.append('b');
                    continue block8;
                }
                case 'd': {
                    if (i + 2 < n && string.charAt(i + 1) == 'o' && string.charAt(i + 2) == 't') {
                        stringBuffer.append("JRdot");
                        i += 2;
                        continue block8;
                    }
                    stringBuffer.append('d');
                    continue block8;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public void setBlockLocal() {
        this.blockLocal = true;
    }

    public boolean isBlockLocal() {
        return this.blockLocal;
    }

    protected static ClassDeclaration[] sortAndEliminateDuplicates(ClassDeclaration[] classDeclarationArray) {
        if (classDeclarationArray == null || classDeclarationArray.length == 0) {
            return classDeclarationArray;
        }
        Arrays.sort(classDeclarationArray, ClassDeclaration.CDECL_NAME_COMPARATOR);
        String string = classDeclarationArray[0].getName().toString();
        int n = 0;
        for (int i = 1; i < classDeclarationArray.length; ++i) {
            String string2 = classDeclarationArray[i].getName().toString();
            if (string.equals(string2)) {
                ++n;
                classDeclarationArray[i] = null;
                continue;
            }
            string = classDeclarationArray[i].getName().toString();
        }
        if (classDeclarationArray.length == classDeclarationArray.length - n) {
            return classDeclarationArray;
        }
        ClassDeclaration[] classDeclarationArray2 = new ClassDeclaration[classDeclarationArray.length - n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < classDeclarationArray2.length && n3 + n2 < classDeclarationArray.length) {
            if (classDeclarationArray[n3 + n2] != null) {
                classDeclarationArray2[n3] = classDeclarationArray[n3 + n2];
                ++n3;
                continue;
            }
            ++n2;
        }
        return classDeclarationArray2;
    }

    public ClassDeclaration[] getResolvedExceptions() {
        throw new CompilerError("getResolvedExceptions");
    }

    static {
        tVoid.setLexicalName("void");
        tBoolean.setLexicalName("boolean");
        tByte.setLexicalName("byte");
        tChar.setLexicalName("char");
        tShort.setLexicalName("short");
        tInt.setLexicalName("int");
        tFloat.setLexicalName("float");
        tLong.setLexicalName("long");
        tDouble.setLexicalName("double");
        tVM.setLexicalName("vm");
        tObject = Type.tClass(Constants.idJavaLangObject);
        tClassDesc = Type.tClass(Constants.idJavaLangClass);
        tString = Type.tClass(Constants.idJavaLangString);
        tCloneable = Type.tClass(Constants.idJavaLangCloneable);
        tSerializable = Type.tClass(Constants.idJavaIoSerializable);
        tInvocation = Type.tClass(Constants.idEduUcdavisJrInvocation);
        tArmEnumeration = Type.tClass(Constants.idEduUcdavisJrArmEnumeration);
        tInvocationEnumeration = Type.tClass(Constants.idEduUcdavisJrInvocationEnumeration);
        tJrvm = Type.tClass(Constants.idEduUcdavisJrJrxJrvm);
        tSelectMethod = Type.tMethod(tInvocation, new Type[]{tArmEnumeration});
        tQuiescentCap = Type.tClass(Constants.idEduUcdavisJrQuiescentCap);
        tRegisterQuiescenceActionReal = Type.tMethod(tVoid, new Type[]{tQuiescentCap});
        tRegisterQuiescenceActionFake = Type.tMethod(tVoid, new Type[]{Type.tCap(tVoid, new Type[0], null)});
        tjrTimerReal = Type.tMethod(tVoid, new Type[]{tInt, tQuiescentCap});
        tjrTimerFake = Type.tMethod(tVoid, new Type[]{tInt, Type.tCap(tVoid, new Type[0], null)});
    }
}

