/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.ArrayType;
import edu.ucdavis.jr.trans.sun.tools.java.CapType;
import edu.ucdavis.jr.trans.sun.tools.java.ClassFile;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Identifier;
import edu.ucdavis.jr.trans.sun.tools.java.IdentifierToken;
import edu.ucdavis.jr.trans.sun.tools.java.ResCapType;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.javac.recvGenClass;
import edu.ucdavis.jr.trans.sun.tools.tree.CheckContext;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.IdentifierExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.LocalMember;
import edu.ucdavis.jr.trans.sun.tools.tree.Statement;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AsStatement
extends Statement {
    Type[] atypes;
    Type type;
    IdentifierToken[] anames;
    Statement body;
    Vector myargs;
    Vector argTypeNames;
    String theRecvStr = "";

    public AsStatement(long l, String string, Type[] typeArray, IdentifierToken[] identifierTokenArray, Statement statement) {
        super(186, l, string);
        this.atypes = typeArray == null ? new Type[]{} : typeArray;
        this.anames = identifierTokenArray == null ? new IdentifierToken[]{} : identifierTokenArray;
        this.body = statement;
        this.type = Type.tMethod(Type.tVoid, this.atypes);
        this.myargs = new Vector();
        for (int i = 0; i < this.anames.length; ++i) {
            this.myargs.addElement(this.anames[i]);
        }
    }

    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.reach(environment, vset);
        CheckContext checkContext = new CheckContext(context, this);
        Environment environment2 = Context.newEnvironment(environment, checkContext);
        this.type = environment2.resolveNames(checkContext.field.getClassDefinition(), this.type, false);
        environment2.resolve(this.where, checkContext.field.getClassDefinition(), this.type);
        this.createArgumentFields(environment2, checkContext, this.myargs);
        this.createRecvStr();
        this.generateRecvClass(environment);
        Enumeration enumeration = this.myargs.elements();
        while (enumeration.hasMoreElements()) {
            IdentifierExpression identifierExpression = (IdentifierExpression)enumeration.nextElement();
            if (checkContext.getLocalField(identifierExpression.field.getName()) != null) {
                environment.error(this.where, "local.redefined", identifierExpression.field.getName());
            }
            int n = checkContext.declare(environment2, (LocalMember)identifierExpression.field);
            vset.addVarUnassigned(((LocalMember)identifierExpression.field).number);
            vset = identifierExpression.checkLHSReceive(environment2, checkContext, vset, hashtable);
        }
        if (this.body != null) {
            vset = this.body.checkBlockStatement(environment2, checkContext, vset, hashtable);
        }
        return context.removeAdditionalVars(vset);
    }

    private void generateRecvClass(Environment environment) {
        if (this.argTypeNames == null) {
            this.createArgTypeNames();
        }
        ClassFile classFile = environment.getUpperSource();
        recvGenClass recvGenClass2 = new recvGenClass(this.theRecvStr, this.argTypeNames);
        recvGenClass2.addSource(classFile);
        environment.addJrClass(recvGenClass2.getKey(), recvGenClass2);
    }

    protected void createArgumentFields(Environment environment, Context context, Vector vector) {
        this.myargs = new Vector();
        if (vector != null) {
            Hashtable<Identifier, Identifier> hashtable = new Hashtable<Identifier, Identifier>();
            Enumeration enumeration = vector.elements();
            Type[] typeArray = this.type.getArgumentTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                Object e = enumeration.nextElement();
                if (e instanceof IdentifierExpression) {
                    this.myargs = vector;
                    return;
                }
                IdentifierToken identifierToken = (IdentifierToken)e;
                Identifier identifier = identifierToken.getName();
                int n = identifierToken.getModifiers();
                long l = identifierToken.getWhere();
                if (hashtable.get(identifier) != null) {
                    environment.error(l, "duplicate.argument.as", identifier);
                }
                hashtable.put(identifier, identifier);
                this.myargs.addElement(new IdentifierExpression(l, new LocalMember(l, this.file, context.field.getClassDefinition(), n, typeArray[i], identifier)));
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    private void createRecvStr() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.argTypeNames == null) {
            this.createArgTypeNames();
        }
        Type[] typeArray = this.atypes;
        if (this.argTypeNames == null) {
            stringBuffer.append("void");
        } else {
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('X');
                }
                if (typeArray[i].isType(15)) {
                    stringBuffer.append((String)this.argTypeNames.elementAt(i));
                    continue;
                }
                stringBuffer.append(Type.jrName((String)this.argTypeNames.elementAt(i)));
            }
        }
        this.theRecvStr = "Recv_" + stringBuffer.toString();
    }

    private void createArgTypeNames() {
        if (this.argTypeNames != null) {
            return;
        }
        Type[] typeArray = this.atypes;
        if (typeArray == null || typeArray.length == 0) {
            return;
        }
        this.argTypeNames = new Vector();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].isType(15)) {
                this.argTypeNames.addElement("Cap_" + ((CapType)typeArray[i]).getJrCapSig());
                continue;
            }
            if (typeArray[i].isType(9) && ((ArrayType)typeArray[i]).getBaseElementType().isType(15)) {
                this.argTypeNames.addElement(typeArray[i].jrTypeString("", false, true));
                continue;
            }
            if (typeArray[i].isType(9) && ((ArrayType)typeArray[i]).getBaseElementType().isType(16)) {
                this.argTypeNames.addElement(typeArray[i].jrTypeString("", false, true));
                continue;
            }
            if (typeArray[i].isType(16)) {
                this.argTypeNames.addElement(((ResCapType)typeArray[i]).jrCapString(""));
                continue;
            }
            this.argTypeNames.addElement(typeArray[i].typeString("", false, true));
        }
    }

    public void print(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.print("ASSTATEMENT");
    }

    public void jrPrint(PrintStream printStream, int n) {
        super.print(printStream, n);
        printStream.println(this.theRecvStr + ")");
        this.printIndent(printStream, n);
        printStream.println("{");
        if (this.atypes.length > 0) {
            this.printIndent(printStream, n + 1);
            printStream.println(this.theRecvStr + " " + "JR" + "tmprecv = (" + this.theRecvStr + ")" + "JR" + "tmpinvoc;");
        }
        for (int i = 0; i < this.atypes.length; ++i) {
            this.printIndent(printStream, n + 1);
            if (this.atypes[i] != null && this.anames[i] != null) {
                printStream.print(this.atypes[i].jrTypeString("", false, true, this.anames[i].getWhere(), this.file) + " ");
                if (this.atypes[i].isType(15)) {
                    printStream.print(((CapType)this.atypes[i]).getJrCapName(this.anames[i].toString()));
                } else {
                    printStream.print(this.anames[i]);
                }
                printStream.print(" = ");
                if (this.atypes[i].isType(15)) {
                    AsStatement.printCapConversion(this.atypes[i], this.atypes[i], "JRtmprecv.arg" + i, printStream, false);
                } else {
                    printStream.print("JRtmprecv.arg" + i);
                }
                printStream.println(";");
                continue;
            }
            printStream.print("<null>");
        }
        if (this.body != null) {
            this.printIndent(printStream, n + 1);
            this.body.jrPrint(printStream, n + 1);
            printStream.println();
        }
        this.printIndent(printStream, n);
        printStream.println("}");
    }
}

