/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.BooleanExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.CommaExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.DoubleExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FloatExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.IntegerExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.LongExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.StringExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.UnaryExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class BinaryExpression
extends UnaryExpression {
    Expression left;

    BinaryExpression(int n, long l, String string, Type type, Expression expression, Expression expression2) {
        super(n, l, string, type, expression2);
        this.left = expression;
    }

    public Expression order() {
        if (this.precedence() > this.left.precedence()) {
            UnaryExpression unaryExpression = (UnaryExpression)this.left;
            this.left = unaryExpression.right;
            unaryExpression.right = this.order();
            return unaryExpression;
        }
        return this;
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.left.checkValue(environment, context, vset, hashtable);
        vset = this.right.checkValue(environment, context, vset, hashtable);
        int n = this.left.type.getTypeMask() | this.right.type.getTypeMask();
        if ((n & 0x2000) != 0) {
            return vset;
        }
        this.selectType(environment, context, n);
        if (this.type.isType(13)) {
            environment.error(this.where, "invalid.args", Constants.opNames[this.op]);
        }
        return vset;
    }

    public boolean isConstant() {
        switch (this.op) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.left.isConstant() && this.right.isConstant();
            }
        }
        return false;
    }

    Expression eval(int n, int n2) {
        return this;
    }

    Expression eval(long l, long l2) {
        return this;
    }

    Expression eval(float f, float f2) {
        return this;
    }

    Expression eval(double d, double d2) {
        return this;
    }

    Expression eval(boolean bl, boolean bl2) {
        return this;
    }

    Expression eval(String string, String string2) {
        return this;
    }

    Expression eval() {
        if (this.left.op == this.right.op) {
            switch (this.left.op) {
                case 62: 
                case 63: 
                case 64: 
                case 65: {
                    return this.eval(((IntegerExpression)this.left).value, ((IntegerExpression)this.right).value);
                }
                case 66: {
                    return this.eval(((LongExpression)this.left).value, ((LongExpression)this.right).value);
                }
                case 67: {
                    return this.eval(((FloatExpression)this.left).value, ((FloatExpression)this.right).value);
                }
                case 68: {
                    return this.eval(((DoubleExpression)this.left).value, ((DoubleExpression)this.right).value);
                }
                case 61: {
                    return this.eval(((BooleanExpression)this.left).value, ((BooleanExpression)this.right).value);
                }
                case 69: {
                    return this.eval(((StringExpression)this.left).value, ((StringExpression)this.right).value);
                }
            }
        }
        return this;
    }

    public Expression inline(Environment environment, Context context) {
        this.left = this.left.inline(environment, context);
        this.right = this.right.inline(environment, context);
        return this.left == null ? this.right : new CommaExpression(this.where, this.file, this.left, this.right);
    }

    public Expression inlineValue(Environment environment, Context context) {
        this.left = this.left.inlineValue(environment, context);
        this.right = this.right.inlineValue(environment, context);
        try {
            return this.eval().simplify();
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    public Expression copyInline(Context context) {
        BinaryExpression binaryExpression = (BinaryExpression)this.clone();
        if (this.left != null) {
            binaryExpression.left = this.left.copyInline(context);
        }
        if (this.right != null) {
            binaryExpression.right = this.right.copyInline(context);
        }
        return binaryExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1 + (this.left != null ? this.left.costInline(n, environment, context) : 0) + (this.right != null ? this.right.costInline(n, environment, context) : 0);
    }

    public Expression getLeft() {
        return this.left;
    }

    public void print(PrintStream printStream) {
        printStream.print("(" + Constants.opNames[this.op] + " ");
        if (this.left != null) {
            this.left.print(printStream);
        } else {
            printStream.print("<null>");
        }
        printStream.print(" ");
        if (this.right != null) {
            this.right.print(printStream);
        } else {
            printStream.print("<null>");
        }
        printStream.print(")");
    }

    public void jrPrint(PrintStream printStream) {
        if (!this.noParens) {
            printStream.print("(");
        }
        if (this.left != null) {
            this.left.jrPrint(printStream);
        } else {
            printStream.print("<null>");
        }
        printStream.print(" " + Constants.opNames[this.op] + " ");
        if (this.right != null) {
            this.right.jrPrint(printStream);
        } else {
            printStream.print("<null>");
        }
        if (!this.noParens) {
            printStream.print(")");
        }
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        if (debugName) {
            printStream.println("BINARYEQUALITYEXPRESSION");
        }
        if (!this.noParens) {
            printStream.print("(");
        }
        if (this.left != null) {
            this.left.jrPrintWhere(printStream, this.left.getWhere());
        } else {
            printStream.print("<null>");
        }
        printStream.print(" " + Constants.opNames[this.op] + " ");
        if (this.right != null) {
            this.right.jrPrintWhere(printStream, this.right.getWhere());
        } else {
            printStream.print("<null>");
        }
        if (!this.noParens) {
            printStream.print(")");
        }
    }
}

