/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.tree;

import edu.ucdavis.jr.trans.sun.tools.java.CompilerError;
import edu.ucdavis.jr.trans.sun.tools.java.Constants;
import edu.ucdavis.jr.trans.sun.tools.java.Environment;
import edu.ucdavis.jr.trans.sun.tools.java.Type;
import edu.ucdavis.jr.trans.sun.tools.tree.BooleanExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Context;
import edu.ucdavis.jr.trans.sun.tools.tree.DoubleExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Expression;
import edu.ucdavis.jr.trans.sun.tools.tree.FloatExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.IntegerExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.LongExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.StringExpression;
import edu.ucdavis.jr.trans.sun.tools.tree.Vset;
import java.io.PrintStream;
import java.util.Hashtable;

public class UnaryExpression
extends Expression {
    Expression right;

    UnaryExpression(int n, long l, String string, Type type, Expression expression) {
        super(n, l, string, type);
        this.right = expression;
    }

    public Expression order() {
        if (this.precedence() > this.right.precedence()) {
            UnaryExpression unaryExpression = (UnaryExpression)this.right;
            this.right = unaryExpression.right;
            unaryExpression.right = this.order();
            return unaryExpression;
        }
        return this;
    }

    void selectType(Environment environment, Context context, int n) {
        throw new CompilerError("selectType: " + Constants.opNames[this.op]);
    }

    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.right.checkValue(environment, context, vset, hashtable);
        int n = this.right.type.getTypeMask();
        this.selectType(environment, context, n);
        if ((n & 0x2000) == 0 && this.type.isType(13)) {
            environment.error(this.where, "invalid.arg", Constants.opNames[this.op]);
        }
        return vset;
    }

    public boolean isConstant() {
        switch (this.op) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 55: 
            case 56: {
                return this.right.isConstant();
            }
        }
        return false;
    }

    Expression eval(int n) {
        return this;
    }

    Expression eval(long l) {
        return this;
    }

    Expression eval(float f) {
        return this;
    }

    Expression eval(double d) {
        return this;
    }

    Expression eval(boolean bl) {
        return this;
    }

    Expression eval(String string) {
        return this;
    }

    Expression eval() {
        switch (this.right.op) {
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return this.eval(((IntegerExpression)this.right).value);
            }
            case 66: {
                return this.eval(((LongExpression)this.right).value);
            }
            case 67: {
                return this.eval(((FloatExpression)this.right).value);
            }
            case 68: {
                return this.eval(((DoubleExpression)this.right).value);
            }
            case 61: {
                return this.eval(((BooleanExpression)this.right).value);
            }
            case 69: {
                return this.eval(((StringExpression)this.right).value);
            }
        }
        return this;
    }

    public Expression inline(Environment environment, Context context) {
        return this.right.inline(environment, context);
    }

    public Expression inlineValue(Environment environment, Context context) {
        this.right = this.right.inlineValue(environment, context);
        try {
            return this.eval().simplify();
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    public Expression copyInline(Context context) {
        UnaryExpression unaryExpression = (UnaryExpression)this.clone();
        if (this.right != null) {
            unaryExpression.right = this.right.copyInline(context);
        }
        return unaryExpression;
    }

    public int costInline(int n, Environment environment, Context context) {
        return 1 + this.right.costInline(n, environment, context);
    }

    public void print(PrintStream printStream) {
        printStream.print("(" + Constants.opNames[this.op] + " ");
        this.right.print(printStream);
        printStream.print(")");
    }

    public void jrPrint(PrintStream printStream) {
        switch (this.op) {
            case 56: {
                this.right.jrPrint(printStream);
                break;
            }
            case 44: 
            case 45: {
                if (!this.noParens) {
                    printStream.print("(");
                }
                this.right.jrPrint(printStream);
                printStream.print(Constants.opNames[this.op]);
                if (this.noParens) break;
                printStream.print(")");
                break;
            }
            default: {
                if (!this.noParens) {
                    printStream.print("(");
                }
                printStream.print(Constants.opNames[this.op]);
                this.right.jrPrint(printStream);
                if (this.noParens) break;
                printStream.print(")");
            }
        }
    }

    public void jrPrintWhere(PrintStream printStream, long l) {
        if (debugName) {
            printStream.println("UNARYEXPRESSION");
        }
        switch (this.op) {
            case 56: {
                this.right.jrPrintWhere(printStream, this.right.getWhere());
                break;
            }
            case 44: 
            case 45: {
                if (!this.noParens) {
                    printStream.print("(");
                }
                this.right.jrPrintWhere(printStream, this.right.getWhere());
                printStream.print(Constants.opNames[this.op]);
                if (this.noParens) break;
                printStream.print(")");
                break;
            }
            default: {
                if (!this.noParens) {
                    printStream.print("(");
                }
                printStream.print(Constants.opNames[this.op]);
                this.right.jrPrintWhere(printStream, this.right.getWhere());
                if (this.noParens) break;
                printStream.print(")");
            }
        }
    }

    public boolean validInArm(boolean bl) {
        if (this.right == null) {
            return true;
        }
        return this.right.validInArm(false);
    }

    public long getWhereArmInvalid(boolean bl) {
        if (this.right == null) {
            return 0L;
        }
        return this.right.getWhereArmInvalid(false);
    }

    public Expression getRight() {
        return this.right;
    }
}

