/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class FileEntry {
    private static final int UNDET = -2;
    private long lastmod = -2L;

    public abstract InputStream open() throws IOException;

    public abstract String getName();

    public abstract String getPath();

    public abstract long length();

    public String toString() {
        return this.getName();
    }

    abstract long lastMod();

    public long lastModified() {
        if (this.lastmod == -2L) {
            this.lastmod = this.lastMod();
        }
        return this.lastmod;
    }

    public static class Zipped
    extends FileEntry {
        private String name;
        ZipFile zdir;
        ZipEntry entry;

        public Zipped(String string, ZipFile zipFile, ZipEntry zipEntry) {
            this.name = string;
            this.zdir = zipFile;
            this.entry = zipEntry;
        }

        public InputStream open() throws IOException {
            return this.zdir.getInputStream(this.entry);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.zdir.getName() + "(" + this.entry + ")";
        }

        public long length() {
            return this.entry.getSize();
        }

        long lastMod() {
            return this.entry.getTime();
        }
    }

    public static class Regular
    extends FileEntry {
        private String name;
        File f;

        public Regular(String string, File file) {
            this.name = string;
            this.f = file;
        }

        public InputStream open() throws IOException {
            return new FileInputStream(this.f);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.f.getPath();
        }

        public long length() {
            return this.f.length();
        }

        long lastMod() {
            return this.f.lastModified();
        }
    }
}

