/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.jrx;

import edu.ucdavis.jr.InOpIterator;
import edu.ucdavis.jr.LocalInvocation;
import edu.ucdavis.jr.jrCommunicationException;
import edu.ucdavis.jr.jrRuntimeError;
import edu.ucdavis.jr.jrx.CLock;
import edu.ucdavis.jr.jrx.InLock;
import edu.ucdavis.jr.jrx.InLock_impl;
import edu.ucdavis.jr.jrx.QuantRec;
import edu.ucdavis.jr.jrx.Sorter;
import edu.ucdavis.jr.jrx.TimeNode;
import edu.ucdavis.jr.jrx.jrvm;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class InStatObj {
    public boolean serviced;
    public boolean byStrt;
    public double byVal;
    public double curVal;
    public int curInvoc;
    public int i;
    public int j;
    public int N;
    public QuantRec[] armArray;
    public TimeNode[] timesArray;
    public InOpIterator iter;
    public LocalInvocation JRinit;
    private ArrayList<QuantRec> listDueToQuants;
    private QuantRec[] oldArmArray;
    private CLock[] lockArray;
    private CLock masterLock;
    private boolean ecFormed;
    private boolean hasCap;
    private boolean quantified;
    private boolean cleared;
    private static TimesCompare sortFunc = new TimesCompare();

    public InStatObj(boolean bl) {
        this.initializeCommon(bl);
        this.armArray = new QuantRec[0];
        this.quantified = true;
        this.listDueToQuants = new ArrayList();
    }

    public InStatObj(int n, boolean bl) {
        this.initializeCommon(bl);
        this.N = n;
        this.armArray = new QuantRec[n];
        this.oldArmArray = new QuantRec[n];
        this.timesArray = new TimeNode[n];
        this.lockArray = new CLock[n];
        this.quantified = false;
    }

    private void initializeCommon(boolean bl) {
        this.i = 0;
        this.j = 0;
        this.serviced = false;
        this.ecFormed = false;
        this.masterLock = null;
        this.JRinit = new LocalInvocation();
        this.hasCap = true;
        this.cleared = false;
    }

    private void toArray() {
        int n;
        this.armArray = this.listDueToQuants.toArray(this.armArray);
        for (n = 0; n < this.armArray.length; ++n) {
            this.armArray[n].armArrayIndex = n;
        }
        this.N = n = this.armArray.length;
        this.timesArray = new TimeNode[n];
        this.lockArray = new CLock[n];
    }

    public void add(QuantRec quantRec) {
        this.listDueToQuants.add(quantRec);
    }

    public void clear() {
        this.cleared = true;
        this.listDueToQuants.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        try {
            if (this.cleared) {
                this.cleared = false;
                this.toArray();
            }
            boolean bl = false;
            if (!this.ecFormed || (this.hasCap || this.quantified) && this.capChanged()) {
                int n;
                this.masterLock = null;
                jrvm.sendAndDie();
                try {
                    jrvm.jrx.lockEC();
                }
                finally {
                    jrvm.ariseAndReceive();
                }
                for (n = 0; n < this.N; ++n) {
                    this.lockArray[n] = new CLock(this.armArray[n].theCap.getLock());
                    if (!this.armArray[n].theCap.isRemote(jrvm.thisVM.getName())) continue;
                    bl = true;
                }
                CLock.markDuplicates(this.lockArray);
                try {
                    for (n = 0; n < this.N; ++n) {
                        if (this.lockArray[n].duplicate) continue;
                        jrvm.sendAndDie();
                        try {
                            this.lockArray[n].lockEC();
                        }
                        finally {
                            jrvm.ariseAndReceive();
                        }
                        if (this.lockArray[n].isRemoteLock && (this.masterLock == null || !this.masterLock.isRemoteLock || this.lockArray[n].numDupes > this.masterLock.numDupes)) {
                            this.masterLock = this.lockArray[n];
                            continue;
                        }
                        if (this.lockArray[n].isRemoteLock || this.masterLock != null && (this.masterLock.isRemoteLock || this.lockArray[n].numDupes <= this.masterLock.numDupes)) continue;
                        this.masterLock = this.lockArray[n];
                    }
                    if (bl) {
                        if (this.masterLock == null || !this.masterLock.isRemoteLock) {
                            this.masterLock = new CLock(jrvm.jrx.createRemoteLock());
                        }
                    } else if (this.masterLock == null) {
                        this.masterLock = new CLock(InStatObj.createLocalLock());
                    }
                    for (n = 0; n < this.N; ++n) {
                        if (this.lockArray[n].isDupeOf(this.masterLock) || this.lockArray[n].duplicate) continue;
                        jrvm.sendAndDie();
                        try {
                            this.lockArray[n].forwardTo(this.masterLock.getLock());
                            continue;
                        }
                        finally {
                            jrvm.ariseAndReceive();
                        }
                    }
                    this.equivClassFormed();
                    jrvm.sendAndDie();
                    try {
                        this.masterLock.unlockEC();
                    }
                    finally {
                        jrvm.ariseAndReceive();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new jrRuntimeError("error constructing equivalence class");
                }
                jrvm.sendAndDie();
                try {
                    jrvm.jrx.unlockEC();
                }
                finally {
                    jrvm.ariseAndReceive();
                }
            }
            jrvm.sendAndDie();
            try {
                this.masterLock.lock();
            }
            finally {
                jrvm.ariseAndReceive();
            }
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    public void unlock() {
        jrvm.sendAndDie();
        try {
            this.masterLock.unlock();
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
        finally {
            jrvm.ariseAndReceive();
        }
    }

    public void waitOnLock() {
        jrvm.sendAndDie();
        try {
            this.masterLock.waitOnLock();
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
        finally {
            jrvm.ariseAndReceive();
        }
    }

    public void gatherAndSortTimes() {
        if (this.cleared) {
            this.cleared = false;
            this.toArray();
        }
        for (int i = 0; i < this.N; ++i) {
            this.timesArray[i] = new TimeNode(this.armArray[i].opNum, this.armArray[i].theCap.getFirstTime(), this.armArray[i].armArrayIndex);
        }
        Sorter.sort(this.timesArray, 0, this.N - 1, sortFunc);
    }

    private void equivClassFormed() {
        this.ecFormed = true;
        if (this.hasCap) {
            if (this.oldArmArray != null && this.oldArmArray.length == this.armArray.length) {
                System.arraycopy(this.armArray, 0, this.oldArmArray, 0, this.N);
            } else {
                this.oldArmArray = (QuantRec[])this.armArray.clone();
            }
        }
    }

    private boolean capChanged() {
        if (this.oldArmArray == null || this.oldArmArray.length != this.armArray.length) {
            return true;
        }
        for (int i = 0; i < this.armArray.length; ++i) {
            if (!this.armArray[i].equals(this.oldArmArray[i])) {
                return true;
            }
            Object object = this.armArray[i].theCap.getOp();
            Object object2 = this.oldArmArray[i].theCap.getOp();
            if (!(object2 == null && object != null || object2 != null && object == null) && (object2 == null || object == null || object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    private static InLock createLocalLock() {
        try {
            return new InLock_impl(jrvm.thisVM.getName(), true);
        }
        catch (RemoteException remoteException) {
            throw new jrCommunicationException(remoteException);
        }
    }

    public void releaseIter() {
        if (this.iter != null) {
            this.iter.unregister();
        }
    }

    static class TimesCompare
    extends Sorter.SortCompare {
        TimesCompare() {
        }

        public boolean precede(Object object, Object object2) {
            return ((TimeNode)object).time < ((TimeNode)object2).time;
        }
    }
}

