/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.parser;

import edu.ucdavis.jr.trans.sun.tools.javac.code.BoundKind;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Flags;
import edu.ucdavis.jr.trans.sun.tools.javac.code.Source;
import edu.ucdavis.jr.trans.sun.tools.javac.parser.Keywords;
import edu.ucdavis.jr.trans.sun.tools.javac.parser.Scanner;
import edu.ucdavis.jr.trans.sun.tools.javac.parser.Tokens;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.Tree;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.TreeInfo;
import edu.ucdavis.jr.trans.sun.tools.javac.tree.TreeMaker;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Context;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Convert;
import edu.ucdavis.jr.trans.sun.tools.javac.util.List;
import edu.ucdavis.jr.trans.sun.tools.javac.util.ListBuffer;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Log;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Name;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Options;
import edu.ucdavis.jr.trans.sun.tools.javac.util.Position;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int infixPrecedenceLevels = 10;
    private Scanner S;
    private TreeMaker F;
    private Log log;
    private Keywords keywords;
    private Source source;
    private Name.Table names;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean keepDocComments;
    boolean genEndPos;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    private int mode = 0;
    private int lastmode = 0;
    static Tree errorTree = new Tree.Erroneous();
    Map<Tree, String> docComments;
    Map<Tree, Integer> endPositions;
    private static List<String> emptyStringList = new List();
    ListBuffer<Tree[]> odStackSupply = new ListBuffer();
    ListBuffer<Tokens[]> opStackSupply = new ListBuffer();

    protected Parser(Factory factory, Scanner scanner, boolean bl) {
        this.S = scanner;
        this.F = factory.F;
        this.log = factory.log;
        this.names = factory.names;
        this.keywords = factory.keywords;
        this.source = factory.source;
        Options options = factory.options;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.keepDocComments = bl;
        boolean bl2 = this.genEndPos = options.get("-Xjcov") != null;
        if (bl) {
            this.docComments = new HashMap<Tree, String>();
        }
        if (this.genEndPos) {
            this.endPositions = new HashMap<Tree, Integer>();
        }
    }

    private void skip() {
        int n = 0;
        int n2 = 0;
        while (true) {
            switch (this.S.token()) {
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case SEMI: {
                    if (n != 0 || n2 != 0) break;
                    return;
                }
                case RBRACE: {
                    if (n == 0) {
                        return;
                    }
                    --n;
                    break;
                }
                case RPAREN: {
                    if (n2 <= 0) break;
                    --n2;
                    break;
                }
                case LBRACE: {
                    ++n;
                    break;
                }
                case LPAREN: {
                    ++n2;
                    break;
                }
            }
            this.S.nextToken();
        }
    }

    private Tree syntaxError(int n, String string, String string2) {
        if (n != this.S.errPos()) {
            this.log.error(n, string, string2);
        }
        this.skip();
        this.S.errPos(n);
        return errorTree;
    }

    private Tree syntaxError(int n, String string) {
        return this.syntaxError(n, string, null);
    }

    private Tree syntaxError(String string) {
        return this.syntaxError(this.S.pos(), string, null);
    }

    private Tree syntaxError(String string, String string2) {
        return this.syntaxError(this.S.pos(), string, string2);
    }

    private void accept(Tokens tokens) {
        if (this.S.token() == tokens) {
            this.S.nextToken();
        } else {
            int n = Position.line(this.S.pos()) > Position.line(this.S.prevEndPos() + 1) ? this.S.prevEndPos() + 1 : this.S.pos();
            this.syntaxError(n, "expected", this.keywords.token2string(tokens));
            if (this.S.token() == tokens) {
                this.S.nextToken();
            }
        }
    }

    Tree illegal(int n) {
        if ((this.mode & 1) != 0) {
            return this.syntaxError(n, "illegal.start.of.expr");
        }
        return this.syntaxError(n, "illegal.start.of.type");
    }

    Tree illegal() {
        return this.illegal(this.S.pos());
    }

    void checkNoMods(long l) {
        if (l != 0L) {
            long l2 = l & -l;
            this.log.error(this.S.pos(), "mod.not.allowed.here", Flags.toString(l2).trim());
        }
    }

    void attach(Tree tree, String string) {
        if (this.keepDocComments && string != null) {
            this.docComments.put(tree, string);
        }
    }

    void storeEnd(Tree tree, int n) {
        if (this.genEndPos) {
            this.endPositions.put(tree, n);
        }
    }

    Name ident() {
        if (this.S.token() == Tokens.IDENTIFIER) {
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Tokens.ASSERT) {
            if (this.allowAsserts) {
                this.log.error(this.S.pos(), "assert.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "assert.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Tokens.ENUM) {
            if (this.allowEnums) {
                this.log.error(this.S.pos(), "enum.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "enum.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        this.accept(Tokens.IDENTIFIER);
        return this.names.error;
    }

    Tree qualident() {
        Tree tree = this.F.at(this.S.pos()).Ident(this.ident());
        while (this.S.token() == Tokens.DOT) {
            int n = this.S.pos();
            this.S.nextToken();
            tree = this.F.at(n).Select(tree, this.ident());
        }
        return tree;
    }

    Tree literal(Name name) {
        int n = this.S.pos();
        Tree tree = errorTree;
        switch (this.S.token()) {
            case INTLITERAL: {
                try {
                    tree = this.F.at(n).Literal(4, Convert.string2int(this.strval(name), this.S.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(name));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    tree = this.F.at(n).Literal(5, new Long(Convert.string2long(this.strval(name), this.S.radix())));
                }
                catch (NumberFormatException numberFormatException) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(name));
                }
                break;
            }
            case FLOATLITERAL: {
                Float f;
                String string = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    f = Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    f = Float.valueOf(Float.NaN);
                }
                if (f.floatValue() == 0.0f && !this.isZero(string)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (f.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                tree = this.F.at(n).Literal(6, f);
                break;
            }
            case DOUBLELITERAL: {
                Double d;
                String string = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                if (d == 0.0 && !this.isZero(string)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                tree = this.F.at(n).Literal(7, d);
                break;
            }
            case CHARLITERAL: {
                tree = this.F.at(n).Literal(2, this.S.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                tree = this.F.at(n).Literal(10, this.S.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: 
            case NULL: 
            case NOOP: {
                tree = this.F.at(n).Ident(this.S.name());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.S.nextToken();
        return tree;
    }

    boolean isZero(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = Character.toLowerCase(string.charAt(1)) == 'x' ? 16 : 10;
        int n3 = n = n2 == 16 ? 2 : 0;
        while (n < cArray.length && (cArray[n] == '0' || cArray[n] == '.')) {
            ++n;
        }
        return n >= cArray.length || Character.digit(cArray[n], n2) <= 0;
    }

    String strval(Name name) {
        String string = this.S.stringVal();
        return name.len == 0 ? string : name + string;
    }

    Tree expression() {
        return this.term(1);
    }

    Tree type() {
        return this.term(2);
    }

    Tree term(int n) {
        int n2 = this.mode;
        this.mode = n;
        Tree tree = this.term();
        this.lastmode = this.mode;
        this.mode = n2;
        return tree;
    }

    Tree term() {
        Tree tree = this.term1();
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.EQ || Tokens.PLUSEQ.compareTo(this.S.token()) <= 0 && this.S.token().compareTo(Tokens.GTGTGTEQ) <= 0) {
            return this.termRest(tree);
        }
        return tree;
    }

    Tree termRest(Tree tree) {
        switch (this.S.token()) {
            case EQ: {
                int n = this.S.pos();
                this.S.nextToken();
                this.mode = 1;
                Tree tree2 = this.term();
                return this.F.at(n).Assign(tree, tree2);
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int n = this.S.pos();
                Tokens tokens = this.S.token();
                this.S.nextToken();
                this.mode = 1;
                Tree tree3 = this.term();
                return this.F.at(n).Assignop(Parser.optag(tokens), tree, tree3);
            }
        }
        return tree;
    }

    Tree term1() {
        Tree tree = this.term2();
        if ((this.mode & 1) != 0 & this.S.token() == Tokens.QUES) {
            this.mode = 1;
            return this.term1Rest(tree);
        }
        return tree;
    }

    Tree term1Rest(Tree tree) {
        if (this.S.token() == Tokens.QUES) {
            int n = this.S.pos();
            this.S.nextToken();
            Tree tree2 = this.term();
            this.accept(Tokens.COLON);
            Tree tree3 = this.term1();
            return this.F.at(n).Conditional(tree, tree2, tree3);
        }
        return tree;
    }

    Tree term2() {
        Tree tree = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.S.token()) >= 4) {
            this.mode = 1;
            return this.term2Rest(tree, 4);
        }
        return tree;
    }

    Tree term2Rest(Tree tree, int n) {
        StringBuffer stringBuffer;
        List list = this.odStackSupply.elems;
        Tree[] treeArray = this.newOdStack();
        List list2 = this.opStackSupply.elems;
        Tokens[] tokensArray = this.newOpStack();
        int n2 = 0;
        treeArray[0] = tree;
        int n3 = this.S.pos();
        Tokens tokens = Tokens.ERROR;
        while (Parser.prec(this.S.token()) >= n) {
            tokensArray[n2] = tokens;
            tokens = this.S.token();
            int n4 = this.S.pos();
            this.S.nextToken();
            Tree tree2 = treeArray[++n2] = tokens == Tokens.INSTANCEOF ? this.type() : this.term3();
            while (n2 > 0 && Parser.prec(tokens) >= Parser.prec(this.S.token())) {
                treeArray[n2 - 1] = this.makeOp(n4, tokens, treeArray[n2 - 1], treeArray[n2]);
                tokens = tokensArray[--n2];
            }
        }
        assert (n2 == 0);
        tree = treeArray[0];
        if (tree.tag == 91 && (stringBuffer = Parser.foldStrings(tree)) != null) {
            tree = this.F.at(n3).Literal(10, stringBuffer.toString());
        }
        this.odStackSupply.elems = list;
        this.opStackSupply.elems = list2;
        return tree;
    }

    private Tree makeOp(int n, Tokens tokens, Tree tree, Tree tree2) {
        if (tokens == Tokens.INSTANCEOF) {
            return this.F.at(n).TypeTest(tree, tree2);
        }
        return this.F.at(n).Binary(Parser.optag(tokens), tree, tree2);
    }

    private static StringBuffer foldStrings(Tree tree) {
        List<String> list = emptyStringList;
        while (true) {
            Object object;
            Tree tree2;
            if (tree.tag == 55) {
                tree2 = (Tree.Literal)tree;
                if (tree2.typetag != 10) break;
                object = new StringBuffer((String)tree2.value);
                while (list.nonEmpty()) {
                    ((StringBuffer)object).append((String)list.head);
                    list = list.tail;
                }
                return object;
            }
            if (tree.tag != 91) break;
            tree2 = (Tree.Binary)tree;
            if (((Tree.Binary)tree2).rhs.tag != 55) break;
            object = (Tree.Literal)((Tree.Binary)tree2).rhs;
            if (((Tree.Literal)object).typetag != 10) break;
            list = list.prepend((String)((Tree.Literal)object).value);
            tree = ((Tree.Binary)tree2).lhs;
        }
        return null;
    }

    private Tree[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new Tree[11]);
        }
        Tree[] treeArray = (Tree[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return treeArray;
    }

    private Tokens[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new Tokens[11]);
        }
        Tokens[] tokensArray = (Tokens[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return tokensArray;
    }

    Tree term3() {
        int n;
        Tree tree;
        int n2 = this.S.pos();
        List<Tree> list = this.typeArgumentsOpt(1);
        switch (this.S.token()) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case BANG: 
            case TILDE: 
            case PLUSPLUS: 
            case SUBSUB: 
            case PLUS: 
            case SUB: {
                if (list == null && (this.mode & 1) != 0) {
                    Tokens tokens = this.S.token();
                    this.S.nextToken();
                    this.mode = 1;
                    if (tokens == Tokens.SUB && (this.S.token() == Tokens.INTLITERAL || this.S.token() == Tokens.LONGLITERAL) && this.S.radix() == 10) {
                        this.mode = 1;
                        tree = this.literal(this.names.hyphen);
                        break;
                    }
                    Tree tree2 = this.term3();
                    return this.F.at(n2).Unary(Parser.unoptag(tokens), tree2);
                }
                return this.illegal();
            }
            case LPAREN: {
                Object object;
                if (list == null && (this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    tree = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token() == Tokens.LT) {
                        int n3 = 84;
                        n = this.S.pos();
                        this.S.nextToken();
                        this.mode &= 3;
                        this.mode |= 8;
                        object = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token() == Tokens.COMMA || this.S.token() == Tokens.GT)) {
                            this.mode = 2;
                            ListBuffer<Object> listBuffer = new ListBuffer<Object>();
                            listBuffer.append(object);
                            while (this.S.token() == Tokens.COMMA) {
                                this.S.nextToken();
                                listBuffer.append(this.typeArgument());
                            }
                            this.accept(Tokens.GT);
                            tree = this.F.at(n).TypeApply(tree, listBuffer.toList());
                            this.checkGenerics();
                            tree = this.bracketsOpt(tree);
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            tree = this.F.at(n).Binary(n3, tree, this.term2Rest((Tree)object, 11));
                            tree = this.termRest(this.term1Rest(this.term2Rest(tree, 4)));
                        } else {
                            this.accept(Tokens.GT);
                        }
                    } else {
                        tree = this.termRest(this.term1Rest(this.term2Rest(tree, 4)));
                    }
                    this.accept(Tokens.RPAREN);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        Tree tree3 = this.term3();
                        return this.F.at(n2).TypeCast(tree, tree3);
                    }
                    if ((this.lastmode & 2) != 0) {
                        switch (this.S.token()) {
                            case ENUM: 
                            case LPAREN: 
                            case INTLITERAL: 
                            case LONGLITERAL: 
                            case FLOATLITERAL: 
                            case DOUBLELITERAL: 
                            case CHARLITERAL: 
                            case STRINGLITERAL: 
                            case TRUE: 
                            case FALSE: 
                            case NULL: 
                            case NOOP: 
                            case BANG: 
                            case TILDE: 
                            case THIS: 
                            case SUPER: 
                            case NEW: 
                            case IDENTIFIER: 
                            case ASSERT: 
                            case BYTE: 
                            case SHORT: 
                            case CHAR: 
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case VOID: 
                            case CAP: {
                                Tree tree4 = this.term3();
                                return this.F.at(n2).TypeCast(tree, tree4);
                            }
                        }
                    } else if (this.S.token() == Tokens.LPAREN && tree.tag == 50) {
                        return this.F.at(n2).Apply(list, tree, this.arguments());
                    }
                } else {
                    return this.illegal();
                }
                tree = this.F.at(n2).Parens(tree);
                break;
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    tree = this.F.at(n2).Ident(this.names._this);
                    this.S.nextToken();
                    tree = list == null ? this.argumentsOpt(null, tree) : this.arguments(list, tree);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    tree = this.superSuffix(list, this.F.at(n2).Ident(this.names._super));
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: 
            case NOOP: {
                if (list == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    tree = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    if (this.S.token() == Tokens.LT) {
                        list = this.typeArguments();
                    }
                    tree = this.creator(n2, list);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case ENUM: 
            case IDENTIFIER: 
            case ASSERT: {
                if (list != null) {
                    return this.illegal();
                }
                tree = this.F.at(this.S.pos()).Ident(this.ident());
                block32: while (true) {
                    n2 = this.S.pos();
                    switch (this.S.token()) {
                        case LBRACKET: {
                            this.S.nextToken();
                            if (this.S.token() == Tokens.RBRACKET) {
                                this.S.nextToken();
                                tree = this.bracketsSuffix(this.F.at(n2).TypeArray(this.bracketsOpt(tree)));
                                break block32;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                Tree tree5 = this.term();
                                tree = this.F.at(n2).Indexed(tree, tree5);
                            }
                            this.accept(Tokens.RBRACKET);
                            break block32;
                        }
                        case LPAREN: {
                            if ((this.mode & 1) == 0) break block32;
                            this.mode = 1;
                            tree = this.arguments(list, tree);
                            list = null;
                            break block32;
                        }
                        case DOT: {
                            this.S.nextToken();
                            list = this.typeArgumentsOpt(1);
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token()) {
                                    case CLASS: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        tree = this.F.at(n2).Select(tree, this.names._class);
                                        this.S.nextToken();
                                        break block32;
                                    }
                                    case THIS: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        tree = this.F.at(n2).Select(tree, this.names._this);
                                        this.S.nextToken();
                                        break block32;
                                    }
                                    case REMOTE: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        tree = this.F.at(n2).Select(tree, this.names._remote);
                                        this.S.nextToken();
                                        break block32;
                                    }
                                    case THISVM: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        tree = this.F.at(n2).Select(tree, this.names._thisvm);
                                        this.S.nextToken();
                                        break block32;
                                    }
                                    case SUPER: {
                                        this.mode = 1;
                                        tree = this.superSuffix(list, this.F.at(n2).Select(tree, this.names._super));
                                        list = null;
                                        break block32;
                                    }
                                    case NEW: {
                                        if (list != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        int n4 = this.S.pos();
                                        this.S.nextToken();
                                        if (this.S.token() == Tokens.LT) {
                                            list = this.typeArguments();
                                        }
                                        tree = this.innerCreator(n4, list, tree);
                                        list = null;
                                        break block32;
                                    }
                                }
                            }
                            tree = this.F.at(n2).Select(tree, this.ident());
                            continue block32;
                        }
                    }
                    break;
                }
                if (list != null) {
                    this.illegal();
                }
                tree = this.typeArgumentsOpt(tree);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) {
                    this.illegal();
                }
                tree = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (list != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token() == Tokens.DOT) {
                        tree = this.bracketsSuffix(this.F.at(n2).TypeIdent(9));
                        break;
                    }
                    return this.illegal(n2);
                }
                return this.illegal();
            }
            case CAP: {
                Tree tree6;
                this.S.nextToken();
                if (this.S.token() == Tokens.VOID) {
                    tree6 = this.F.at(this.S.pos()).TypeIdent(9);
                    this.S.nextToken();
                } else {
                    tree6 = this.type();
                }
                List<Tree.VarDef> list2 = this.capOrOpDeclFormalParameters();
                Object object = new List<Tree>();
                List<Tree.VarDef> list3 = list2;
                while (list3.nonEmpty()) {
                    object = ((List)object).append(((Tree.VarDef)list3.head).vartype);
                    list3 = list3.tail;
                }
                boolean bl = list2.nonEmpty() && (list2.last().mods.flags & 0x400000000L) != 0L;
                List<Tree> list4 = new List();
                if (this.S.token() == Tokens.THROWS) {
                    this.S.nextToken();
                    list4 = this.qualidentList();
                }
                tree = this.F.at(n2).TypeCap(tree6, (List<Tree>)object, list4, bl, false);
                break;
            }
            case VM: {
                this.S.nextToken();
                tree = this.F.at(n2).TypeVm();
                break;
            }
            case REMOTE: {
                this.S.nextToken();
                tree = this.F.at(n2).TypeRemote(this.qualident());
                break;
            }
            default: {
                return this.illegal();
            }
        }
        if (list != null) {
            this.illegal();
        }
        while (true) {
            int n5 = this.S.pos();
            if (this.S.token() == Tokens.LBRACKET) {
                this.S.nextToken();
                if ((this.mode & 2) != 0) {
                    n = this.mode;
                    this.mode = 2;
                    if (this.S.token() == Tokens.RBRACKET) {
                        this.S.nextToken();
                        return this.F.at(n5).TypeArray(this.bracketsOpt(tree));
                    }
                    this.mode = n;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    Tree tree7 = this.term();
                    tree = this.F.at(n5).Indexed(tree, tree7);
                }
                this.accept(Tokens.RBRACKET);
                continue;
            }
            if (this.S.token() != Tokens.DOT) break;
            this.S.nextToken();
            list = this.typeArgumentsOpt(1);
            if (this.S.token() == Tokens.SUPER && (this.mode & 1) != 0) {
                this.mode = 1;
                tree = this.F.at(n2).Select(tree, this.names._super);
                this.S.nextToken();
                tree = this.arguments(list, tree);
                list = null;
                continue;
            }
            if (this.S.token() == Tokens.NEW && (this.mode & 1) != 0) {
                if (list != null) {
                    return this.illegal();
                }
                this.mode = 1;
                n = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Tokens.LT) {
                    list = this.typeArguments();
                }
                tree = this.innerCreator(n, list, tree);
                list = null;
                continue;
            }
            if (this.S.token() == Tokens.REMOTE && (this.mode & 1) != 0) {
                this.mode = 1;
                tree = this.F.at(n2).Select(tree, this.names._remote);
                this.S.nextToken();
                list = null;
                continue;
            }
            if (this.S.token() == Tokens.THISVM && (this.mode & 1) != 0) {
                this.mode = 1;
                tree = this.F.at(n2).Select(tree, this.names._thisvm);
                this.S.nextToken();
                list = null;
                continue;
            }
            tree = this.argumentsOpt(list, this.typeArgumentsOpt(this.F.at(n2).Select(tree, this.ident())));
            list = null;
        }
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.LPAREN) {
            list = this.typeArgumentsOpt(1);
            tree = this.arguments(list, tree);
            list = null;
        }
        while ((this.S.token() == Tokens.PLUSPLUS || this.S.token() == Tokens.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            tree = this.F.at(this.S.pos()).Unary(this.S.token() == Tokens.PLUSPLUS ? 74 : 75, tree);
            this.S.nextToken();
        }
        if (this.genEndPos) {
            this.endPositions.put(tree, this.S.prevEndPos());
        }
        return tree;
    }

    Tree superSuffix(List<Tree> list, Tree tree) {
        this.S.nextToken();
        if (this.S.token() == Tokens.LPAREN || list != null) {
            tree = this.arguments(list, tree);
        } else {
            int n = this.S.pos();
            this.accept(Tokens.DOT);
            tree = this.argumentsOpt(this.S.token() == Tokens.LT ? this.typeArguments() : null, this.F.at(n).Select(tree, this.ident()));
        }
        return tree;
    }

    Tree basicType() {
        Tree.TypeIdent typeIdent = this.F.at(this.S.pos()).TypeIdent(Parser.typetag(this.S.token()));
        this.S.nextToken();
        return typeIdent;
    }

    Tree argumentsOpt(List<Tree> list, Tree tree) {
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.LPAREN || list != null) {
            this.mode = 1;
            return this.arguments(list, tree);
        }
        return tree;
    }

    List<Tree> arguments() {
        int n = this.S.pos();
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.LPAREN) {
            this.S.nextToken();
            if (this.S.token() != Tokens.RPAREN) {
                listBuffer.append(this.expression());
                while (this.S.token() == Tokens.COMMA) {
                    this.S.nextToken();
                    listBuffer.append(this.expression());
                }
            }
            this.accept(Tokens.RPAREN);
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
        }
        return listBuffer.toList();
    }

    Tree arguments(List<Tree> list, Tree tree) {
        int n = this.S.pos();
        List<Tree> list2 = this.arguments();
        return this.F.at(n).Apply(list, tree, list2);
    }

    Tree typeArgumentsOpt(Tree tree) {
        if (this.S.token() == Tokens.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(tree);
        }
        return tree;
    }

    List<Tree> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<Tree> typeArgumentsOpt(int n) {
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            if ((this.mode & n) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = n;
            return this.typeArguments();
        }
        return null;
    }

    List<Tree> typeArguments() {
        int n = this.S.pos();
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.LT) {
            this.S.nextToken();
            listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            }
            switch (this.S.token()) {
                case GTGTGTEQ: {
                    this.S.token(Tokens.GTGTEQ);
                    break;
                }
                case GTGTEQ: {
                    this.S.token(Tokens.GTEQ);
                    break;
                }
                case GTEQ: {
                    this.S.token(Tokens.EQ);
                    break;
                }
                case GTGTGT: {
                    this.S.token(Tokens.GTGT);
                    break;
                }
                case GTGT: {
                    this.S.token(Tokens.GT);
                    break;
                }
                default: {
                    this.accept(Tokens.GT);
                    break;
                }
            }
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LT));
        }
        return listBuffer.toList();
    }

    Tree typeArgument() {
        Object var1_1 = null;
        if (this.S.token() != Tokens.QUES) {
            return this.type();
        }
        this.S.nextToken();
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            return this.F.at(this.S.pos()).TypeArgument(this.F.TypeBoundKind(BoundKind.EXTENDS), this.type());
        }
        if (this.S.token() == Tokens.SUPER) {
            this.S.nextToken();
            return this.F.at(this.S.pos()).TypeArgument(this.F.TypeBoundKind(BoundKind.SUPER), this.type());
        }
        return this.F.at(this.S.pos()).TypeArgument(this.F.TypeBoundKind(BoundKind.UNBOUND), null);
    }

    Tree typeArguments(Tree tree) {
        int n = this.S.pos();
        List<Tree> list = this.typeArguments();
        return this.F.at(n).TypeApply(tree, list);
    }

    private Tree bracketsOpt(Tree tree) {
        if (this.S.token() == Tokens.LBRACKET) {
            int n = this.S.pos();
            this.S.nextToken();
            tree = this.bracketsOptCont(tree, n);
        }
        return tree;
    }

    private Tree bracketsOptCont(Tree tree, int n) {
        this.accept(Tokens.RBRACKET);
        tree = this.bracketsOpt(tree);
        return this.F.at(n).TypeArray(tree);
    }

    Tree bracketsSuffix(Tree tree) {
        if ((this.mode & 1) != 0 && this.S.token() == Tokens.DOT) {
            this.mode = 1;
            int n = this.S.pos();
            this.S.nextToken();
            this.accept(Tokens.CLASS);
            tree = this.F.at(n).Select(tree, this.names._class);
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.syntaxError(this.S.pos(), "dot.class.expected");
        }
        return tree;
    }

    Tree creator(int n, List<Tree> list) {
        switch (this.S.token()) {
            case SEM: {
                this.S.nextToken();
                if (this.S.token() == Tokens.LPAREN) {
                    Tree tree = this.expression();
                    return this.F.at(this.S.pos()).TypeCap(this.F.at(this.S.pos()).TypeIdent(9), new List<Tree>(), new List<Tree>(), false, true, tree);
                }
                return this.F.at(this.S.pos()).TypeCap(this.F.at(this.S.pos()).TypeIdent(9), new List<Tree>(), new List<Tree>(), false, true);
            }
            case CAP: 
            case OP: {
                Tree tree;
                boolean bl = false;
                if (this.S.token() == Tokens.OP) {
                    bl = true;
                }
                int n2 = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Tokens.VOID) {
                    tree = this.F.at(this.S.pos()).TypeIdent(9);
                    this.S.nextToken();
                } else {
                    tree = this.type();
                }
                List<Tree.VarDef> list2 = this.capOrOpDeclFormalParameters();
                List<Tree> list3 = new List<Tree>();
                List<Tree.VarDef> list4 = list2;
                while (list4.nonEmpty()) {
                    list3 = list3.append(((Tree.VarDef)list4.head).vartype);
                    list4 = list4.tail;
                }
                boolean bl2 = list2.nonEmpty() && (list2.last().mods.flags & 0x400000000L) != 0L;
                List<Tree> list5 = new List();
                if (this.S.token() == Tokens.THROWS) {
                    this.S.nextToken();
                    list5 = this.qualidentList();
                }
                Tree.TypeCap typeCap = this.F.at(n2).TypeCap(tree, list3, list5, bl2, bl);
                if (bl) {
                    return typeCap;
                }
                if (list == null) {
                    return this.arrayCreatorRest(n, typeCap);
                }
            }
            case VM: {
                this.S.nextToken();
                Tree.TypeVm typeVm = this.F.at(n).TypeVm();
                Tree tree = null;
                if (this.S.token() == Tokens.LBRACKET) {
                    return this.arrayCreatorRest(n, typeVm);
                }
                this.accept(Tokens.LPAREN);
                this.accept(Tokens.RPAREN);
                if (this.S.token() == Tokens.ON) {
                    this.S.nextToken();
                    tree = this.term3();
                }
                return this.F.at(n).NewClass(null, list, typeVm, new List<Tree>(), null, tree);
            }
            case REMOTE: {
                this.S.nextToken();
                Tree tree = this.qualident();
                int n3 = this.mode;
                this.mode = 2;
                if (this.S.token() == Tokens.LT) {
                    this.checkGenerics();
                    tree = this.typeArguments(tree);
                }
                this.mode = n3;
                Tree.TypeRemote typeRemote = this.F.at(n).TypeRemote(tree);
                if (this.S.token() == Tokens.LBRACKET) {
                    return this.arrayCreatorRest(n, typeRemote);
                }
                if (this.S.token() == Tokens.LPAREN) {
                    return this.classCreatorRest(n, null, list, typeRemote);
                }
                return this.syntaxError("left-paren.or.left-dquare-bracket.expected");
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) break;
                return this.arrayCreatorRest(n, this.basicType());
            }
        }
        Tree tree = this.qualident();
        int n4 = this.mode;
        this.mode = 2;
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            tree = this.typeArguments(tree);
        }
        this.mode = n4;
        if (this.S.token() == Tokens.LBRACKET) {
            return this.arrayCreatorRest(n, tree);
        }
        if (this.S.token() == Tokens.LPAREN) {
            return this.classCreatorRest(n, null, list, tree);
        }
        return this.syntaxError("left-paren.or.left-square-bracket.expected");
    }

    Tree innerCreator(int n, List<Tree> list, Tree tree) {
        Tree tree2 = this.F.at(this.S.pos()).Ident(this.ident());
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            tree2 = this.typeArguments(tree2);
        }
        return this.classCreatorRest(n, tree, list, tree2);
    }

    Tree arrayCreatorRest(int n, Tree tree) {
        this.accept(Tokens.LBRACKET);
        if (this.S.token() == Tokens.RBRACKET) {
            this.accept(Tokens.RBRACKET);
            tree = this.bracketsOpt(tree);
            if (this.S.token() == Tokens.LBRACE) {
                return this.arrayInitializer(tree);
            }
            this.syntaxError(this.S.pos(), "array.dimension.missing");
            return errorTree;
        }
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        listBuffer.append(this.expression());
        this.accept(Tokens.RBRACKET);
        while (this.S.token() == Tokens.LBRACKET) {
            int n2 = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Tokens.RBRACKET) {
                tree = this.bracketsOptCont(tree, n2);
                continue;
            }
            listBuffer.append(this.expression());
            this.accept(Tokens.RBRACKET);
        }
        return this.F.at(n).NewArray(tree, listBuffer.toList(), null);
    }

    Tree classCreatorRest(int n, Tree tree, List<Tree> list, Tree tree2) {
        List<Tree> list2 = this.arguments();
        Tree.ClassDef classDef = null;
        Tree tree3 = null;
        boolean bl = false;
        if (this.S.token() == Tokens.ON) {
            this.S.nextToken();
            tree3 = this.term3();
            bl = true;
        }
        if (this.S.token() == Tokens.LBRACE) {
            classDef = this.F.at(this.S.pos()).ClassDef(this.F.Modifiers(0L, Tree.Annotation.emptyList), this.names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, this.classOrInterfaceBody(this.names.empty, false));
        }
        if (bl) {
            return this.F.at(n).NewClass(tree, list, tree2, list2, classDef, tree3);
        }
        return this.F.at(n).NewClass(tree, list, tree2, list2, classDef);
    }

    Tree arrayInitializer(Tree tree) {
        int n = this.S.pos();
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Tokens.RBRACE) {
            listBuffer.append(this.variableInitializer());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Tokens.RBRACE) break;
                listBuffer.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.RBRACE);
        return this.F.at(n).NewArray(tree, Tree.emptyList, listBuffer.toList());
    }

    Tree variableInitializer() {
        return this.S.token() == Tokens.LBRACE ? this.arrayInitializer(null) : this.expression();
    }

    Tree parExpression() {
        int n = this.S.pos();
        this.accept(Tokens.LPAREN);
        Tree tree = this.expression();
        this.accept(Tokens.RPAREN);
        return this.genEndPos ? this.F.at(n).Parens(tree) : tree;
    }

    Tree.Block block(long l) {
        int n = this.S.pos();
        this.accept(Tokens.LBRACE);
        List<Tree> list = this.blockStatements();
        Tree.Block block = this.F.at(n).Block(l, list);
        while (this.S.token() == Tokens.CASE || this.S.token() == Tokens.DEFAULT) {
            this.syntaxError("orphaned", this.keywords.token2string(this.S.token()));
            this.blockStatements();
        }
        block.endpos = this.S.pos();
        this.accept(Tokens.RBRACE);
        return block;
    }

    Tree.Block block() {
        return this.block(0L);
    }

    List<Tree> blockStatements() {
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        block10: while (true) {
            List list;
            Object object;
            Object object2;
            int n = this.S.pos();
            switch (this.S.token()) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    return listBuffer.toList();
                }
                case SEMI: 
                case LBRACE: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case SYNCHRONIZED: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case JRCALL: 
                case SEND: 
                case FORWARD: 
                case REPLY: 
                case SEMP: 
                case SEMV: 
                case RECEIVE: 
                case IN: 
                case VIEW: 
                case CO: {
                    listBuffer.append(this.statement());
                    continue block10;
                }
                case MONKEYS_AT: 
                case FINAL: {
                    object2 = this.S.docComment();
                    object = this.modifiersOpt();
                    if (this.S.token() == Tokens.INTERFACE || this.S.token() == Tokens.CLASS || this.allowEnums && this.S.token() == Tokens.ENUM) {
                        listBuffer.append(this.classOrInterfaceOrEnumDeclaration((Tree.Modifiers)object, (String)object2));
                        continue block10;
                    }
                    n = this.S.pos();
                    list = this.type();
                    listBuffer.appendList(this.variableDeclarators((Tree.Modifiers)object, (Tree)((Object)list)));
                    this.accept(Tokens.SEMI);
                    continue block10;
                }
                case ABSTRACT: 
                case STRICTFP: {
                    object2 = this.S.docComment();
                    object = this.modifiersOpt();
                    listBuffer.append(this.classOrInterfaceOrEnumDeclaration((Tree.Modifiers)object, (String)object2));
                    continue block10;
                }
                case CLASS: 
                case INTERFACE: {
                    listBuffer.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                    continue block10;
                }
                case OP: {
                    boolean bl;
                    this.S.nextToken();
                    object2 = this.typeParametersOpt();
                    object = this.S.name();
                    n = this.S.pos();
                    boolean bl2 = bl = this.S.token() == Tokens.VOID;
                    if (bl) {
                        list = this.F.at(n).TypeIdent(9);
                        this.S.nextToken();
                    } else {
                        list = this.type();
                    }
                    if (this.S.token() == Tokens.LPAREN && ((Tree)((Object)list)).tag == 54) {
                        if (object != this.names.empty) {
                            this.log.error(n, "invalid.op.decl.ret.type.req", new Object[0]);
                        }
                        listBuffer.append(this.opDeclaratorRest(n, new Tree.Modifiers(0L, Tree.Annotation.emptyList), null, this.names.init, (List<Tree.TypeParameter>)object2, true, true, null, true));
                        continue block10;
                    }
                    n = this.S.pos();
                    object = this.ident();
                    if (this.S.token() == Tokens.LPAREN) {
                        listBuffer.append(this.opDeclaratorRest(n, new Tree.Modifiers(0L, Tree.Annotation.emptyList), (Tree)((Object)list), (Name)object, (List<Tree.TypeParameter>)object2, true, bl, null, true));
                        continue block10;
                    }
                    this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
                    continue block10;
                }
                case SEM: {
                    this.S.nextToken();
                    n = this.S.pos();
                    object2 = this.F.at(n).TypeIdent(9);
                    object = this.variableDeclarators(new Tree.Modifiers(0L, null), (Tree)object2);
                    list = object;
                    while (list.nonEmpty()) {
                        if (((Tree.VarDef)list.head).vartype.tag != 56) {
                            this.syntaxError(((Tree)list.head).pos, "sem.arraytype.not.allowed");
                        }
                        Tree.OperationDef operationDef = this.F.at(((Tree)list.head).pos).OperationDef(new Tree.Modifiers(0L, Tree.Annotation.emptyList), ((Tree.VarDef)list.head).name, (Tree)object2, Tree.TypeParameter.emptyList, new List<Tree.VarDef>(), Tree.emptyList, null, null);
                        listBuffer.append(this.F.at(((Tree)list.head).pos).SemaphoreDef(new Tree.Modifiers(0L, Tree.Annotation.emptyList), ((Tree.VarDef)list.head).name, operationDef, ((Tree.VarDef)list.head).init));
                        list = list.tail;
                    }
                    this.accept(Tokens.SEMI);
                    continue block10;
                }
                case ENUM: 
                case ASSERT: {
                    if (this.allowEnums && this.S.token() == Tokens.ENUM) {
                        this.log.error(this.S.pos(), "local.enum", new Object[0]);
                        listBuffer.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                        continue block10;
                    }
                    if (!this.allowAsserts || this.S.token() != Tokens.ASSERT) break;
                    listBuffer.append(this.statement());
                    continue block10;
                }
            }
            object2 = this.S.name();
            object = this.term(3);
            if (this.S.token() == Tokens.COLON && ((Tree)object).tag == 54) {
                this.S.nextToken();
                list = this.statement();
                listBuffer.append(this.F.at(n).Labelled((Name)object2, (Tree)((Object)list)));
                continue;
            }
            if ((this.lastmode & 2) != 0 && (this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM)) {
                listBuffer.appendList(this.variableDeclarators(this.F.at(this.S.pos()).Modifiers(0L), (Tree)object));
                this.accept(Tokens.SEMI);
                continue;
            }
            listBuffer.append(this.F.at(n).Exec(this.checkExprStat((Tree)object)));
            this.accept(Tokens.SEMI);
        }
    }

    Tree statement() {
        int n = this.S.pos();
        switch (this.S.token()) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.S.nextToken();
                Tree tree = this.parExpression();
                Tree tree2 = this.statement();
                Tree tree3 = null;
                if (this.S.token() == Tokens.ELSE) {
                    this.S.nextToken();
                    tree3 = this.statement();
                }
                return this.F.at(n).If(tree, tree2, tree3);
            }
            case FOR: {
                List<Tree> list;
                this.S.nextToken();
                this.accept(Tokens.LPAREN);
                List<Tree> list2 = list = this.S.token() == Tokens.SEMI ? Tree.emptyList : this.forInit();
                if (list.length() == 1 && ((Tree)list.head).tag == 10 && ((Tree.VarDef)list.head).init == null && this.S.token() == Tokens.COLON) {
                    this.checkForeach();
                    Tree.VarDef varDef = (Tree.VarDef)list.head;
                    this.accept(Tokens.COLON);
                    Tree tree = this.expression();
                    this.accept(Tokens.RPAREN);
                    Tree tree4 = this.statement();
                    return this.F.at(n).ForeachLoop(varDef, tree, tree4);
                }
                this.accept(Tokens.SEMI);
                Tree tree = this.S.token() == Tokens.SEMI ? null : this.expression();
                this.accept(Tokens.SEMI);
                List<Tree> list3 = this.S.token() == Tokens.RPAREN ? Tree.emptyList : this.forUpdate();
                this.accept(Tokens.RPAREN);
                Tree tree5 = this.statement();
                return this.F.at(n).ForLoop(list, tree, list3, tree5);
            }
            case WHILE: {
                this.S.nextToken();
                Tree tree = this.parExpression();
                Tree tree6 = this.statement();
                return this.F.at(n).WhileLoop(tree, tree6);
            }
            case DO: {
                this.S.nextToken();
                Tree tree = this.statement();
                this.accept(Tokens.WHILE);
                Tree tree7 = this.parExpression();
                Tree.DoLoop doLoop = this.F.at(n).DoLoop(tree, tree7);
                if (this.genEndPos) {
                    this.endPositions.put(doLoop, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return doLoop;
            }
            case TRY: {
                this.S.nextToken();
                Tree.Block block = this.block();
                ListBuffer<Tree.Catch> listBuffer = new ListBuffer<Tree.Catch>();
                Tree.Block block2 = null;
                if (this.S.token() == Tokens.CATCH || this.S.token() == Tokens.FINALLY) {
                    while (this.S.token() == Tokens.CATCH) {
                        listBuffer.append(this.catchClause());
                    }
                    if (this.S.token() == Tokens.FINALLY) {
                        this.S.nextToken();
                        block2 = this.block();
                    }
                } else {
                    this.log.error(n, "try.without.catch.or.finally", new Object[0]);
                }
                return this.F.at(n).Try(block, listBuffer.toList(), block2);
            }
            case SWITCH: {
                this.S.nextToken();
                Tree tree = this.parExpression();
                this.accept(Tokens.LBRACE);
                List<Tree.Case> list = this.switchBlockStatementGroups();
                Tree.Switch switch_ = this.F.at(n).Switch(tree, list);
                if (this.genEndPos) {
                    this.endPositions.put(switch_, this.S.endPos());
                }
                this.accept(Tokens.RBRACE);
                return switch_;
            }
            case SYNCHRONIZED: {
                this.S.nextToken();
                Tree tree = this.parExpression();
                Tree.Block block = this.block();
                return this.F.at(n).Synchronized(tree, block);
            }
            case RETURN: {
                this.S.nextToken();
                Tree tree = this.S.token() == Tokens.SEMI ? null : this.expression();
                Tree.Return return_ = this.F.at(n).Return(tree);
                if (this.genEndPos) {
                    this.endPositions.put(return_, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return return_;
            }
            case THROW: {
                this.S.nextToken();
                Tree tree = this.expression();
                Tree.Throw throw_ = this.F.at(n).Throw(tree);
                if (this.genEndPos) {
                    this.endPositions.put(throw_, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return throw_;
            }
            case BREAK: {
                this.S.nextToken();
                Name name = this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM ? this.ident() : null;
                Tree.Break break_ = this.F.at(n).Break(name);
                if (this.genEndPos) {
                    this.endPositions.put(break_, this.S.prevEndPos());
                }
                this.accept(Tokens.SEMI);
                return break_;
            }
            case CONTINUE: {
                this.S.nextToken();
                Name name = this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM ? this.ident() : null;
                Tree.Continue continue_ = this.F.at(n).Continue(name);
                if (this.genEndPos) {
                    this.endPositions.put(continue_, this.S.prevEndPos());
                }
                this.accept(Tokens.SEMI);
                return continue_;
            }
            case SEMI: {
                this.S.nextToken();
                return this.F.at(n).Skip();
            }
            case ELSE: {
                return this.syntaxError("else.without.if");
            }
            case FINALLY: {
                return this.syntaxError("finally.without.try");
            }
            case CATCH: {
                return this.syntaxError("catch.without.try");
            }
            case JRCALL: {
                this.S.nextToken();
                Tree tree = this.expression();
                Tree.JRCall jRCall = this.F.at(n).JRCall(tree);
                if (this.genEndPos) {
                    this.endPositions.put(jRCall, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return jRCall;
            }
            case SEND: {
                this.S.nextToken();
                Tree tree = this.expression();
                Tree tree8 = null;
                if (this.S.token() == Tokens.HANDLER) {
                    this.S.nextToken();
                    tree8 = this.expression();
                }
                Tree.Send send = this.F.at(n).Send(tree, tree8);
                if (this.genEndPos) {
                    this.endPositions.put(send, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return send;
            }
            case FORWARD: {
                this.S.nextToken();
                Tree tree = this.expression();
                Tree tree9 = null;
                if (this.S.token() == Tokens.HANDLER) {
                    this.S.nextToken();
                    tree9 = this.expression();
                }
                Tree.Forward forward = this.F.at(n).Forward(tree, tree9);
                if (this.genEndPos) {
                    this.endPositions.put(forward, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return forward;
            }
            case REPLY: {
                this.S.nextToken();
                Tree tree = null;
                Tree tree10 = null;
                if (this.S.token() != Tokens.SEMI && this.S.token() != Tokens.HANDLER) {
                    tree = this.expression();
                }
                if (this.S.token() == Tokens.HANDLER) {
                    this.S.nextToken();
                    tree10 = this.expression();
                }
                Tree.Reply reply = this.F.at(n).Reply(tree, tree10);
                if (this.genEndPos) {
                    this.endPositions.put(reply, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return reply;
            }
            case SEMP: {
                this.S.nextToken();
                this.accept(Tokens.LPAREN);
                Tree tree = this.expression();
                this.accept(Tokens.RPAREN);
                Tree.SemP semP = this.F.at(n).SemP(tree);
                if (this.genEndPos) {
                    this.endPositions.put(semP, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return semP;
            }
            case SEMV: {
                this.S.nextToken();
                this.accept(Tokens.LPAREN);
                Tree tree = this.expression();
                this.accept(Tokens.RPAREN);
                Tree.SemV semV = this.F.at(n).SemV(tree);
                if (this.genEndPos) {
                    this.endPositions.put(semV, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return semV;
            }
            case RECEIVE: {
                this.S.nextToken();
                Tree tree = this.expression();
                Tree.Receive receive = this.F.at(n).Receive(tree);
                if (this.genEndPos) {
                    this.endPositions.put(receive, this.S.endPos());
                }
                this.accept(Tokens.SEMI);
                return receive;
            }
            case IN: {
                this.S.nextToken();
                boolean bl = false;
                Tree tree = null;
                if (this.S.token() == Tokens.INMETHSEL) {
                    bl = true;
                    this.S.nextToken();
                    tree = this.expression();
                    this.accept(Tokens.INOVER);
                }
                boolean bl2 = false;
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                Tree tree11 = this.parseInniArm(bl);
                listBuffer.append(tree11);
                boolean bl3 = bl2 = ((Tree.InniArm)tree11).quant.length() != 0;
                while (this.S.token() == Tokens.LBRACKET) {
                    this.S.nextToken();
                    this.accept(Tokens.RBRACKET);
                    if (this.S.token() == Tokens.ELSE || this.S.token() == Tokens.ELSEAFTER) continue;
                    tree11 = this.parseInniArm(bl);
                    listBuffer.append(tree11);
                    bl2 |= ((Tree.InniArm)tree11).quant.length() != 0;
                }
                Tree.InniArm inniArm = null;
                Tree tree12 = null;
                if (this.S.token() == Tokens.ELSEAFTER) {
                    int n2 = this.S.pos();
                    this.S.nextToken();
                    Tree tree13 = this.expression();
                    Tree tree14 = this.statement();
                    inniArm = this.F.at(n2).InniArm(tree13, tree14);
                    if (this.genEndPos) {
                        this.endPositions.put(inniArm, this.S.endPos());
                    }
                    if (this.S.token() == Tokens.LBRACKET) {
                        this.syntaxError("in.elseafter.not.last");
                    }
                } else if (this.S.token() == Tokens.ELSE) {
                    this.S.nextToken();
                    tree12 = this.statement();
                    if (this.S.token() == Tokens.LBRACKET) {
                        this.syntaxError("in.else.not.last");
                    }
                }
                Tree.Inni inni = bl ? this.F.at(n).Inni(listBuffer.toList(), tree, inniArm, tree12, bl2) : this.F.at(n).Inni(listBuffer.toList(), inniArm, tree12, bl2);
                if (this.genEndPos) {
                    this.endPositions.put(inni, this.S.endPos());
                }
                return inni;
            }
            case VIEW: {
                n = this.S.pos();
                this.S.nextToken();
                Tree tree = this.expression();
                ListBuffer<Tree.ViewArm> listBuffer = new ListBuffer<Tree.ViewArm>();
                Tree tree15 = null;
                if (this.S.token() != Tokens.AS) {
                    this.accept(Tokens.AS);
                }
                while (this.S.token() == Tokens.AS) {
                    this.S.nextToken();
                    int n3 = this.S.pos();
                    List<Tree.VarDef> list = this.formalParameters();
                    Tree tree16 = this.statement();
                    Tree.ViewArm viewArm = this.F.at(n3).ViewArm(list, tree16);
                    listBuffer.append(viewArm);
                    if (!this.genEndPos) continue;
                    this.endPositions.put(viewArm, this.S.endPos());
                }
                if (this.S.token() == Tokens.ELSE) {
                    this.S.nextToken();
                    tree15 = this.statement();
                }
                if (this.S.token() == Tokens.AS && tree15 != null) {
                    this.syntaxError("view.else.not.last");
                }
                Tree.View view = this.F.at(n).View(tree, listBuffer.toList(), tree15);
                if (this.genEndPos) {
                    this.endPositions.put(view, this.S.endPos());
                }
                return view;
            }
            case CO: {
                this.S.nextToken();
                boolean bl = false;
                long l = Tree.Co.getCoStmtNum();
                long l2 = 0L;
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                Tree tree = null;
                if (this.S.token() == Tokens.HANDLER) {
                    this.S.nextToken();
                    tree = this.expression();
                    this.accept(Tokens.INOVER);
                }
                Tree tree17 = this.parseCoArm(l, l2, tree);
                ++l2;
                listBuffer.append(tree17);
                boolean bl4 = bl = ((Tree.CoArm)tree17).quant.length() != 0;
                while (this.S.token() == Tokens.LBRACKET) {
                    this.S.nextToken();
                    this.accept(Tokens.RBRACKET);
                    tree17 = this.parseCoArm(l, l2, tree);
                    ++l2;
                    listBuffer.append(tree17);
                    bl |= ((Tree.CoArm)tree17).quant.length() != 0;
                }
                Tree.Co co = this.F.at(n).Co(listBuffer.toList(), bl, l);
                if (this.genEndPos) {
                    this.endPositions.put(co, this.S.endPos());
                }
                return co;
            }
            case ASSERT: {
                if (!this.allowAsserts || this.S.token() != Tokens.ASSERT) break;
                this.S.nextToken();
                Tree tree = this.expression();
                Tree tree18 = null;
                if (this.S.token() == Tokens.COLON) {
                    this.S.nextToken();
                    tree18 = this.expression();
                }
                Tree.Assert assert_ = this.F.at(n).Assert(tree, tree18);
                this.accept(Tokens.SEMI);
                return assert_;
            }
        }
        Name name = this.S.name();
        Tree tree = this.expression();
        if (this.S.token() == Tokens.COLON && tree.tag == 54) {
            this.S.nextToken();
            Tree tree19 = this.statement();
            return this.F.at(n).Labelled(name, tree19);
        }
        Tree.Exec exec = this.F.at(n).Exec(this.checkExprStat(tree));
        this.accept(Tokens.SEMI);
        return exec;
    }

    Tree.Catch catchClause() {
        int n = this.S.pos();
        this.accept(Tokens.CATCH);
        this.accept(Tokens.LPAREN);
        Tree.VarDef varDef = this.variableDeclaratorId(this.optFinal(0x200000000L), this.qualident());
        this.accept(Tokens.RPAREN);
        Tree.Block block = this.block();
        return this.F.at(n).Catch(varDef, block);
    }

    List<Tree.Case> switchBlockStatementGroups() {
        ListBuffer<Tree.Case> listBuffer = new ListBuffer<Tree.Case>();
        block5: while (true) {
            int n = this.S.pos();
            switch (this.S.token()) {
                case CASE: {
                    this.S.nextToken();
                    Object object = this.expression();
                    this.accept(Tokens.COLON);
                    List<Tree> list = this.blockStatements();
                    listBuffer.append(this.F.at(n).Case((Tree)object, list));
                    continue block5;
                }
                case DEFAULT: {
                    this.S.nextToken();
                    this.accept(Tokens.COLON);
                    Object object = this.blockStatements();
                    listBuffer.append(this.F.at(n).Case(null, (List<Tree>)object));
                    continue block5;
                }
                case EOF: 
                case RBRACE: {
                    return listBuffer.toList();
                }
            }
            this.S.nextToken();
            this.syntaxError(n, "case.default.or.right-brace.expected");
        }
    }

    Tree parseCoArm(long l, long l2, Tree tree) {
        ListBuffer<Tree.Quantifier> listBuffer = new ListBuffer<Tree.Quantifier>();
        Tree.CoArm coArm = null;
        Tree.Block block = null;
        boolean bl = false;
        int n = this.S.pos();
        if (this.S.token() == Tokens.LPAREN) {
            this.S.mark();
            this.S.nextToken();
            this.S.nextToken();
            if (this.S.token() != Tokens.RPAREN) {
                this.type();
                if (this.S.token() == Tokens.RPAREN) {
                    bl = true;
                }
            }
            this.S.reset();
        }
        if (!bl && this.S.token() == Tokens.LPAREN) {
            do {
                this.S.nextToken();
                if (this.S.token() == Tokens.RPAREN) {
                    this.syntaxError(this.S.pos(), "in.empty.quant");
                    break;
                }
                listBuffer.append(this.quantifierExpression());
            } while (this.S.token() == Tokens.COMMA);
            this.accept(Tokens.RPAREN);
        }
        if (this.S.token() == Tokens.SEND) {
            this.S.nextToken();
            Tree tree2 = this.expression();
            Tree tree3 = null;
            if (this.S.token() == Tokens.HANDLER) {
                this.S.nextToken();
                tree3 = this.expression();
                this.accept(Tokens.COLON);
            }
            if (this.S.token() == Tokens.LBRACE) {
                block = this.block();
            } else {
                this.accept(Tokens.SEMI);
            }
            coArm = tree3 == null && tree != null ? this.F.at(n).CoSend(tree2, listBuffer.toList(), tree, block, l, l2) : this.F.at(n).CoSend(tree2, listBuffer.toList(), tree3, block, l, l2);
        } else {
            if (this.S.token() == Tokens.JRCALL) {
                this.S.nextToken();
            }
            Tree tree4 = this.expression();
            Tree tree5 = null;
            if (this.S.token() == Tokens.HANDLER) {
                this.S.nextToken();
                tree5 = this.expression();
                this.accept(Tokens.COLON);
            }
            if (this.S.token() == Tokens.LBRACE) {
                block = this.block();
            } else {
                this.accept(Tokens.SEMI);
            }
            coArm = tree5 == null && tree != null ? this.F.at(n).CoCall(tree4, listBuffer.toList(), tree, block, l, l2) : this.F.at(n).CoCall(tree4, listBuffer.toList(), tree5, block, l, l2);
        }
        if (this.genEndPos) {
            this.endPositions.put(coArm, this.S.endPos());
        }
        return coArm;
    }

    Tree parseInniArm(boolean bl) {
        Tree tree;
        boolean bl2;
        ListBuffer<Tree.Quantifier> listBuffer = new ListBuffer<Tree.Quantifier>();
        List<Tree.VarDef> list = new List<Tree.VarDef>();
        List<Tree> list2 = new List();
        Tree tree2 = null;
        Tree tree3 = null;
        Tree tree4 = null;
        int n = this.S.pos();
        if (this.S.token() == Tokens.LPAREN) {
            do {
                this.S.nextToken();
                if (this.S.token() == Tokens.RPAREN) {
                    this.log.error(this.S.pos(), "in.empty.quant", new Object[0]);
                    break;
                }
                listBuffer.append(this.quantifierExpression());
            } while (this.S.token() == Tokens.COMMA);
            this.accept(Tokens.RPAREN);
        }
        List<Tree.TypeParameter> list3 = this.typeParametersOpt();
        Name name = this.S.name();
        boolean bl3 = bl2 = this.S.token() == Tokens.VOID;
        if (bl2) {
            tree = this.F.at(n).TypeIdent(9);
            this.S.nextToken();
        } else {
            tree = this.type();
        }
        if (this.S.token() == Tokens.LPAREN && tree.tag == 54) {
            if (name != this.names.empty) {
                this.syntaxError(n, "invalid.op.decl.ret.type.req");
            }
        } else {
            Tree tree5;
            int n2 = this.S.pos();
            if (this.S.token() == Tokens.THIS) {
                tree5 = this.F.at(this.S.pos()).Ident(this.names._this);
                this.S.nextToken();
                while (this.S.token() == Tokens.DOT) {
                    int n3 = this.S.pos();
                    this.S.nextToken();
                    tree5 = this.F.at(n2).Select(tree5, this.ident());
                }
                tree2 = tree5;
            } else {
                tree5 = this.F.at(this.S.pos()).Ident(this.ident());
                while (this.S.token() == Tokens.LBRACKET) {
                    this.S.nextToken();
                    this.mode = 1;
                    Tree tree6 = this.term();
                    tree5 = this.F.at(n2).Indexed(tree5, tree6);
                    this.accept(Tokens.RBRACKET);
                }
                while (this.S.token() == Tokens.DOT) {
                    int n4 = this.S.pos();
                    this.S.nextToken();
                    tree5 = this.F.at(n2).Select(tree5, this.ident());
                }
                tree2 = tree5;
            }
            while (this.S.token() == Tokens.LBRACKET) {
                this.S.nextToken();
                this.mode = 1;
                tree5 = this.term();
                tree2 = this.F.at(n2).Indexed(tree2, tree5);
                this.accept(Tokens.RBRACKET);
            }
            if (this.genEndPos) {
                this.endPositions.put(tree2, this.S.endPos());
            }
            this.S.mark();
            if (this.S.token() == Tokens.LPAREN) {
                this.S.nextToken();
                boolean bl4 = false;
                if (this.S.token() != Tokens.RPAREN) {
                    bl4 = true;
                    this.term(3);
                }
                if (bl4 && (this.S.token() == Tokens.COMMA || this.S.token() == Tokens.RPAREN)) {
                    this.S.reset();
                    List<Tree> list4 = null;
                    if (this.S.token() == Tokens.LT) {
                        list4 = this.typeArguments();
                    }
                    List<Tree> list5 = this.arguments();
                    tree2 = this.F.at(n2).Apply(list4, tree2, list5);
                    if (this.genEndPos) {
                        this.endPositions.put(tree2, this.S.endPos());
                    }
                    list = this.formalParameters();
                } else {
                    this.S.reset();
                    list = this.formalParameters();
                }
            } else {
                this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
            }
        }
        if (this.S.token() == Tokens.THROWS) {
            this.S.nextToken();
            list2 = this.qualidentList();
        }
        while (!bl && (this.S.token() == Tokens.ST && tree3 == null || this.S.token() == Tokens.BY && tree4 == null)) {
            if (this.S.token() == Tokens.ST) {
                this.S.nextToken();
                tree3 = this.expression();
                continue;
            }
            if (this.S.token() != Tokens.BY) continue;
            this.S.nextToken();
            tree4 = this.expression();
        }
        Tree tree7 = this.statement();
        Tree.InniArm inniArm = this.F.at(n).InniArm(tree2, listBuffer.toList(), tree, list3, list, list2, tree3, tree4, tree7);
        if (this.genEndPos) {
            this.endPositions.put(inniArm, this.S.endPos());
        }
        return inniArm;
    }

    List<Tree> moreStatementExpressions(int n, Tree tree) {
        ListBuffer<Tree.Exec> listBuffer = new ListBuffer<Tree.Exec>();
        listBuffer.append(this.F.at(n).Exec(this.checkExprStat(tree)));
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            n = this.S.pos();
            Tree tree2 = this.expression();
            listBuffer.append(this.F.at(n).Exec(this.checkExprStat(tree2)));
        }
        return listBuffer.toList();
    }

    List<Tree> forInit() {
        int n = this.S.pos();
        if (this.S.token() == Tokens.FINAL || this.S.token() == Tokens.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.type());
        }
        Tree tree = this.term(3);
        if ((this.lastmode & 2) != 0 && (this.S.token() == Tokens.IDENTIFIER || this.S.token() == Tokens.ASSERT || this.S.token() == Tokens.ENUM)) {
            return this.variableDeclarators(this.modifiersOpt(), tree);
        }
        return this.moreStatementExpressions(n, tree);
    }

    List<Tree> forUpdate() {
        return this.moreStatementExpressions(this.S.pos(), this.expression());
    }

    List<Tree.Annotation> annotationsOpt() {
        if (this.S.token() != Tokens.MONKEYS_AT) {
            return Tree.Annotation.emptyList;
        }
        ListBuffer<Tree.Annotation> listBuffer = new ListBuffer<Tree.Annotation>();
        while (this.S.token() == Tokens.MONKEYS_AT) {
            this.S.nextToken();
            listBuffer.append(this.annotation());
        }
        return listBuffer.toList();
    }

    Tree.Modifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    Tree.Modifiers modifiersOpt(Tree.Modifiers modifiers) {
        long l;
        long l2 = l = modifiers == null ? 0L : modifiers.flags;
        if (this.S.deprecatedFlag()) {
            l = 131072L;
            this.S.resetDeprecatedFlag();
        }
        ListBuffer<Tree.Annotation> listBuffer = new ListBuffer<Tree.Annotation>();
        if (modifiers != null) {
            listBuffer.appendList(modifiers.annotations);
        }
        block19: while (true) {
            long l3;
            switch (this.S.token()) {
                case PRIVATE: {
                    l3 = 2L;
                    break;
                }
                case PROTECTED: {
                    l3 = 4L;
                    break;
                }
                case PUBLIC: {
                    l3 = 1L;
                    break;
                }
                case STATIC: {
                    l3 = 8L;
                    break;
                }
                case TRANSIENT: {
                    l3 = 128L;
                    break;
                }
                case FINAL: {
                    l3 = 16L;
                    break;
                }
                case ABSTRACT: {
                    l3 = 1024L;
                    break;
                }
                case NATIVE: {
                    l3 = 256L;
                    break;
                }
                case VOLATILE: {
                    l3 = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    l3 = 32L;
                    break;
                }
                case STRICTFP: {
                    l3 = 2048L;
                    break;
                }
                case HANDLER: {
                    l3 = 32768L;
                    break;
                }
                case MONKEYS_AT: {
                    l3 = 8192L;
                    break;
                }
                default: {
                    break block19;
                }
            }
            if ((l & l3) != 0L) {
                this.log.error(this.S.pos(), "repeated.modifier", new Object[0]);
            }
            this.S.nextToken();
            if (l3 == 8192L) {
                this.checkAnnotations();
                if (this.S.token() != Tokens.INTERFACE) {
                    listBuffer.append(this.annotation());
                    l3 = 0L;
                }
            }
            l |= l3;
        }
        switch (this.S.token()) {
            case ENUM: {
                l |= 0x4000L;
                break;
            }
            case INTERFACE: {
                l |= 0x200L;
                break;
            }
        }
        return new Tree.Modifiers(l, listBuffer.toList());
    }

    Tree.Annotation annotation() {
        this.checkAnnotations();
        return this.F.Annotation(this.qualident(), this.annotationFieldValuesOpt());
    }

    List<Tree> annotationFieldValuesOpt() {
        return this.S.token() == Tokens.LPAREN ? this.annotationFieldValues() : Tree.emptyList;
    }

    List<Tree> annotationFieldValues() {
        int n = this.S.pos();
        this.accept(Tokens.LPAREN);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() != Tokens.RPAREN) {
            listBuffer.append(this.annotationFieldValue());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                listBuffer.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.RPAREN);
        return listBuffer.toList();
    }

    Tree annotationFieldValue() {
        if (this.S.token() == Tokens.IDENTIFIER) {
            this.mode = 1;
            Tree tree = this.term1();
            if (tree.tag == 54 && this.S.token() == Tokens.EQ) {
                int n = this.S.pos();
                this.accept(Tokens.EQ);
                return this.F.at(n).Assign(tree, this.annotationValue());
            }
            return tree;
        }
        return this.annotationValue();
    }

    Tree annotationValue() {
        switch (this.S.token()) {
            case MONKEYS_AT: {
                this.S.nextToken();
                return this.annotation();
            }
            case LBRACE: {
                int n = this.S.pos();
                this.accept(Tokens.LBRACE);
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                if (this.S.token() != Tokens.RBRACE) {
                    listBuffer.append(this.annotationValue());
                    while (this.S.token() == Tokens.COMMA) {
                        this.S.nextToken();
                        if (this.S.token() == Tokens.RPAREN) break;
                        listBuffer.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.RBRACE);
                return this.F.at(n).NewArray(null, Tree.emptyList, listBuffer.toList());
            }
        }
        this.mode = 1;
        return this.term1();
    }

    List<Tree> variableDeclarators(Tree.Modifiers modifiers, Tree tree) {
        return this.variableDeclaratorsRest(this.S.pos(), modifiers, tree, this.ident(), false, null);
    }

    List<Tree> variableDeclaratorsRest(int n, Tree.Modifiers modifiers, Tree tree, Name name, boolean bl, String string) {
        ListBuffer<Tree.VarDef> listBuffer = new ListBuffer<Tree.VarDef>();
        listBuffer.append(this.variableDeclaratorRest(n, modifiers, tree, name, bl, string));
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            listBuffer.append(this.variableDeclarator(modifiers, tree, bl, string));
        }
        return listBuffer.toList();
    }

    Tree.VarDef variableDeclarator(Tree.Modifiers modifiers, Tree tree, boolean bl, String string) {
        return this.variableDeclaratorRest(this.S.pos(), modifiers, tree, this.ident(), bl, string);
    }

    Tree.VarDef variableDeclaratorRest(int n, Tree.Modifiers modifiers, Tree tree, Name name, boolean bl, String string) {
        tree = this.bracketsOpt(tree);
        Tree tree2 = null;
        if (this.S.token() == Tokens.EQ) {
            this.S.nextToken();
            tree2 = this.variableInitializer();
        } else if (bl) {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.EQ));
        }
        Tree.VarDef varDef = this.F.at(n).VarDef(modifiers, name, tree, tree2);
        if (this.genEndPos) {
            this.endPositions.put(varDef, this.S.prevEndPos());
        }
        this.attach(varDef, string);
        return varDef;
    }

    Tree.VarDef variableDeclaratorId(Tree.Modifiers modifiers, Tree tree) {
        int n = this.S.pos();
        Name name = this.ident();
        if ((modifiers.flags & 0x400000000L) == 0L) {
            tree = this.bracketsOpt(tree);
        }
        return this.F.at(n).VarDef(modifiers, name, tree, null);
    }

    public Tree.TopLevel compilationUnit() {
        int n = this.S.pos();
        Tree tree = null;
        String string = this.S.docComment();
        Tree.Modifiers modifiers = null;
        List<Tree.Annotation> list = Tree.Annotation.emptyList;
        if (this.S.token() == Tokens.MONKEYS_AT) {
            modifiers = this.modifiersOpt();
        }
        if (this.S.token() == Tokens.PACKAGE) {
            if (modifiers != null) {
                this.checkNoMods(modifiers.flags);
                list = modifiers.annotations;
                modifiers = null;
            }
            this.S.nextToken();
            tree = this.qualident();
            this.accept(Tokens.SEMI);
        }
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        while (modifiers == null && this.S.token() == Tokens.IMPORT) {
            listBuffer.append(this.importDeclaration());
        }
        while (modifiers != null || this.S.token() != Tokens.EOF) {
            listBuffer.append(this.typeDeclaration(modifiers));
            modifiers = null;
        }
        Tree.TopLevel topLevel = this.F.at(n).TopLevel(list, tree, listBuffer.toList());
        this.attach(topLevel, string);
        if (this.keepDocComments) {
            topLevel.docComments = this.docComments;
        }
        if (this.genEndPos) {
            topLevel.endPositions = this.endPositions;
        }
        return topLevel;
    }

    Tree importDeclaration() {
        int n = this.S.pos();
        this.S.nextToken();
        boolean bl = false;
        if (this.S.token() == Tokens.STATIC) {
            this.checkStaticImports();
            bl = true;
            this.S.nextToken();
        }
        Tree tree = this.F.at(this.S.pos()).Ident(this.ident());
        do {
            this.accept(Tokens.DOT);
            if (this.S.token() == Tokens.STAR) {
                tree = this.F.at(this.S.pos()).Select(tree, this.names.asterisk);
                this.S.nextToken();
                break;
            }
            tree = this.F.at(this.S.pos()).Select(tree, this.ident());
        } while (this.S.token() == Tokens.DOT);
        this.accept(Tokens.SEMI);
        return this.F.at(n).Import(tree, bl);
    }

    Tree typeDeclaration(Tree.Modifiers modifiers) {
        if (this.S.pos() == this.S.errPos()) {
            this.modifiersOpt();
            while (!(this.S.token() == Tokens.CLASS || this.S.token() == Tokens.INTERFACE || this.allowEnums && this.S.token() == Tokens.ENUM || this.S.token() == Tokens.EOF)) {
                this.S.nextToken();
                this.modifiersOpt();
            }
        }
        int n = this.S.pos();
        if (modifiers == null && this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            return this.F.at(n).Skip();
        }
        String string = this.S.docComment();
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(modifiers), string);
    }

    Tree classOrInterfaceOrEnumDeclaration(Tree.Modifiers modifiers, String string) {
        if (this.S.token() == Tokens.CLASS) {
            return this.classDeclaration(modifiers, string);
        }
        if (this.S.token() == Tokens.INTERFACE) {
            return this.interfaceDeclaration(modifiers, string);
        }
        if (this.allowEnums && this.S.token() == Tokens.ENUM) {
            return this.enumDeclaration(modifiers, string);
        }
        return this.syntaxError("class.or.intf.expected");
    }

    Tree classDeclaration(Tree.Modifiers modifiers, String string) {
        int n = this.S.pos();
        this.accept(Tokens.CLASS);
        Name name = this.ident();
        List<Tree.TypeParameter> list = this.typeParametersOpt();
        Tree tree = null;
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            tree = this.type();
        }
        List<Tree> list2 = Tree.emptyList;
        if (this.S.token() == Tokens.IMPLEMENTS) {
            this.S.nextToken();
            list2 = this.typeList();
        }
        List<Tree> list3 = this.classOrInterfaceBody(name, false);
        Tree.ClassDef classDef = this.F.at(n).ClassDef(modifiers, name, list, tree, list2, list3);
        this.attach(classDef, string);
        return classDef;
    }

    Tree interfaceDeclaration(Tree.Modifiers modifiers, String string) {
        int n = this.S.pos();
        this.accept(Tokens.INTERFACE);
        Name name = this.ident();
        List<Tree.TypeParameter> list = this.typeParametersOpt();
        modifiers.flags |= 0x400L;
        List<Tree> list2 = Tree.emptyList;
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            list2 = this.typeList();
        }
        List<Tree> list3 = this.classOrInterfaceBody(name, true);
        Tree.ClassDef classDef = this.F.at(n).ClassDef(modifiers, name, list, null, list2, list3);
        this.attach(classDef, string);
        return classDef;
    }

    Tree enumDeclaration(Tree.Modifiers modifiers, String string) {
        int n = this.S.pos();
        this.accept(Tokens.ENUM);
        Name name = this.ident();
        List<Tree> list = Tree.emptyList;
        if (this.S.token() == Tokens.IMPLEMENTS) {
            this.S.nextToken();
            list = this.typeList();
        }
        List<Tree> list2 = this.enumBody(name);
        Tree.ClassDef classDef = this.F.at(n).ClassDef(new Tree.Modifiers(modifiers.flags | 0x4000L, modifiers.annotations), name, Tree.TypeParameter.emptyList, null, list, list2);
        this.attach(classDef, string);
        return classDef;
    }

    List<Tree> enumBody(Name name) {
        int n = this.S.pos();
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.SEMI) {
            listBuffer.append(this.enumeratorDeclaration(name));
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Tokens.RBRACE || this.S.token() == Tokens.SEMI) break;
                listBuffer.append(this.enumeratorDeclaration(name));
            }
        }
        if (this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            while (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.EOF) {
                listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, false));
            }
        }
        this.accept(Tokens.RBRACE);
        return listBuffer.toList();
    }

    Tree enumeratorDeclaration(Name name) {
        int n = this.S.pos();
        String string = this.S.docComment();
        List<Tree.Annotation> list = this.annotationsOpt();
        List<Tree> list2 = this.typeArgumentsOpt();
        Name name2 = this.ident();
        List<Tree> list3 = this.S.token() == Tokens.LPAREN ? this.arguments() : Tree.emptyList;
        Tree.ClassDef classDef = this.S.token() != Tokens.LBRACE ? null : this.F.at(this.S.pos()).ClassDef(this.F.Modifiers(16392L), this.names.empty, Tree.TypeParameter.emptyList, null, Tree.emptyList, this.classOrInterfaceBody(this.names.empty, false));
        Tree.NewClass newClass = this.F.at(n).NewClass(null, list2, this.F.Ident(name), list3, classDef);
        Tree.VarDef varDef = this.F.at(n).VarDef(this.F.Modifiers(16409L, list), name2, this.F.Ident(name), newClass);
        this.attach(varDef, string);
        return varDef;
    }

    List<Tree> typeList() {
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        listBuffer.append(this.type());
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            listBuffer.append(this.type());
        }
        return listBuffer.toList();
    }

    List<Tree> classOrInterfaceBody(Name name, boolean bl) {
        int n = this.S.pos();
        this.accept(Tokens.LBRACE);
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        while (this.S.token() != Tokens.RBRACE && this.S.token() != Tokens.EOF) {
            listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, bl));
        }
        this.accept(Tokens.RBRACE);
        return listBuffer.toList();
    }

    List<Tree> classOrInterfaceBodyDeclaration(Name name, boolean bl) {
        Tree tree;
        boolean bl2;
        int n = this.S.pos();
        if (this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            return Tree.emptyList.prepend(this.F.at(n).Block(0L, Tree.emptyList));
        }
        String string = this.S.docComment();
        Tree.Modifiers modifiers = this.modifiersOpt();
        if (this.S.token() == Tokens.CLASS || this.S.token() == Tokens.INTERFACE || this.allowEnums && this.S.token() == Tokens.ENUM) {
            return Tree.emptyList.prepend(this.classOrInterfaceOrEnumDeclaration(modifiers, string));
        }
        if (this.S.token() == Tokens.LBRACE && !bl && (modifiers.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && modifiers.annotations.isEmpty()) {
            return Tree.emptyList.prepend(this.block(modifiers.flags));
        }
        if (this.S.token() == Tokens.OP) {
            Tree tree2;
            boolean bl3;
            this.S.nextToken();
            List<Tree.TypeParameter> list = this.typeParametersOpt();
            Tokens tokens = this.S.token();
            Name name2 = this.S.name();
            n = this.S.pos();
            boolean bl4 = bl3 = this.S.token() == Tokens.VOID;
            if (bl3) {
                tree2 = this.F.at(n).TypeIdent(9);
                this.S.nextToken();
            } else {
                tree2 = this.type();
            }
            if (this.S.token() == Tokens.LPAREN && !bl && tree2.tag == 54) {
                if (bl || name2 != name) {
                    this.log.error(n, "invalid.op.decl.ret.type.req", new Object[0]);
                }
                return Tree.emptyList.prepend(this.opDeclaratorRest(n, modifiers, null, this.names.init, list, bl, true, string, false));
            }
            n = this.S.pos();
            name2 = this.ident();
            if (this.S.token() == Tokens.LPAREN) {
                return Tree.emptyList.prepend(this.opDeclaratorRest(n, modifiers, tree2, name2, list, bl, bl3, string, false));
            }
            if (!bl3 && list.isEmpty()) {
                List<Tree> list2 = this.variableDeclaratorsRest(n, modifiers, tree2, name2, bl, string);
                this.accept(Tokens.SEMI);
                return list2;
            }
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
            return Tree.emptyList;
        }
        if (this.S.token() == Tokens.SEM) {
            this.S.nextToken();
            n = this.S.pos();
            Tree.TypeIdent typeIdent = this.F.at(n).TypeIdent(9);
            List<Tree> list = this.variableDeclarators(modifiers, typeIdent);
            List<Tree> list3 = new List<Tree>();
            List<Tree> list4 = list;
            while (list4.nonEmpty()) {
                if (((Tree.VarDef)list4.head).vartype.tag != 56) {
                    this.syntaxError(((Tree)list4.head).pos, "sem.arraytype.not.allowed");
                }
                Tree.OperationDef operationDef = this.F.at(((Tree)list4.head).pos).OperationDef(modifiers, ((Tree.VarDef)list4.head).name, typeIdent, Tree.TypeParameter.emptyList, new List<Tree.VarDef>(), Tree.emptyList, null, null);
                list3 = list3.append(this.F.at(((Tree)list4.head).pos).SemaphoreDef(modifiers, ((Tree.VarDef)list4.head).name, operationDef, ((Tree.VarDef)list4.head).init));
                list4 = list4.tail;
            }
            this.accept(Tokens.SEMI);
            return list3;
        }
        if (this.S.token() == Tokens.PROCESS) {
            Object object;
            this.S.nextToken();
            n = this.S.pos();
            Name name3 = this.S.name();
            this.accept(Tokens.IDENTIFIER);
            ListBuffer<Tree.Quantifier> listBuffer = new ListBuffer<Tree.Quantifier>();
            if (this.S.token() == Tokens.LPAREN) {
                do {
                    this.S.nextToken();
                    listBuffer.append(this.quantifierExpression());
                } while (this.S.token() == Tokens.COMMA);
                this.accept(Tokens.RPAREN);
            }
            Tree.Block block = this.block();
            Tree.TypeIdent typeIdent = this.F.at(n).TypeIdent(9);
            ListBuffer<Tree.VarDef> listBuffer2 = new ListBuffer<Tree.VarDef>();
            Object object2 = listBuffer.toList();
            while (((List)object2).nonEmpty()) {
                object = ((Tree.Quantifier)((List)object2).head).init;
                while (((List)object).nonEmpty()) {
                    if (((Tree)((List)object).head).tag == 10) {
                        listBuffer2.append(this.F.at(((Tree)((List)object).head).pos).VarDef(this.F.at(((Tree)((List)object).head).pos).Modifiers(((Tree.VarDef)((List)object).head).mods.flags | 0x10L | 0x200000000L), ((Tree.VarDef)((List)object).head).name, ((Tree.VarDef)((List)object).head).vartype, null));
                    }
                    object = ((List)object).tail;
                }
                object2 = ((List)object2).tail;
            }
            object2 = this.F.at(n).OperationDef(modifiers, name3, typeIdent, Tree.TypeParameter.emptyList, listBuffer2.toList(), Tree.emptyList, null, null);
            object = this.F.at(n).MethodDef(modifiers, name3, typeIdent, Tree.TypeParameter.emptyList, listBuffer2.toList(), Tree.emptyList, block, null);
            return Tree.emptyList.prepend(this.F.at(n).ProcessDef(name3, listBuffer.toList(), (Tree.OperationDef)object2, (Tree.MethodDef)object));
        }
        List<Tree.TypeParameter> list = this.typeParametersOpt();
        Tokens tokens = this.S.token();
        Name name4 = this.S.name();
        n = this.S.pos();
        boolean bl5 = bl2 = this.S.token() == Tokens.VOID;
        if (bl2) {
            tree = this.F.at(n).TypeIdent(9);
            this.S.nextToken();
        } else {
            tree = this.type();
        }
        if (this.S.token() == Tokens.LPAREN && !bl && tree.tag == 54) {
            if (bl || name4 != name) {
                this.log.error(n, "invalid.meth.decl.ret.type.req", new Object[0]);
            }
            return Tree.emptyList.prepend(this.methodDeclaratorRest(n, modifiers, null, this.names.init, list, bl, true, string));
        }
        n = this.S.pos();
        name4 = this.ident();
        if (this.S.token() == Tokens.LPAREN) {
            return Tree.emptyList.prepend(this.methodDeclaratorRest(n, modifiers, tree, name4, list, bl, bl2, string));
        }
        if (!bl2 && list.isEmpty()) {
            List<Tree> list5 = this.variableDeclaratorsRest(n, modifiers, tree, name4, bl, string);
            this.accept(Tokens.SEMI);
            return list5;
        }
        this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.LPAREN));
        return Tree.emptyList;
    }

    Tree.Quantifier quantifierExpression() {
        boolean bl;
        List<Tree> list;
        int n = this.S.pos();
        Tree tree = null;
        Tree tree2 = null;
        Tree tree3 = null;
        List<Tree> list2 = Tree.emptyList;
        this.accept(Tokens.LPAREN);
        List<Tree> list3 = list = this.S.token() == Tokens.SEMI ? Tree.emptyList : this.forInit();
        while (list3.nonEmpty()) {
            if (((Tree)list3.head).tag != 10) {
                this.syntaxError(((Tree)list3.head).pos, "quant.var.declaration.required");
            }
            list3 = list3.tail;
        }
        if (list.length() == 1 && ((Tree)list.head).tag == 10 && ((Tree.VarDef)list.head).init == null && this.S.token() == Tokens.COLON) {
            bl = true;
            this.checkForeach();
            this.accept(Tokens.COLON);
            tree2 = this.expression();
        } else {
            bl = false;
            this.accept(Tokens.SEMI);
            tree = this.S.token() == Tokens.SEMI ? null : this.expression();
            this.accept(Tokens.SEMI);
            List<Tree> list4 = list2 = this.S.token() == Tokens.RPAREN ? Tree.emptyList : this.forUpdate();
        }
        if (this.S.token() == Tokens.SEMI) {
            this.S.nextToken();
            if (this.S.token() != Tokens.RPAREN) {
                tree3 = this.expression();
            }
        }
        this.accept(Tokens.RPAREN);
        if (bl) {
            return this.F.at(n).Quantifier(list, tree2, tree3);
        }
        return this.F.at(n).Quantifier(list, tree, list2, tree3);
    }

    Tree opDeclaratorRest(int n, Tree.Modifiers modifiers, Tree tree, Name name, List<Tree.TypeParameter> list, boolean bl, boolean bl2, String string, boolean bl3) {
        Tree tree2;
        List<Tree.VarDef> list2 = this.capOrOpDeclFormalParameters();
        if (!bl2) {
            tree = this.bracketsOpt(tree);
        }
        List<Tree> list3 = Tree.emptyList;
        if (this.S.token() == Tokens.THROWS) {
            this.S.nextToken();
            list3 = this.qualidentList();
        }
        Tree.Block block = null;
        if (this.S.token() == Tokens.LBRACE) {
            if (bl3) {
                this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Tokens.SEMI));
            } else {
                block = this.block();
            }
            tree2 = null;
        } else {
            if (this.S.token() == Tokens.DEFAULT) {
                this.accept(Tokens.DEFAULT);
                tree2 = this.annotationValue();
            } else {
                tree2 = null;
            }
            this.accept(Tokens.SEMI);
            block = null;
        }
        Tree.OperationDef operationDef = this.F.at(n).OperationDef(modifiers, name, tree, list, list2, list3, block, tree2);
        this.attach(operationDef, string);
        return operationDef;
    }

    List<Tree.VarDef> capOrOpDeclFormalParameters() {
        ListBuffer<Tree.VarDef> listBuffer = new ListBuffer<Tree.VarDef>();
        Tree.VarDef varDef = null;
        this.accept(Tokens.LPAREN);
        if (this.S.token() != Tokens.RPAREN) {
            varDef = this.capOrOpDeclFormalParameter();
            listBuffer.append(varDef);
            while ((varDef.mods.flags & 0x400000000L) == 0L && this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                varDef = this.capOrOpDeclFormalParameter();
                listBuffer.append(varDef);
            }
        }
        this.accept(Tokens.RPAREN);
        return listBuffer.toList();
    }

    Tree.VarDef capOrOpDeclFormalParameter() {
        Tree.Modifiers modifiers = this.optFinal(0x200000000L);
        Tree tree = this.type();
        if (this.S.token() == Tokens.ELLIPSIS) {
            this.checkVarargs();
            modifiers.flags |= 0x400000000L;
            tree = this.F.at(this.S.pos()).TypeArray(tree);
            this.S.nextToken();
        }
        int n = this.S.pos();
        Name name = null;
        if (this.S.token() != Tokens.COMMA && this.S.token() != Tokens.RPAREN) {
            name = this.ident();
        }
        if ((modifiers.flags & 0x400000000L) == 0L) {
            tree = this.bracketsOpt(tree);
        }
        return this.F.at(n).VarDef(modifiers, name, tree, null);
    }

    Tree methodDeclaratorRest(int n, Tree.Modifiers modifiers, Tree tree, Name name, List<Tree.TypeParameter> list, boolean bl, boolean bl2, String string) {
        Tree tree2;
        Tree.Block block;
        List<Tree.VarDef> list2 = this.formalParameters();
        if (!bl2) {
            tree = this.bracketsOpt(tree);
        }
        List<Tree> list3 = Tree.emptyList;
        if (this.S.token() == Tokens.THROWS) {
            this.S.nextToken();
            list3 = this.qualidentList();
        }
        if (this.S.token() == Tokens.LBRACE) {
            block = this.block();
            tree2 = null;
        } else {
            if (this.S.token() == Tokens.DEFAULT) {
                this.accept(Tokens.DEFAULT);
                tree2 = this.annotationValue();
            } else {
                tree2 = null;
            }
            this.accept(Tokens.SEMI);
            block = null;
        }
        Tree.MethodDef methodDef = this.F.at(n).MethodDef(modifiers, name, tree, list, list2, list3, block, tree2);
        this.attach(methodDef, string);
        return methodDef;
    }

    List<Tree> qualidentList() {
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        listBuffer.append(this.qualident());
        while (this.S.token() == Tokens.COMMA) {
            this.S.nextToken();
            listBuffer.append(this.qualident());
        }
        return listBuffer.toList();
    }

    List<Tree.TypeParameter> typeParametersOpt() {
        if (this.S.token() == Tokens.LT) {
            this.checkGenerics();
            ListBuffer<Tree.TypeParameter> listBuffer = new ListBuffer<Tree.TypeParameter>();
            this.S.nextToken();
            listBuffer.append(this.typeParameter());
            while (this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                listBuffer.append(this.typeParameter());
            }
            this.accept(Tokens.GT);
            return listBuffer.toList();
        }
        return Tree.TypeParameter.emptyList;
    }

    Tree.TypeParameter typeParameter() {
        int n = this.S.pos();
        Name name = this.ident();
        ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
        if (this.S.token() == Tokens.EXTENDS) {
            this.S.nextToken();
            listBuffer.append(this.type());
            while (this.S.token() == Tokens.AMP) {
                this.S.nextToken();
                listBuffer.append(this.type());
            }
        }
        return this.F.at(n).TypeParameter(name, listBuffer.toList());
    }

    List<Tree.VarDef> formalParameters() {
        ListBuffer<Tree.VarDef> listBuffer = new ListBuffer<Tree.VarDef>();
        Tree.VarDef varDef = null;
        this.accept(Tokens.LPAREN);
        if (this.S.token() != Tokens.RPAREN) {
            varDef = this.formalParameter();
            listBuffer.append(varDef);
            while ((varDef.mods.flags & 0x400000000L) == 0L && this.S.token() == Tokens.COMMA) {
                this.S.nextToken();
                varDef = this.formalParameter();
                listBuffer.append(varDef);
            }
        }
        this.accept(Tokens.RPAREN);
        return listBuffer.toList();
    }

    Tree.Modifiers optFinal(long l) {
        Tree.Modifiers modifiers = this.modifiersOpt();
        this.checkNoMods(modifiers.flags & 0xFFFFFFFFFFFDFFEFL);
        modifiers.flags |= l;
        return modifiers;
    }

    Tree.VarDef formalParameter() {
        Tree.Modifiers modifiers = this.optFinal(0x200000000L);
        Tree tree = this.type();
        if (this.S.token() == Tokens.ELLIPSIS) {
            this.checkVarargs();
            modifiers.flags |= 0x400000000L;
            tree = this.F.at(this.S.pos()).TypeArray(tree);
            this.S.nextToken();
        }
        return this.variableDeclaratorId(modifiers, tree);
    }

    private List<Tree> makeList(Tree tree, Tree tree2) {
        return new List<Tree>(tree, new List<Tree>(tree2, Tree.emptyList));
    }

    private List<Tree> makeList(Tree tree) {
        return new List<Tree>(tree, Tree.emptyList);
    }

    Tree checkExprStat(Tree tree) {
        switch (tree.tag) {
            case 45: 
            case 46: 
            case 49: 
            case 67: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 96: 
            case 97: 
            case 98: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return tree;
            }
        }
        this.log.error(tree.pos, "not.stmt", new Object[0]);
        return errorTree;
    }

    static int prec(Tokens tokens) {
        int n = Parser.optag(tokens);
        return n >= 0 ? TreeInfo.opPrec(n) : -1;
    }

    static int optag(Tokens tokens) {
        switch (tokens) {
            case BARBAR: {
                return 77;
            }
            case AMPAMP: {
                return 78;
            }
            case BAR: {
                return 79;
            }
            case BAREQ: {
                return 96;
            }
            case CARET: {
                return 80;
            }
            case CARETEQ: {
                return 97;
            }
            case AMP: {
                return 81;
            }
            case AMPEQ: {
                return 98;
            }
            case EQEQ: {
                return 82;
            }
            case BANGEQ: {
                return 83;
            }
            case LT: {
                return 84;
            }
            case GT: {
                return 85;
            }
            case LTEQ: {
                return 86;
            }
            case GTEQ: {
                return 87;
            }
            case LTLT: {
                return 88;
            }
            case LTLTEQ: {
                return 105;
            }
            case GTGT: {
                return 89;
            }
            case GTGTEQ: {
                return 106;
            }
            case GTGTGT: {
                return 90;
            }
            case GTGTGTEQ: {
                return 107;
            }
            case PLUS: {
                return 91;
            }
            case PLUSEQ: {
                return 108;
            }
            case SUB: {
                return 92;
            }
            case SUBEQ: {
                return 109;
            }
            case STAR: {
                return 93;
            }
            case STAREQ: {
                return 110;
            }
            case SLASH: {
                return 94;
            }
            case SLASHEQ: {
                return 111;
            }
            case PERCENT: {
                return 95;
            }
            case PERCENTEQ: {
                return 112;
            }
            case INSTANCEOF: {
                return 51;
            }
        }
        return -1;
    }

    static int unoptag(Tokens tokens) {
        switch (tokens) {
            case PLUS: {
                return 68;
            }
            case SUB: {
                return 69;
            }
            case BANG: {
                return 70;
            }
            case TILDE: {
                return 71;
            }
            case PLUSPLUS: {
                return 72;
            }
            case SUBSUB: {
                return 73;
            }
        }
        return -1;
    }

    static int typetag(Tokens tokens) {
        switch (tokens) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BOOLEAN: {
                return 8;
            }
        }
        return -1;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.log.error(this.S.pos(), "generics.not.supported.in.source", this.source.name);
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.log.error(this.S.pos(), "varargs.not.supported.in.source", this.source.name);
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.log.error(this.S.pos(), "foreach.not.supported.in.source", this.source.name);
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.log.error(this.S.pos(), "static.import.not.supported.in.source", this.source.name);
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.log.error(this.S.pos(), "annotations.not.supported.in.source", this.source.name);
            this.allowAnnotations = true;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> parserFactoryKey = new Context.Key();
        final TreeMaker F;
        final Log log;
        final Keywords keywords;
        final Source source;
        final Name.Table names;
        final Options options;

        public static Factory instance(Context context) {
            Factory factory = context.get(parserFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            context.put(parserFactoryKey, this);
            this.F = TreeMaker.instance(context);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.keywords = Keywords.instance(context);
            this.source = Source.instance(context);
            this.options = Options.instance(context);
        }

        public Parser newParser(Scanner scanner, boolean bl) {
            return new Parser(this, scanner, bl);
        }
    }
}

