/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdavis.jr.trans.sun.tools.javac.tree;

import edu.ucdavis.jr.trans.sun.tools.javac.tree.Tree;
import edu.ucdavis.jr.trans.sun.tools.javac.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeScanner
extends Tree.Visitor {
    public void scan(Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    public void scan(List<? extends Tree> list) {
        if (list != null) {
            List<Tree> list2 = list;
            while (list2.nonEmpty()) {
                this.scan((Tree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    @Override
    public void visitTopLevel(Tree.TopLevel topLevel) {
        this.scan(topLevel.pid);
        this.scan(topLevel.defs);
    }

    @Override
    public void visitFake(Tree.Fake fake) {
    }

    @Override
    public void visitImport(Tree.Import import_) {
        this.scan(import_.qualid);
    }

    @Override
    public void visitClassDef(Tree.ClassDef classDef) {
        this.scan(classDef.mods);
        this.scan(classDef.typarams);
        this.scan(classDef.extending);
        this.scan(classDef.implementing);
        this.scan(classDef.defs);
    }

    @Override
    public void visitMethodDef(Tree.MethodDef methodDef) {
        this.scan(methodDef.mods);
        this.scan(methodDef.restype);
        this.scan(methodDef.typarams);
        this.scan(methodDef.params);
        this.scan(methodDef.thrown);
        this.scan(methodDef.body);
    }

    @Override
    public void visitOperationDef(Tree.OperationDef operationDef) {
        this.scan(operationDef.mods);
        this.scan(operationDef.restype);
        this.scan(operationDef.typarams);
        this.scan(operationDef.params);
        this.scan(operationDef.thrown);
        this.scan(operationDef.body);
    }

    @Override
    public void visitSemaphoreDef(Tree.SemaphoreDef semaphoreDef) {
        this.scan(semaphoreDef.mods);
        this.scan(semaphoreDef.opDecl);
        this.scan(semaphoreDef.init);
    }

    @Override
    public void visitProcessDef(Tree.ProcessDef processDef) {
        this.scan(processDef.opDecl);
        this.scan(processDef.opMethBody);
    }

    @Override
    public void visitVarDef(Tree.VarDef varDef) {
        this.scan(varDef.mods);
        this.scan(varDef.vartype);
        this.scan(varDef.init);
    }

    @Override
    public void visitSkip(Tree.Skip skip) {
    }

    @Override
    public void visitBlock(Tree.Block block) {
        this.scan(block.stats);
    }

    @Override
    public void visitDoLoop(Tree.DoLoop doLoop) {
        this.scan(doLoop.body);
        this.scan(doLoop.cond);
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        this.scan(whileLoop.cond);
        this.scan(whileLoop.body);
    }

    @Override
    public void visitForLoop(Tree.ForLoop forLoop) {
        this.scan(forLoop.init);
        this.scan(forLoop.cond);
        this.scan(forLoop.step);
        this.scan(forLoop.body);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop foreachLoop) {
        this.scan(foreachLoop.var);
        this.scan(foreachLoop.expr);
        this.scan(foreachLoop.body);
    }

    @Override
    public void visitLabelled(Tree.Labelled labelled) {
        this.scan(labelled.body);
    }

    @Override
    public void visitSwitch(Tree.Switch switch_) {
        this.scan(switch_.selector);
        this.scan(switch_.cases);
    }

    @Override
    public void visitCase(Tree.Case case_) {
        this.scan(case_.pat);
        this.scan(case_.stats);
    }

    @Override
    public void visitSynchronized(Tree.Synchronized synchronized_) {
        this.scan(synchronized_.lock);
        this.scan(synchronized_.body);
    }

    @Override
    public void visitTry(Tree.Try try_) {
        this.scan(try_.body);
        this.scan(try_.catchers);
        this.scan(try_.finalizer);
    }

    @Override
    public void visitCatch(Tree.Catch catch_) {
        this.scan(catch_.param);
        this.scan(catch_.body);
    }

    @Override
    public void visitConditional(Tree.Conditional conditional) {
        this.scan(conditional.cond);
        this.scan(conditional.truepart);
        this.scan(conditional.falsepart);
    }

    @Override
    public void visitIf(Tree.If if_) {
        this.scan(if_.cond);
        this.scan(if_.thenpart);
        this.scan(if_.elsepart);
    }

    @Override
    public void visitExec(Tree.Exec exec) {
        this.scan(exec.expr);
    }

    @Override
    public void visitBreak(Tree.Break break_) {
    }

    @Override
    public void visitContinue(Tree.Continue continue_) {
    }

    @Override
    public void visitReturn(Tree.Return return_) {
        this.scan(return_.expr);
    }

    @Override
    public void visitThrow(Tree.Throw throw_) {
        this.scan(throw_.expr);
    }

    @Override
    public void visitAssert(Tree.Assert assert_) {
        this.scan(assert_.cond);
        this.scan(assert_.detail);
    }

    @Override
    public void visitJRCall(Tree.JRCall jRCall) {
        this.scan(jRCall.expr);
    }

    @Override
    public void visitSend(Tree.Send send) {
        this.scan(send.expr);
        this.scan(send.handlerExpr);
    }

    @Override
    public void visitForward(Tree.Forward forward) {
        this.scan(forward.expr);
        this.scan(forward.handlerExpr);
    }

    @Override
    public void visitReply(Tree.Reply reply) {
        this.scan(reply.expr);
        this.scan(reply.handlerExpr);
    }

    @Override
    public void visitSemP(Tree.SemP semP) {
        this.scan(semP.expr);
    }

    @Override
    public void visitSemV(Tree.SemV semV) {
        this.scan(semV.expr);
    }

    @Override
    public void visitReceive(Tree.Receive receive) {
        this.scan(receive.expr);
    }

    @Override
    public void visitInni(Tree.Inni inni) {
        this.scan(inni.arms);
        if (inni.elseafterArm != null) {
            this.scan(inni.elseafterArm);
        }
        if (inni.elseStmt != null) {
            this.scan(inni.elseStmt);
        }
    }

    @Override
    public void visitInniArm(Tree.InniArm inniArm) {
        this.scan(inniArm.expr);
        this.scan(inniArm.restype);
        this.scan(inniArm.typarams);
        this.scan(inniArm.params);
        this.scan(inniArm.thrown);
        this.scan(inniArm.stExpr);
        this.scan(inniArm.byExpr);
        this.scan(inniArm.body);
    }

    @Override
    public void visitView(Tree.View view) {
        this.scan(view.expr);
        this.scan(view.arms);
        if (view.elseStmt != null) {
            this.scan(view.elseStmt);
        }
    }

    @Override
    public void visitViewArm(Tree.ViewArm viewArm) {
        this.scan(viewArm.params);
        this.scan(viewArm.body);
    }

    @Override
    public void visitCo(Tree.Co co) {
        this.scan(co.arms);
    }

    @Override
    public void visitCoSend(Tree.CoSend coSend) {
        this.scan(coSend.expr);
        if (coSend.handlerExpr != null) {
            this.scan(coSend.handlerExpr);
        }
        if (coSend.ppc != null) {
            this.scan(coSend.ppc);
        }
    }

    @Override
    public void visitCoCall(Tree.CoCall coCall) {
        this.scan(coCall.expr);
        if (coCall.handlerExpr != null) {
            this.scan(coCall.handlerExpr);
        }
        if (coCall.ppc != null) {
            this.scan(coCall.ppc);
        }
    }

    @Override
    public void visitApply(Tree.Apply apply) {
        this.scan(apply.meth);
        this.scan(apply.args);
    }

    @Override
    public void visitNewClass(Tree.NewClass newClass) {
        this.scan(newClass.encl);
        this.scan(newClass.clazz);
        this.scan(newClass.args);
        this.scan(newClass.def);
    }

    @Override
    public void visitNewArray(Tree.NewArray newArray) {
        this.scan(newArray.elemtype);
        this.scan(newArray.dims);
        this.scan(newArray.elems);
    }

    @Override
    public void visitParens(Tree.Parens parens) {
        this.scan(parens.expr);
    }

    @Override
    public void visitAssign(Tree.Assign assign) {
        this.scan(assign.lhs);
        this.scan(assign.rhs);
    }

    @Override
    public void visitAssignop(Tree.Assignop assignop) {
        this.scan(assignop.lhs);
        this.scan(assignop.rhs);
    }

    @Override
    public void visitUnary(Tree.Unary unary) {
        this.scan(unary.arg);
    }

    @Override
    public void visitBinary(Tree.Binary binary) {
        this.scan(binary.lhs);
        this.scan(binary.rhs);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast typeCast) {
        this.scan(typeCast.clazz);
        this.scan(typeCast.expr);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest typeTest) {
        this.scan(typeTest.expr);
        this.scan(typeTest.clazz);
    }

    @Override
    public void visitIndexed(Tree.Indexed indexed) {
        this.scan(indexed.indexed);
        this.scan(indexed.index);
    }

    @Override
    public void visitSelect(Tree.Select select) {
        this.scan(select.selected);
    }

    @Override
    public void visitIdent(Tree.Ident ident) {
    }

    @Override
    public void visitLiteral(Tree.Literal literal) {
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent typeIdent) {
    }

    @Override
    public void visitTypeCap(Tree.TypeCap typeCap) {
    }

    @Override
    public void visitTypeRemote(Tree.TypeRemote typeRemote) {
        this.scan(typeRemote.clazz);
    }

    @Override
    public void visitTypeVm(Tree.TypeVm typeVm) {
    }

    @Override
    public void visitTypeArray(Tree.TypeArray typeArray) {
        this.scan(typeArray.elemtype);
    }

    @Override
    public void visitTypeApply(Tree.TypeApply typeApply) {
        this.scan(typeApply.clazz);
        this.scan(typeApply.arguments);
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter typeParameter) {
        this.scan(typeParameter.bounds);
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument typeArgument) {
        if (typeArgument.inner != null) {
            this.scan(typeArgument.inner);
        }
    }

    @Override
    public void visitModifiers(Tree.Modifiers modifiers) {
        this.scan(modifiers.annotations);
    }

    @Override
    public void visitAnnotation(Tree.Annotation annotation) {
        this.scan(annotation.annotationType);
        this.scan(annotation.args);
    }

    @Override
    public void visitErroneous(Tree.Erroneous erroneous) {
    }

    @Override
    public void visitLetExpr(Tree.LetExpr letExpr) {
        this.scan(letExpr.defs);
        this.scan(letExpr.expr);
    }

    @Override
    public void visitTree(Tree tree) {
        assert (false);
    }
}

