/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.FastCacheTable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class CacheTable {
    private static final int kGrowthRate = 10;
    private static final int kMaxCacheSize = 30;
    private static final int kKeysPos = 0;
    private static final int kValsPos = 1;
    private static final Object[][] cache = new Object[31][2];
    private static int cacheIndex = -1;
    private Object[] keys = null;
    private int[] vals = null;
    private int index = 0;
    private int lastFoundIndex = 0;
    private FastCacheTable hashedTable = null;

    private CacheTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            Object[][] objectArray = cache;
            synchronized (cache) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    --cacheIndex;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.keys = new Object[10];
                this.vals = new int[10];
                return;
            }
        }
        if (this.keys.length != this.index) return;
        Object[] objectArray = new Object[this.index + 10];
        int[] nArray = new int[this.index + 10];
        System.arraycopy(this.keys, 0, objectArray, 0, this.index);
        System.arraycopy(this.vals, 0, nArray, 0, this.index);
        Object[][] objectArray2 = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            this.keys = objectArray;
            this.vals = nArray;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (this.hashedTable != null) {
            this.hashedTable.done();
            return;
        }
        Object[][] objectArray = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keys = null;
            this.vals = null;
            return;
        }
    }

    public final boolean containsOrderedVal(int n2) {
        int n3 = 0;
        int n4 = this.index;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            int n6 = this.vals[n5];
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n4 = n5 - 1;
                continue;
            }
            this.lastFoundIndex = n5;
            return true;
        }
        return false;
    }

    public final boolean containsVal(int n2) {
        int n3;
        for (n3 = this.lastFoundIndex; n3 < this.index; ++n3) {
            if (this.vals[n3] != n2) continue;
            this.lastFoundIndex = n3;
            return true;
        }
        for (n3 = 0; n3 < this.lastFoundIndex; ++n3) {
            if (this.vals[n3] != n2) continue;
            this.lastFoundIndex = n3;
            return true;
        }
        return false;
    }

    public CacheTable(boolean bl2) {
        if (bl2) {
            this.hashedTable = new FastCacheTable();
        }
    }

    public final Object getKey(int n2) {
        int n3;
        for (n3 = this.lastFoundIndex; n3 < this.index; ++n3) {
            if (this.vals[n3] != n2) continue;
            this.lastFoundIndex = n3;
            return this.keys[n3];
        }
        for (n3 = 0; n3 < this.lastFoundIndex; ++n3) {
            if (this.vals[n3] != n2) continue;
            this.lastFoundIndex = n3;
            return this.keys[n3];
        }
        return null;
    }

    public final int getVal(Object object) {
        int n2;
        if (this.hashedTable != null) {
            return this.hashedTable.getVal(object);
        }
        for (n2 = this.lastFoundIndex; n2 < this.index; ++n2) {
            if (this.keys[n2] != object) continue;
            this.lastFoundIndex = n2;
            return this.vals[n2];
        }
        for (n2 = 0; n2 < this.lastFoundIndex; ++n2) {
            if (this.keys[n2] != object) continue;
            this.lastFoundIndex = n2;
            return this.vals[n2];
        }
        return -1;
    }

    public final boolean containsKey(Object object) {
        int n2;
        if (this.hashedTable != null) {
            return this.hashedTable.containsKey(object);
        }
        for (n2 = this.lastFoundIndex; n2 < this.index; ++n2) {
            if (this.keys[n2] != object) continue;
            this.lastFoundIndex = n2;
            return true;
        }
        for (n2 = 0; n2 < this.lastFoundIndex; ++n2) {
            if (this.keys[n2] != object) continue;
            this.lastFoundIndex = n2;
            return true;
        }
        return false;
    }

    public final void put(Object object, int n2) {
        if (this.hashedTable != null) {
            this.hashedTable.put(object, n2);
            return;
        }
        if (object == null) {
            return;
        }
        if (!this.containsKey(object)) {
            this.checkForGrowth();
            this.keys[this.index] = object;
            this.vals[this.index] = n2;
            ++this.index;
        } else {
            int n3 = this.getVal(object);
            if (n3 != n2) {
                throw new INTERNAL(1398079695, CompletionStatus.COMPLETED_NO);
            }
        }
    }
}

