/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.comboBox);
        if (actionMap != null) {
            actionMap.put("selectPrevious", new UpAction());
            actionMap.put("selectNext", new DownAction());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (XPStyle.getXP() != null && WindowsComboBoxUI.this.arrowButton != null) {
                    Dimension dimension = container.getSize();
                    Insets insets = WindowsComboBoxUI.this.getInsets();
                    int n2 = ((WindowsComboBoxUI)WindowsComboBoxUI.this).arrowButton.getPreferredSize().width;
                    WindowsComboBoxUI.this.arrowButton.setBounds(dimension.width - insets.right - n2, insets.top, n2, dimension.height - insets.top - insets.bottom);
                }
            }
        };
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor();
    }

    protected JButton createArrowButton() {
        if (XPStyle.getXP() != null) {
            return new XPComboBoxButton();
        }
        return super.createArrowButton();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (jComboBox.isEditable() && !windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.setPopupVisible(jComboBox, true);
                } else {
                    windowsComboBoxUI.selectNextPossibleValue();
                }
            }
        }
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox.isEnabled()) {
                WindowsComboBoxUI windowsComboBoxUI = (WindowsComboBoxUI)jComboBox.getUI();
                if (jComboBox.isEditable() && !windowsComboBoxUI.isPopupVisible(jComboBox)) {
                    windowsComboBoxUI.setPopupVisible(jComboBox, true);
                } else {
                    windowsComboBoxUI.selectPreviousPossibleValue();
                }
            }
        }
    }

    public static class WindowsComboBoxEditor
    extends BasicComboBoxEditor.UIResource {
        public void setItem(Object object) {
            super.setItem(object);
            this.editor.selectAll();
        }
    }

    protected class WindowsComboPopup
    extends BasicComboPopup {
        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }
        }
    }

    private static class XPComboBoxButton
    extends XPStyle.GlyphButton {
        public XPComboBoxButton() {
            super("combobox.dropdownbutton");
            this.setRequestFocusEnabled(false);
        }

        public Dimension getPreferredSize() {
            return new Dimension(17, 20);
        }
    }
}

