/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Platform;
import com.sun.media.sound.SimpleInputDeviceProvider;
import com.sun.media.sound.Toolkit;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.TargetDataLine;

class SimpleInputDevice
extends AbstractMixer {
    private AudioFormat format = null;
    private int bufferSize = -1;
    private static final int DEFAULT_BUFFER_TIME = 500;
    private JSSecurity jsSecurity = JSSecurityManager.getJSSecurity();
    private Port[] ports;
    private boolean implStarted = false;
    static /* synthetic */ Class class$javax$sound$sampled$Port;

    private native int nGetBufferSizeInFrames();

    private native int nGetNumPorts();

    private native long nGetPosition();

    private void callbackCaptureStreamDestroy() {
    }

    public void implClose() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        this.nClose();
        this.implStarted = false;
    }

    public void implOpen() throws LineUnavailableException {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (this.bufferSize < 0) {
            this.bufferSize = 0;
        }
        int n2 = 8;
        int n3 = 0;
        if (this.format.getEncoding() == AudioFormat.Encoding.ULAW) {
            n3 = 1;
        } else if (this.format.getEncoding() == AudioFormat.Encoding.ALAW) {
            n3 = 2;
        }
        this.nOpen(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), n3, (int)this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), this.bufferSize / (this.format.getFrameSize() * n2));
        this.bufferSize = this.nGetBufferSizeInFrames() * this.format.getFrameSize() * n2;
    }

    protected void implStart() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        if (!this.implStarted) {
            this.nStart();
            this.implStarted = true;
        } else {
            this.nResume();
        }
    }

    protected void implStop() {
        if (this.jsSecurity != null) {
            this.jsSecurity.checkRecordPermission();
        }
        this.nPause();
    }

    private native void nClose();

    private native void nDrain();

    private native void nFlush();

    private native void nPause();

    private native void nResume();

    private native void nStart();

    private native void nOpen(int var1, int var2, float var3, int var4, int var5, int var6) throws LineUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackStreamPutData(byte[] byArray, int n2) {
        int n3 = n2 * this.format.getFrameSize();
        InputDeviceDataLine inputDeviceDataLine = null;
        Vector vector = null;
        Vector vector2 = this.targetLines;
        synchronized (vector2) {
            if (this.targetLines.size() == 1) {
                inputDeviceDataLine = (InputDeviceDataLine)this.targetLines.elementAt(0);
            } else {
                vector = (Vector)this.targetLines.clone();
            }
        }
        if (inputDeviceDataLine != null) {
            inputDeviceDataLine.fillBuffer(byArray, n3);
        } else {
            for (int i2 = 0; i2 < this.targetLines.size(); ++i2) {
                inputDeviceDataLine = (InputDeviceDataLine)this.targetLines.elementAt(i2);
                inputDeviceDataLine.fillBuffer(byArray, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleInputDevice(SimpleInputDeviceProvider.InputDeviceInfo inputDeviceInfo) {
        super(inputDeviceInfo, null, null, null);
        AudioFormat[] audioFormatArray;
        Platform.initialize();
        Vector vector = new Vector();
        this.nGetFormats(((SimpleInputDeviceProvider.InputDeviceInfo)this.getMixerInfo()).getIndex(), vector, AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED, AudioFormat.Encoding.ULAW, AudioFormat.Encoding.ALAW);
        Vector vector2 = vector;
        synchronized (vector2) {
            audioFormatArray = new AudioFormat[vector.size()];
            for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
                audioFormatArray[i2] = (AudioFormat)vector.elementAt(i2);
            }
        }
        int n2 = this.nGetNumPorts();
        this.sourceLineInfo = new Port.Info[n2];
        this.ports = new Port[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            String string = this.nGetPortName(i3);
            this.sourceLineInfo[i3] = this.getPortInfo(string);
            this.ports[i3] = new InputDevicePort((Port.Info)this.sourceLineInfo[i3], this, new Control[0]);
        }
        this.targetLineInfo = new DataLine.Info[1];
        this.targetLineInfo[0] = new DataLine.Info(TargetDataLine.class, audioFormatArray, 0, -1);
        this.format = vector.size() > 0 ? (AudioFormat)vector.lastElement() : null;
    }

    private native String nGetPortName(int var1);

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof Port.Info) {
            return 1;
        }
        if (info2 instanceof DataLine.Info) {
            return -1;
        }
        return 0;
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof Port.Info) {
            for (int i2 = 0; i2 < this.ports.length; ++i2) {
                if (!info2.equals(this.ports[i2].getLineInfo())) continue;
                return this.ports[i2];
            }
        }
        if (info2 instanceof DataLine.Info) {
            DataLine.Info info3 = (DataLine.Info)info2;
            AudioFormat[] audioFormatArray = info3.getFormats();
            if (audioFormatArray.length == 0) {
                throw new IllegalArgumentException("Line unsupported: " + info);
            }
            if (info3.getLineClass().isAssignableFrom(InputDeviceDataLine.class)) {
                int n2 = -1;
                AudioFormat audioFormat = null;
                if (info instanceof DataLine.Info) {
                    AudioFormat[] audioFormatArray2 = ((DataLine.Info)info).getFormats();
                    if (audioFormatArray2 != null && audioFormatArray2.length > 0) {
                        audioFormat = audioFormatArray2[audioFormatArray2.length - 1];
                    }
                    if ((n2 = ((DataLine.Info)info).getMaxBufferSize()) == -1) {
                        n2 = ((DataLine.Info)info).getMinBufferSize();
                    }
                    if (n2 <= 0) {
                        n2 = -1;
                    }
                }
                if (audioFormat == null) {
                    audioFormat = audioFormatArray[audioFormatArray.length - 1];
                }
                if (n2 == -1) {
                    n2 = (int)Toolkit.millis2bytes(audioFormat, 500L);
                }
                return new InputDeviceDataLine(info3, this, audioFormat, n2);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    private Port.Info getPortInfo(String string) {
        if (string.equals(Port.Info.MICROPHONE.toString())) {
            return Port.Info.MICROPHONE;
        }
        if (string.equals(Port.Info.LINE_IN.toString())) {
            return Port.Info.LINE_IN;
        }
        if (string.equals(Port.Info.COMPACT_DISC.toString())) {
            return Port.Info.COMPACT_DISC;
        }
        return new InputDevicePortInfo(string);
    }

    private native void nGetFormats(int var1, Vector var2, AudioFormat.Encoding var3, AudioFormat.Encoding var4, AudioFormat.Encoding var5, AudioFormat.Encoding var6);

    private static class InputDeviceDataLine
    extends AbstractDataLine
    implements TargetDataLine {
        private CircularBuffer circularBuffer = null;
        private SimpleInputDevice sid;

        public int available() {
            return this.circularBuffer.bytesAvailableToRead();
        }

        public int getFramePosition() {
            return this.isOpen() ? (int)this.sid.nGetPosition() : super.getFramePosition();
        }

        public void drain() {
            if (this.isOpen()) {
                this.circularBuffer.drain();
                this.sid.nDrain();
            }
        }

        public void flush() {
            if (this.isOpen()) {
                this.circularBuffer.flush();
                this.sid.nFlush();
            }
        }

        void implClose() {
            if (this.sid.jsSecurity != null) {
                this.sid.jsSecurity.checkRecordPermission();
            }
        }

        void implStart() {
            if (this.sid.jsSecurity != null) {
                this.sid.jsSecurity.checkRecordPermission();
            }
        }

        void implStop() {
            if (this.sid.jsSecurity != null) {
                this.sid.jsSecurity.checkRecordPermission();
            }
            this.setActive(false);
            this.setStarted(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer(byte[] byArray, int n2) {
            if (this.isOpen() && this.isStartedRunning()) {
                if (!this.isActive()) {
                    this.setActive(true);
                    this.setStarted(true);
                }
                int n3 = this.circularBuffer.writeover(byArray, 0, n2);
                InputDeviceDataLine inputDeviceDataLine = this;
                synchronized (inputDeviceDataLine) {
                    this.notifyAll();
                }
                if (n3 > 0) {
                    // empty if block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n2, int n3) {
            int n4 = n3;
            if (n3 % this.getFormat().getFrameSize() != 0) {
                throw new IllegalArgumentException("Illegal request to write non-integral number of frames (" + n3 + " bytes )");
            }
            int n5 = 0;
            int n6 = 0;
            while (this.isOpen() && this.isStartedRunning() && n5 < n4) {
                n6 = this.circularBuffer.read(byArray, n2, n4 - n5);
                n2 += n6;
                if ((n5 += n6) >= n4) continue;
                try {
                    InputDeviceDataLine inputDeviceDataLine = this;
                    synchronized (inputDeviceDataLine) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return n5;
        }

        private void checkFormat(AudioFormat audioFormat) throws LineUnavailableException {
            if (this.sid.isOpen()) {
                boolean bl2;
                AudioFormat.Encoding encoding = audioFormat.getEncoding();
                AudioFormat.Encoding encoding2 = this.sid.format.getEncoding();
                boolean bl3 = bl2 = encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding2.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(encoding2);
                if (bl2) {
                    audioFormat = new AudioFormat(encoding2, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), this.sid.format.isBigEndian());
                }
                if (!bl2 || !audioFormat.matches(this.sid.format)) {
                    throw new LineUnavailableException("Requested format incompatible with already established device format: " + this.sid.format);
                }
            }
        }

        void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            if (this.sid.jsSecurity != null) {
                this.sid.jsSecurity.checkRecordPermission();
            }
            if (n2 < 0 || n2 == -1) {
                n2 = (int)Toolkit.millis2bytes(audioFormat, 500L);
            }
            this.checkFormat(audioFormat);
            boolean bl2 = false;
            boolean bl3 = false;
            if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !Platform.isSigned8()) {
                bl2 = true;
            } else if (audioFormat.getSampleSizeInBits() <= 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && Platform.isSigned8()) {
                bl2 = true;
            }
            if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
                bl3 = true;
            }
            this.circularBuffer = new CircularBuffer(n2, bl2, bl3);
            this.bufferSize = n2;
            this.format = audioFormat;
        }

        public void open(AudioFormat audioFormat, int n2) throws LineUnavailableException {
            if (!this.mixer.isOpen()) {
                this.sid.format = audioFormat;
                this.sid.bufferSize = n2;
            }
            super.open(audioFormat, n2);
        }

        private InputDeviceDataLine(DataLine.Info info, SimpleInputDevice simpleInputDevice, AudioFormat audioFormat, int n2) {
            super(info, simpleInputDevice, null, audioFormat, n2);
            this.sid = simpleInputDevice;
        }
    }

    private class InputDevicePort
    extends AbstractLine
    implements Port {
        public synchronized void close() {
            if (this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.setOpen(false);
                this.mixer.close(this);
            }
        }

        public synchronized void open() throws LineUnavailableException {
            if (!this.isOpen()) {
                if (SimpleInputDevice.this.jsSecurity != null) {
                    SimpleInputDevice.this.jsSecurity.checkRecordPermission();
                }
                this.mixer.open(this);
                this.setOpen(true);
            }
        }

        private InputDevicePort(Port.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
            super(info, abstractMixer, controlArray);
        }
    }

    private static class InputDevicePortInfo
    extends Port.Info {
        private InputDevicePortInfo(String string) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = SimpleInputDevice.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, string, true);
        }
    }
}

