/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;

public class KerberosTicket
implements Destroyable,
Refreshable,
Serializable {
    private static int FORWARDABLE_TICKET_FLAG = 1;
    private static int FORWARDED_TICKET_FLAG = 2;
    private static int PROXIABLE_TICKET_FLAG = 3;
    private static int PROXY_TICKET_FLAG = 4;
    private static int POSTDATED_TICKET_FLAG = 6;
    private static int RENEWABLE_TICKET_FLAG = 8;
    private static int INITIAL_TICKET_FLAG = 9;
    private static int NUM_FLAGS = 32;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;
    private transient boolean destroyed = false;

    public final int getSessionKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey.getKeyType();
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.asn1Encoding, (byte)0);
            this.client = null;
            this.server = null;
            this.sessionKey.destroy();
            this.flags = null;
            this.authTime = null;
            this.startTime = null;
            this.endTime = null;
            this.renewTill = null;
            this.clientAddresses = null;
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RefreshFailedException {
        Serializable serializable;
        if (this.destroyed) {
            throw new RefreshFailedException("A destroyed ticket cannot be renewd.");
        }
        if (!this.isRenewable()) {
            throw new RefreshFailedException("This ticket is not renewable");
        }
        if (System.currentTimeMillis() > this.getRenewTill().getTime()) {
            throw new RefreshFailedException("This ticket is past its last renewal time.");
        }
        Exception exception = null;
        Credentials credentials = null;
        try {
            credentials = new Credentials(this.asn1Encoding, this.client.toString(), this.server.toString(), this.sessionKey.getEncoded(), this.sessionKey.getKeyType(), this.flags, this.authTime, this.startTime, this.endTime, this.renewTill, this.clientAddresses);
            credentials = credentials.renew();
        }
        catch (KrbException krbException) {
            exception = krbException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (exception != null) {
            serializable = new RefreshFailedException("Failed to renew Kerberos Ticket for client " + this.client + " and server " + this.server + " - " + exception.getMessage());
            ((Throwable)serializable).initCause(exception);
            throw serializable;
        }
        serializable = this;
        synchronized (serializable) {
            try {
                this.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            this.init(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName()), credentials.getSessionKey().getBytes(), credentials.getSessionKey().getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
            this.destroyed = false;
        }
    }

    public boolean isCurrent() {
        return System.currentTimeMillis() <= this.getEndTime().getTime();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public final boolean isForwardable() {
        return this.flags[FORWARDABLE_TICKET_FLAG];
    }

    public final boolean isForwarded() {
        return this.flags[FORWARDED_TICKET_FLAG];
    }

    public final boolean isInitial() {
        return this.flags[INITIAL_TICKET_FLAG];
    }

    public final boolean isPostdated() {
        return this.flags[POSTDATED_TICKET_FLAG];
    }

    public final boolean isProxiable() {
        return this.flags[PROXIABLE_TICKET_FLAG];
    }

    public final boolean isProxy() {
        return this.flags[PROXY_TICKET_FLAG];
    }

    public final boolean isRenewable() {
        return this.flags[RENEWABLE_TICKET_FLAG];
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return (byte[])this.asn1Encoding.clone();
    }

    public final boolean[] getFlags() {
        return this.flags == null ? null : (boolean[])this.flags.clone();
    }

    public String toString() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.clientAddresses != null) {
            for (int i2 = 0; i2 < this.clientAddresses.length; ++i2) {
                stringBuffer.append("clientAddresses[" + i2 + "] = " + this.clientAddresses[i2].toString());
            }
        }
        return "Ticket (hex) = \n" + new HexDumpEncoder().encode(this.asn1Encoding) + "\n" + "Client Principal = " + this.client.toString() + "\n" + "Server Principal = " + this.server.toString() + "\n" + "Session Key = " + this.sessionKey.toString() + "\n" + "Forwardable Ticket " + this.flags[FORWARDABLE_TICKET_FLAG] + "\n" + "Forwarded Ticket " + this.flags[FORWARDED_TICKET_FLAG] + "\n" + "Proxiable Ticket " + this.flags[PROXIABLE_TICKET_FLAG] + "\n" + "Proxy Ticket " + this.flags[PROXY_TICKET_FLAG] + "\n" + "Postdated Ticket " + this.flags[POSTDATED_TICKET_FLAG] + "\n" + "Renewable Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\n" + "Initial Ticket " + this.flags[RENEWABLE_TICKET_FLAG] + "\n" + "Auth Time = " + this.authTime.toString() + "\n" + "Start Time = " + this.startTime.toString() + "\n" + "End Time = " + this.endTime.toString() + "\n" + "Renew Till = " + (this.renewTill == null ? "Null " : this.renewTill.toString()) + "\n" + "Client Addresses " + (this.clientAddresses == null ? " Null " : stringBuffer.toString() + "\n");
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final Date getAuthTime() {
        return this.authTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final Date getRenewTill() {
        return this.renewTill;
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public final SecretKey getSessionKey() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey;
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public KerberosTicket(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        this.init(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n2, blArray, date, date2, date3, date4, inetAddressArray);
    }

    private void init(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("ASN.1 encoding of ticket cannot be null");
        }
        this.asn1Encoding = byArray;
        if (kerberosPrincipal == null) {
            throw new IllegalArgumentException("Client name in ticket cannot be null");
        }
        this.client = kerberosPrincipal;
        if (kerberosPrincipal2 == null) {
            throw new IllegalArgumentException("Server name in ticket cannot be null");
        }
        this.server = kerberosPrincipal2;
        if (byArray2 == null) {
            throw new IllegalArgumentException("Session key for ticket cannot be null");
        }
        this.sessionKey = new KeyImpl(byArray2, n2);
        if (blArray != null) {
            if (blArray.length >= NUM_FLAGS) {
                this.flags = (boolean[])blArray.clone();
            } else {
                this.flags = new boolean[NUM_FLAGS];
                for (int i2 = 0; i2 < blArray.length; ++i2) {
                    this.flags[i2] = blArray[i2];
                }
            }
        } else {
            this.flags = new boolean[NUM_FLAGS];
        }
        if (blArray[RENEWABLE_TICKET_FLAG]) {
            if (date4 == null) {
                throw new IllegalArgumentException("The renewable period end time cannot be null for renewable tickets.");
            }
            this.renewTill = date4;
        }
        if (date == null) {
            throw new IllegalArgumentException("Authentication time of ticket cannot be null");
        }
        this.authTime = date;
        Date date5 = this.startTime = date2 != null ? date2 : date;
        if (date3 == null) {
            throw new IllegalArgumentException("End time for ticket validity cannot be null");
        }
        this.endTime = date3;
        if (inetAddressArray != null) {
            this.clientAddresses = (InetAddress[])inetAddressArray.clone();
        }
    }
}

