/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Hashtable;
import sun.awt.PlatformFont;

class X11FontMetrics
extends FontMetrics {
    int[] widths;
    int ascent;
    int descent;
    int leading;
    int height;
    int maxAscent;
    int maxDescent;
    int maxHeight;
    int maxAdvance;
    static Hashtable table;

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    static {
        X11FontMetrics.initIDs();
        table = new Hashtable();
    }

    native void init();

    private static native void initIDs();

    public int[] getWidths() {
        return this.widths;
    }

    public native int bytesWidth(byte[] var1, int var2, int var3);

    public int charsWidth(char[] cArray, int n2, int n3) {
        Font font = this.getFont();
        PlatformFont platformFont = (PlatformFont)font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            return this.getMFCharsWidth(cArray, n2, n3, font);
        }
        if (this.widths != null) {
            int n4 = 0;
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                char c2 = cArray[i2];
                if (c2 < '\u0000' || c2 >= this.widths.length) {
                    n4 += this.maxAdvance;
                    continue;
                }
                n4 += this.widths[c2];
            }
            return n4;
        }
        return this.maxAdvance * n3;
    }

    public X11FontMetrics(Font font) {
        super(font);
        this.init();
    }

    private native int getMFCharsWidth(char[] var1, int var2, int var3, Font var4);

    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    static synchronized FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)table.get(font);
        if (fontMetrics == null) {
            fontMetrics = new X11FontMetrics(font);
            table.put(font, fontMetrics);
        }
        return fontMetrics;
    }
}

