/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.FontProperties;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.security.action.GetPropertyAction;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements FontSupport {
    protected static boolean debugMapping;
    private static Font defaultFont;
    private static String[] logicalFontNames;
    private FontProperties fprops;
    private TreeMap terminalNames;
    private HashSet physicalNames;
    private boolean loadedAllFonts = false;
    protected boolean registeredAllPaths = false;
    protected boolean noType1Font = false;
    protected String fontPath;
    protected TreeMap registeredFonts = new TreeMap();
    private Hashtable mapFamilyCache;
    protected boolean loadNativeFonts = false;
    private ArrayList badFonts;
    protected GraphicsDevice[] screens;
    private Font[] allFonts;
    private static Hashtable mapFontCache;
    private static final String FPAKey = "FontPropertiesAttr";
    private static final String FPAName = "PLSFFallback";
    private static final String PLSF_PREFIX = "_plsf_";
    private String prefixPLSF = null;
    private boolean initPLSFFallback = false;
    private FontProperties fpropsPLSF = null;
    protected static boolean hasPLSF;
    protected static String fallbackFont;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract int getNumScreens();

    static {
        $assertionsDisabled = !SunGraphicsEnvironment.class.desiredAssertionStatus();
        debugMapping = false;
        logicalFontNames = new String[]{"default", "serif", "sansserif", "monospaced", "dialog", "dialoginput"};
        mapFontCache = new Hashtable(5, 0.9f);
        hasPLSF = false;
        fallbackFont = null;
    }

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                Object object;
                Object object2;
                if (System.getProperty("sun.java2d.debugfonts") != null) {
                    debugMapping = true;
                }
                SunGraphicsEnvironment.this.fontPath = System.getProperty("sun.java2d.fontpath");
                String string2 = System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts";
                File file = new File(string2 + File.separator + "badfonts.txt");
                if (file.exists()) {
                    object2 = null;
                    try {
                        SunGraphicsEnvironment.this.badFonts = new ArrayList();
                        object2 = new FileInputStream(file);
                        object = new InputStreamReader((InputStream)object2);
                        BufferedReader bufferedReader = new BufferedReader((Reader)object);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (debugMapping) {
                                System.out.println("read bad font " + string);
                            }
                            SunGraphicsEnvironment.this.badFonts.add(string);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (object2 != null) {
                                ((FileInputStream)object2).close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
                SunGraphicsEnvironment.this.registerFontsWithPlatform(string2);
                SunGraphicsEnvironment.this.fprops = SunGraphicsEnvironment.this.createFontProperties();
                object2 = null;
                if (SunGraphicsEnvironment.this.fprops != null) {
                    object2 = SunGraphicsEnvironment.this.fprops.getProperty("appendedfontpath");
                }
                if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                    object = System.getProperty("sun.java2d.noType1Font");
                    if (object == null) {
                        SunGraphicsEnvironment.this.noType1Font = NativeFontWrapper.getType1FontVar();
                    }
                    if ("true".equals(object)) {
                        SunGraphicsEnvironment.this.noType1Font = true;
                    }
                    SunGraphicsEnvironment.this.loadNativeFonts = true;
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getBasePlatformFontPath(SunGraphicsEnvironment.this.noType1Font);
                    SunGraphicsEnvironment.this.fontPath = string2 + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                    if (object2 != null) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + (String)object2;
                    } else if (!SunGraphicsEnvironment.this.registeredAllPaths) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + SunGraphicsEnvironment.this.getPlatformFontPath(SunGraphicsEnvironment.this.noType1Font);
                    }
                    if (debugMapping) {
                        System.out.println("Platform Font Path=" + SunGraphicsEnvironment.this.fontPath);
                    }
                }
                SunGraphicsEnvironment.this.registerFontPaths(SunGraphicsEnvironment.this.fontPath);
                SunGraphicsEnvironment.this.registerFonts(string2, true);
                SunGraphicsEnvironment.this.initCompositeFonts(SunGraphicsEnvironment.this.fprops);
                object = SunGraphicsEnvironment.this.registeredFonts.keySet().toArray();
                for (int i2 = 0; i2 < ((Object[])object).length; ++i2) {
                    string = (String)object[i2];
                    String string3 = NativeFontWrapper.getFullNameByFileName(string);
                    if (string3 != null) {
                        string3 = string3.toLowerCase();
                    }
                    if (string3 == null || SunGraphicsEnvironment.this.terminalNames.containsKey(string3)) continue;
                    SunGraphicsEnvironment.this.terminalNames.put(string3, new Integer(0));
                }
                return null;
            }
        });
    }

    protected synchronized void loadFonts() {
        String string;
        if (this.loadedAllFonts) {
            return;
        }
        if (debugMapping) {
            System.out.println("loadfonts called");
        }
        if (!this.registeredAllPaths) {
            string = this.getPlatformFontPath(this.noType1Font);
            this.registerFontPaths(string);
            this.fontPath = this.fontPath + File.separator + string;
        } else {
            string = this.fontPath;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl2 = SunGraphicsEnvironment.this.registerFonts(string, false);
                boolean bl3 = false;
                if (SunGraphicsEnvironment.this.loadNativeFonts) {
                    bl3 = SunGraphicsEnvironment.this.registerNativeFonts();
                }
                if (!bl2 && !bl3 && SunGraphicsEnvironment.this.registeredFonts.size() == 0) {
                    System.out.println("\nNo fonts were found in '" + string + "'.\n");
                    System.exit(2);
                }
                SunGraphicsEnvironment.this.loadedAllFonts = true;
                return null;
            }
        });
    }

    public static void preferLocaleSpecificFonts() {
        hasPLSF = true;
        AppContext.getAppContext().put(FPAKey, FPAName);
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    public Font[] getAllFonts() {
        if (this.allFonts != null) {
            return this.allFonts;
        }
        this.loadFonts();
        Font[] fontArray = null;
        String[] stringArray = null;
        int n2 = NativeFontWrapper.getNumFonts();
        if (n2 > 0) {
            TreeMap treeMap = new TreeMap();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = NativeFontWrapper.getFullNameByIndex(i2);
                if (string.startsWith(PLSF_PREFIX)) continue;
                treeMap.put(string, null);
            }
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                Object[] objectArray = treeMap.keySet().toArray();
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    stringArray[i3] = (String)objectArray[i3];
                }
            }
        }
        if (stringArray != null) {
            fontArray = new Font[stringArray.length];
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                fontArray[i4] = new Font(stringArray[i4], 0, 1);
            }
        }
        this.allFonts = fontArray;
        return this.allFonts;
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        if (string == null || font == null) {
            return false;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        return NativeFontWrapper.fontSupportsEncoding(font, string);
    }

    public static boolean isLogicalFont(Font font) {
        String string = font.getFamily();
        return SunGraphicsEnvironment.isLogicalFont(string);
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n2 = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                graphicsDeviceArray[i2] = this.makeScreenDevice(i2);
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public static String styleStr(int n2) {
        switch (n2) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    protected void addPlatformNameForFontProperties(String string) {
    }

    protected void registerFontPath(String string) {
    }

    protected void registerFontPaths(String string) {
    }

    protected void registerFontsWithPlatform(String string) {
    }

    protected void registerNative(String string) {
    }

    public static void setFallbackFont(String string) {
        fallbackFont = string;
        AppContext.getAppContext().put(FPAKey, FPAName);
    }

    public static boolean isLogicalFont(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (int i2 = 0; i2 < logicalFontNames.length; ++i2) {
            if (!string.equals(logicalFontNames[i2])) continue;
            return true;
        }
        return false;
    }

    private boolean registerFonts(String string, boolean bl2) {
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                bl3 |= this.addPathFonts(string2, new TTFilter(), 0, bl2);
                bl3 |= this.addPathFonts(string2, new T1Filter(), 1, bl2);
                bl3 |= this.addPathFonts(string2, new T2KFilter(), 2, bl2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        return bl3;
    }

    protected String getBasePlatformFontPath(boolean bl2) {
        return this.getPlatformFontPath(bl2);
    }

    protected String getPlatformFontPath(boolean bl2) {
        this.registeredAllPaths = true;
        return NativeFontWrapper.getFontPath(bl2);
    }

    protected void addPlatformCompatibilityFileNames(Map map) {
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = (String)objectArray[i2];
            HashSet hashSet = (HashSet)treeMap.get(string);
            String[] stringArray = (String[])hashSet.toArray(new String[0]);
            Vector vector = this.getNativeNames(string);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (vector.contains(stringArray[i3])) continue;
                vector.add(stringArray[i3]);
            }
            this.registerFontFile(string, vector);
        }
    }

    protected abstract FontProperties createFontProperties();

    public FontProperties getFontProperties() {
        if (!FPAName.equals(AppContext.getAppContext().get(FPAKey)) || this.fpropsPLSF == null) {
            return this.fprops;
        }
        return this.fpropsPLSF;
    }

    private void initCompositeFonts(FontProperties fontProperties) {
        TreeMap treeMap = this.initTerminalNames(fontProperties);
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2;
            Object object;
            String string = (String)objectArray[i2];
            Integer n3 = (Integer)treeMap.get(objectArray[i2]);
            int n4 = n3;
            boolean bl2 = false;
            for (int i3 = 0; i3 < n4; ++i3) {
                object = this.parseFamilyNameProperty(fontProperties.getProperty(string + "." + i3));
                if (((String)object).compareToIgnoreCase("Lucida Sans Regular") != 0) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                ++n4;
            }
            if (fallbackFont != null && this.terminalNames.containsKey(fallbackFont.toLowerCase(Locale.ENGLISH))) {
                ++n4;
            }
            String[] stringArray = new String[n4];
            object = new int[n4];
            int[] nArray = new int[]{};
            int n5 = n4;
            if (!bl2) {
                stringArray[n4 - 1] = "Lucida Sans Regular";
                --n5;
            }
            if (fallbackFont != null && this.terminalNames.containsKey(fallbackFont.toLowerCase(Locale.ENGLISH))) {
                if (!bl2) {
                    stringArray[n4 - 2] = "Lucida Sans Regular";
                }
                stringArray[n4 - 1] = fallbackFont;
                --n5;
            }
            for (n2 = 0; n2 < n5; ++n2) {
                stringArray[n2] = this.parseFamilyNameProperty(fontProperties.getProperty(string + "." + n2));
                if (debugMapping) {
                    System.out.println("The composite name = " + stringArray[n2]);
                }
                nArray = this.appendExclusions(fontProperties, string, n2, nArray);
                object[n2] = nArray.length;
            }
            if (debugMapping) {
                System.out.println("initCompositeFonts compositeFontName=" + string);
            }
            if (this.initPLSFFallback) {
                string = this.prefixPLSF + string;
            }
            if (debugMapping) {
                System.out.println("registerCompositeFont:" + string);
                for (n2 = 0; n2 < n4; ++n2) {
                    System.out.println("    slot=" + stringArray[n2]);
                }
            }
            NativeFontWrapper.registerCompositeFont(string, stringArray, nArray, (int[])object);
        }
        treeMap.put("default", new Integer(0));
        if (!this.initPLSFFallback) {
            this.terminalNames = treeMap;
        }
    }

    public static Font getBestFontFor(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        char c2 = attributedCharacterIterator.setIndex(n2);
        Map map = attributedCharacterIterator.getAttributes();
        Font font = Font.getFont(map);
        while (!font.canDisplay(c2) && attributedCharacterIterator.getRunLimit() < n3) {
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            font = Font.getFont(attributedCharacterIterator.getAttributes());
        }
        if (!font.canDisplay(c2)) {
            attributedCharacterIterator.setIndex(n2);
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Hashtable hashtable = new Hashtable();
                hashtable.putAll(map);
                hashtable.put(TextAttribute.FAMILY, stringArray[i2]);
                font = Font.getFont(hashtable);
                if (font.canDisplay(c2)) break;
            }
            if (!font.canDisplay(c2)) {
                font = Font.getFont(map);
            }
        }
        return font;
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        if (defaultFont == null) {
            defaultFont = new Font("Dialog", 0, 12);
        }
        return new SunGraphics2D(surfaceData, Color.white, Color.black, defaultFont);
    }

    public static Rectangle getUsableBounds(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    private boolean addPathFonts(String string, FilenameFilter filenameFilter, int n2, boolean bl2) {
        boolean bl3 = false;
        Vector vector = new Vector(20, 10);
        Vector vector2 = new Vector(20, 10);
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return bl3;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file2 = new File(file, stringArray[i2]);
            String string2 = null;
            try {
                string2 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file2.getAbsolutePath();
            }
            if (this.registeredFonts.containsKey(string2)) continue;
            if (this.badFonts != null && this.badFonts.contains(string2)) {
                if (!debugMapping) continue;
                System.out.println("skip bad font " + string2);
                continue;
            }
            this.registeredFonts.put(string2, string2);
            if (debugMapping) {
                System.out.println("Registering font " + string2);
                Vector vector3 = this.getNativeNames(string2);
                if (vector3.size() == 0) {
                    System.out.println("No native name");
                } else {
                    for (int i3 = 0; i3 < vector3.size(); ++i3) {
                        System.out.println("native name : " + (String)vector3.elementAt(i3));
                    }
                }
            }
            vector.addElement(string2);
            vector2.addElement(this.getNativeNames(string2));
            bl3 = true;
        }
        NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n2, bl2);
        return bl3;
    }

    public static String createFont(File file) {
        return NativeFontWrapper.createFont(file.getAbsolutePath(), 0);
    }

    protected String getFileNameFromPlatformName(String string) {
        if (this.fprops == null) {
            return null;
        }
        string = string.replace(' ', '_');
        return this.fprops.getProperty("filename." + string);
    }

    protected String getFontPropertyFD(String string) {
        return this.parseFamilyNameProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInternalFontName(String string) {
        if (!hasPLSF && fallbackFont == null) {
            return string;
        }
        Object object = AppContext.getAppContext().get(FPAKey);
        if (object == null || !object.equals(FPAName)) {
            return string;
        }
        String string2 = string.toLowerCase();
        boolean bl2 = false;
        for (int i2 = 0; i2 < logicalFontNames.length; ++i2) {
            if (!string2.startsWith(logicalFontNames[i2])) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return string;
        }
        if (this.prefixPLSF != null) {
            return this.prefixPLSF + string;
        }
        SunGraphicsEnvironment sunGraphicsEnvironment = this;
        synchronized (sunGraphicsEnvironment) {
            if (this.prefixPLSF != null) {
                return this.prefixPLSF + string;
            }
            this.fpropsPLSF = hasPLSF ? this.fprops.applyPreferLocaleSpecificFonts(this.fprops) : this.fprops;
            this.initPLSFFallback = true;
            this.prefixPLSF = PLSF_PREFIX;
            this.initCompositeFonts(this.fpropsPLSF);
            return this.prefixPLSF + string;
        }
    }

    protected String parseFamilyNameProperty(String string) {
        int n2 = string.indexOf(",");
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    private String getLogicalFontFaceName(String string, int n2) {
        String string2 = string.toLowerCase(Locale.ENGLISH) + "." + SunGraphicsEnvironment.styleStr(n2);
        if (this.terminalNames.containsKey(string2)) {
            return string2;
        }
        return string;
    }

    public String mapFontName(String string, int n2) {
        String string2;
        String string3 = (String)mapFontCache.get(string + "." + SunGraphicsEnvironment.styleStr(n2));
        if (string3 != null) {
            if (this.fprops.supportPLSF() || fallbackFont != null) {
                return this.getInternalFontName(string3);
            }
            return string3;
        }
        String string4 = string.toLowerCase(Locale.ENGLISH);
        if (string4.equals("sanserif") || string4.equals("san serif") || string4.equals("sans serif") || string4.equals("ms sans serif")) {
            string4 = "sansserif";
        } else if (string4.equals("ms serif")) {
            string4 = "serif";
        }
        if (FontProperties.isLogicalFontFamilyName(string4)) {
            string3 = this.getLogicalFontFaceName(string4, n2);
        }
        if (string3 == null && (string2 = this.fprops.getAliasedFamilyName(string4)) != null) {
            string3 = this.getLogicalFontFaceName(string2, n2);
        }
        if (string3 == null) {
            if (this.fprops.getFallbackFamilyName(string4, null) != null) {
                if (this.loadedAllFonts) {
                    if (NativeFontWrapper.isFontRegistered(string, n2)) {
                        string3 = string;
                    }
                } else if (NativeFontWrapper.isFontRegistered(string, n2)) {
                    string3 = string;
                } else {
                    if (debugMapping) {
                        System.out.println("calling loadFonts to find font " + string);
                    }
                    this.loadFonts();
                    if (NativeFontWrapper.isFontRegistered(string, n2)) {
                        string3 = string;
                    }
                }
                if (string3 == null) {
                    string2 = this.fprops.getFallbackFamilyName(string4, "dialog");
                    string3 = this.getLogicalFontFaceName(string2, n2);
                }
            } else {
                if (!(this.terminalNames.containsKey(string4) || this.physicalNames != null && this.physicalNames.contains(string4))) {
                    if (debugMapping) {
                        System.out.println("calling loadFonts to find font " + string);
                    }
                    this.loadFonts();
                }
                string3 = string;
            }
        }
        if (!$assertionsDisabled && string3 == null) {
            throw new AssertionError();
        }
        if (debugMapping) {
            System.out.println("mapped font " + string + " (" + SunGraphicsEnvironment.styleStr(n2) + ") " + " to " + string3);
        }
        mapFontCache.put(string + "." + SunGraphicsEnvironment.styleStr(n2), string3);
        if (this.fprops.supportPLSF() || fallbackFont != null) {
            if (debugMapping) {
                string2 = this.getInternalFontName(string3);
                System.out.println("==============================================================");
                System.out.println("originalName  =" + string3 + ", localeName=" + string2);
                System.out.println("currentThread=" + Thread.currentThread());
                return string2;
            }
            return this.getInternalFontName(string3);
        }
        return string3;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        if (locale == null) {
            return this.getAvailableFontFamilyNames();
        }
        this.loadFonts();
        String[] stringArray = null;
        int n2 = NativeFontWrapper.getNumFonts();
        short s2 = NativeFontWrapper.getLCIDFromLocale(locale);
        if (n2 > 0) {
            Object[] objectArray;
            TreeMap treeMap = new TreeMap();
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray = NativeFontWrapper.getFamilyNameByIndex(i2, s2);
                String string = objectArray.toLowerCase();
                if (string.endsWith(".bold") || string.endsWith(".bolditalic") || string.endsWith(".italic") || string.startsWith(PLSF_PREFIX)) continue;
                treeMap.put(string, objectArray);
            }
            String string = "Serif";
            treeMap.put(string.toLowerCase(), string);
            string = "SansSerif";
            treeMap.put(string.toLowerCase(), string);
            string = "Monospaced";
            treeMap.put(string.toLowerCase(), string);
            string = "Dialog";
            treeMap.put(string.toLowerCase(), string);
            string = "DialogInput";
            treeMap.put(string.toLowerCase(), string);
            string = "Default";
            treeMap.put(string.toLowerCase(), string);
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    stringArray[i3] = (String)treeMap.get(objectArray[i3]);
                }
            }
        }
        return stringArray;
    }

    private int[] appendExclusions(FontProperties fontProperties, String string, int n2, int[] nArray) {
        int n3;
        String string2;
        String string3;
        int n4 = string.indexOf(46);
        if (n4 > 0) {
            string3 = string.substring(0, n4);
            string2 = string.substring(n4 + 1);
        } else {
            string3 = string;
            string2 = "plain";
        }
        String string4 = fontProperties.getProperty("exclusion." + string3 + "." + string2 + "." + n2);
        if (string4 == null) {
            string4 = fontProperties.getProperty("exclusion." + string3 + "." + n2);
        }
        if (string4 != null && (n3 = (string4.length() + 1) / 10) > 0) {
            Object object;
            int n5;
            int[] nArray2 = new int[n3 * 2];
            for (n5 = 0; n5 < n3; ++n5) {
                object = string4.substring(n5 * 10, n5 * 10 + 4);
                String string5 = string4.substring(n5 * 10 + 5, n5 * 10 + 9);
                nArray2[n5 * 2] = Integer.parseInt((String)object, 16);
                nArray2[n5 * 2 + 1] = Integer.parseInt(string5, 16);
            }
            n5 = nArray.length + nArray2.length;
            object = new int[n5];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            System.arraycopy(nArray2, 0, object, nArray.length, nArray2.length);
            nArray = object;
        }
        return nArray;
    }

    private TreeMap initTerminalNames(FontProperties fontProperties) {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        TreeMap treeMap3 = new TreeMap();
        this.addPlatformCompatibilityFileNames(treeMap2);
        String string = "Serif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        if (fontProperties == null) {
            throw new Error("no font properties file found.");
        }
        Object[] objectArray = fontProperties.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string2;
            String string3;
            String string4 = (String)objectArray[i2];
            int n2 = string4.indexOf(".");
            if (n2 == -1) {
                n2 = string4.length();
            }
            if (!treeMap.containsKey(string3 = string4.substring(0, n2)) || (n2 = string4.lastIndexOf(".")) == -1 || treeMap3.containsKey(string2 = string4.substring(0, n2)) || !fontProperties.containsKey(string2 + ".0")) continue;
            int n3 = 0;
            while (fontProperties.containsKey(string2 + "." + n3)) {
                ++n3;
            }
            if (n3 == 0) continue;
            treeMap3.put(string2, new Integer(n3));
            if (debugMapping) {
                System.out.println("FamilyStyle: " + string2);
                System.out.println("NumSlots: " + n3);
                System.out.println("Key: " + (String)objectArray[i2]);
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                String string5 = this.getFontPropertyFD(fontProperties.getProperty(string2 + "." + i3));
                if (!this.initPLSFFallback) {
                    this.addPlatformNameForFontProperties(string5);
                }
                String string6 = this.getFileNameFromPlatformName(string5);
                if (debugMapping) {
                    System.out.println("FS: [" + string2 + "." + i3 + "] PN: [" + string5 + "] FN: [" + string6 + "]");
                }
                if (string6 == null) {
                    if (debugMapping) {
                        System.err.println("Font specified in font.properties not found [" + string5 + "]");
                    }
                    this.loadFonts();
                    continue;
                }
                HashSet hashSet = (HashSet)treeMap2.get(string6);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashSet.add(string5);
                    treeMap2.put(string6, hashSet);
                    continue;
                }
                if (hashSet.contains(string5)) continue;
                hashSet.add(string5);
            }
        }
        if (!this.initPLSFFallback) {
            this.registerFontPropertiesFonts(treeMap2);
        }
        return treeMap3;
    }

    protected Vector getNativeNames(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected void registerFontFile(String string, Vector vector) {
        int n2;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new TTFilter().accept(null, string)) {
            n2 = 0;
        } else if (new T1Filter().accept(null, string)) {
            n2 = 1;
        } else if (new T2KFilter().accept(null, string)) {
            n2 = 2;
        } else {
            this.registerNative(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, string);
                String string4 = null;
                try {
                    string4 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = file.getAbsolutePath();
                }
                if (!file.canRead()) continue;
                Vector vector2 = new Vector(1, 1);
                Vector vector3 = new Vector(1, 1);
                vector3.addElement(vector);
                vector2.addElement(string4);
                this.registeredFonts.put(string, string4);
                NativeFontWrapper.registerFonts(vector2, vector2.size(), vector3, n2, false);
                if (this.physicalNames == null) {
                    this.physicalNames = new HashSet();
                }
                if ((string2 = NativeFontWrapper.getFullNameByFileName(string4)) != null) {
                    string2 = string2.toLowerCase();
                }
                if (!this.physicalNames.contains(string2)) {
                    this.physicalNames.add(string2);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    public class T1Filter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ps") || string.endsWith(".PS") || string.endsWith(".pfb") || string.endsWith(".PFB") || string.endsWith(".pfa") || string.endsWith(".PFA");
        }
    }

    public class T2KFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".t2k") || string.endsWith(".T2K");
        }
    }

    public class TTFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
        }
    }
}

