/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Hashtable;
import sun.security.provider.DSA;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;
import sun.security.x509.AlgIdDSA;

public class DSAKeyPairGenerator
extends KeyPairGenerator
implements java.security.interfaces.DSAKeyPairGenerator {
    private static Hashtable precomputedParams = new Hashtable();
    private int modlen = 1024;
    boolean generateNewParameters = false;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    SecureRandom random;
    private static int[] testXSeed;
    private int[] x_t = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};

    static {
        BigInteger bigInteger = new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16);
        BigInteger bigInteger2 = new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16);
        BigInteger bigInteger3 = new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16);
        BigInteger bigInteger4 = new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16);
        BigInteger bigInteger5 = new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16);
        BigInteger bigInteger6 = new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16);
        BigInteger bigInteger7 = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
        BigInteger bigInteger8 = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
        BigInteger bigInteger9 = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
        try {
            AlgIdDSA algIdDSA = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
            AlgIdDSA algIdDSA2 = new AlgIdDSA(bigInteger4, bigInteger5, bigInteger6);
            AlgIdDSA algIdDSA3 = new AlgIdDSA(bigInteger7, bigInteger8, bigInteger9);
            precomputedParams.put(new Integer(512), algIdDSA);
            precomputedParams.put(new Integer(768), algIdDSA2);
            precomputedParams.put(new Integer(1024), algIdDSA3);
        }
        catch (Exception exception) {
            throw new InternalError("initializing precomputed algorithm parameters for Sun DSA");
        }
        testXSeed = new int[]{-1123902530, 2136053259, -811672789, 1643147023, -346408778};
    }

    public DSAKeyPairGenerator() {
        super("DSA");
    }

    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        if (this.presetP == null || this.presetQ == null || this.presetG == null || this.generateNewParameters) {
            DSAParameterSpec dSAParameterSpec;
            AlgorithmParameterGenerator algorithmParameterGenerator;
            try {
                algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "SUN");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException.getMessage());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException(noSuchProviderException.getMessage());
            }
            algorithmParameterGenerator.init(this.modlen, this.random);
            try {
                dSAParameterSpec = (DSAParameterSpec)algorithmParameterGenerator.generateParameters().getParameterSpec(DSAParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.getMessage());
            }
            this.presetP = dSAParameterSpec.getP();
            this.presetQ = dSAParameterSpec.getQ();
            this.presetG = dSAParameterSpec.getG();
        }
        return this.generateKeyPair(this.presetP, this.presetQ, this.presetG, this.random);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 1024 || n2 % 64 != 0) {
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        this.random = secureRandom;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.modlen = n2;
        DSAParams dSAParams = null;
        if (!this.generateNewParameters) {
            Integer n3 = new Integer(this.modlen);
            dSAParams = (DSAParams)precomputedParams.get(n3);
        }
        if (dSAParams != null) {
            this.setParams(dSAParams);
        }
    }

    public void initialize(int n2, boolean bl2, SecureRandom secureRandom) throws InvalidParameterException {
        if (!bl2 && n2 != 512 && n2 != 768 && n2 != 1024) {
            throw new InvalidParameterException("No precomputed parameters for requested modulus size available");
        }
        this.generateNewParameters = bl2;
        this.initialize(n2, secureRandom);
    }

    private void setParams(DSAParams dSAParams) {
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
    }

    private void setParams(DSAParameterSpec dSAParameterSpec) {
        this.presetP = dSAParameterSpec.getP();
        this.presetQ = dSAParameterSpec.getQ();
        this.presetG = dSAParameterSpec.getG();
    }

    BigInteger generateX(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        int[] nArray3 = DSA.SHA_7(nArray, nArray2);
        byte[] byArray = new byte[nArray3.length * 4];
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            int n2 = nArray3[i2];
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray[i2 * 4 + i3] = (byte)(n2 >>> 24 - i3 * 8);
            }
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    public void initialize(DSAParams dSAParams, SecureRandom secureRandom) throws InvalidParameterException {
        this.initialize(dSAParams.getP().bitLength(), secureRandom);
        this.setParams(dSAParams);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter");
        }
        this.initialize(((DSAParameterSpec)algorithmParameterSpec).getP().bitLength(), secureRandom);
        this.setParams((DSAParameterSpec)algorithmParameterSpec);
    }

    private BigInteger generateX(SecureRandom secureRandom, BigInteger bigInteger) {
        int[] nArray;
        BigInteger bigInteger2 = null;
        do {
            nArray = new int[5];
            for (int i2 = 0; i2 < 5; ++i2) {
                nArray[i2] = secureRandom.nextInt();
            }
        } while ((bigInteger2 = this.generateX(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    BigInteger generateY(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
        return bigInteger4;
    }

    public KeyPair generateKeyPair(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, SecureRandom secureRandom) {
        BigInteger bigInteger4 = this.generateX(secureRandom, bigInteger2);
        BigInteger bigInteger5 = this.generateY(bigInteger4, bigInteger, bigInteger3);
        try {
            DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInteger5, bigInteger, bigInteger2, bigInteger3);
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyPair keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }
}

