/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot;

import com.panayotis.gnuplot.GNUPlotException;
import com.panayotis.gnuplot.GNUPlotExec;
import com.panayotis.gnuplot.GNUPlotParameters;
import com.panayotis.gnuplot.layout.GraphLayout;
import com.panayotis.gnuplot.plot.Axis;
import com.panayotis.gnuplot.plot.Graph;
import com.panayotis.gnuplot.plot.Page;
import com.panayotis.gnuplot.plot.Plot;
import com.panayotis.gnuplot.terminal.DefaultTerminal;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import com.panayotis.iodebug.Debug;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNUPlot {
    private static final long serialVersionUID;
    private GNUPlotParameters param;
    private transient GNUPlotTerminal term;
    private transient GNUPlotExec exec;
    private static transient Debug dbg;

    public GNUPlot() throws GNUPlotException {
        this(null, null, null, false);
    }

    public GNUPlot(boolean isGraph3D) throws GNUPlotException {
        this(null, null, null, isGraph3D);
    }

    public GNUPlot(GNUPlotParameters par) throws GNUPlotException {
        this(par, null, null, false);
    }

    public GNUPlot(String gnuplotpath) throws GNUPlotException {
        this(null, gnuplotpath, null, false);
    }

    public GNUPlot(String gnuplotpath, boolean isGraph3D) throws GNUPlotException {
        this(null, gnuplotpath, null, isGraph3D);
    }

    public GNUPlot(GNUPlotParameters par, String gnuplotpath, GNUPlotTerminal term) throws GNUPlotException {
        this(par, gnuplotpath, term, false);
    }

    public GNUPlot(GNUPlotParameters par, String gnuplotpath, GNUPlotTerminal term, boolean isGraph3D) throws GNUPlotException {
        if (par == null) {
            par = new GNUPlotParameters(isGraph3D);
        }
        this.param = par;
        if (term == null) {
            term = new DefaultTerminal();
        }
        this.term = term;
        try {
            this.exec = new GNUPlotExec(gnuplotpath);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (gnuplotpath == null) {
                msg = msg + " Please provide gnuplot path to the constructor of GNUPlot.";
            }
            throw new GNUPlotException(msg);
        }
    }

    public void set(String key, String value) {
        this.param.set(key, value);
    }

    public Axis getAxis(String axisname) {
        return this.param.getAxis(axisname);
    }

    public void addPlot(Plot plot) {
        if (plot == null) {
            return;
        }
        this.param.addPlot(plot);
    }

    public void addGraph(Graph gr) {
        this.param.addGraph(gr);
    }

    public void newGraph() {
        this.param.newGraph();
    }

    public void newGraph3D() {
        this.param.newGraph3D();
    }

    public void setMultiTitle(String title) {
        this.param.setMultiTitle(title);
    }

    public ArrayList<Plot> getPlots() {
        return this.param.getPlots();
    }

    public Page getPage() {
        return this.param.getPage();
    }

    public GraphLayout getLayout() {
        return this.param.getLayout();
    }

    public void plot() throws GNUPlotException {
        this.exec.plot(this.param, this.term);
    }

    public String getCommands() {
        return this.exec.getCommands(this.param, this.term);
    }

    public void setGNUPlotPath(String path) throws IOException {
        this.exec.setGNUPlotPath(path);
    }

    public String getGNUPlotPath() {
        return this.exec.getGNUPlotPath();
    }

    public void setPersist(boolean ispersist) {
        this.exec.setPersist(ispersist);
    }

    public void setParameters(GNUPlotParameters parameters) {
        if (this.param == null) {
            return;
        }
        this.param = parameters;
    }

    public GNUPlotParameters getParameters() {
        return this.param;
    }

    public void setTerminal(GNUPlotTerminal term) {
        if (term == null) {
            return;
        }
        this.term = term;
    }

    public GNUPlotTerminal getTerminal() {
        return this.term;
    }

    public static Debug getDebugger() {
        return dbg;
    }

    public ArrayList<String> getPreInit() {
        return this.param.getPreInit();
    }

    public ArrayList<String> getPostInit() {
        return this.param.getPostInit();
    }

    static {
        dbg = new Debug();
    }
}

